(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24143,        813]
NotebookOptionsPosition[     19959,        676]
NotebookOutlinePosition[     21189,        712]
CellTagsIndexPosition[     21104,        707]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "Bit" :> 
          Documentation`HelpLookup["paclet:ref/format/Bit"], "Byte" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"], "Character8" :> 
          Documentation`HelpLookup["paclet:ref/format/Character8"], 
          "Character16" :> 
          Documentation`HelpLookup["paclet:ref/format/Character16"], 
          "Integer8" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer8"], "Integer16" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer16"], 
          "Integer24" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer24"], 
          "Integer32" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer32"], 
          "Integer64" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer64"], 
          "Integer128" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer128"], 
          "UnsignedInteger8" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger8"], 
          "UnsignedInteger16" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger16"], 
          "UnsignedInteger24" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger24"], 
          "UnsignedInteger32" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger32"], 
          "UnsignedInteger64" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger64"], 
          "UnsignedInteger128" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger128"], 
          "Real32" :> Documentation`HelpLookup["paclet:ref/format/Real32"], 
          "Real64" :> Documentation`HelpLookup["paclet:ref/format/Real64"], 
          "Complex64" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex64"], 
          "Complex128" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex128"], 
          "Complex256" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex256"], "String" :> 
          Documentation`HelpLookup["paclet:ref/format/String"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary\"\>", 2->"\<\"Bit\"\>", 
       3->"\<\"Byte\"\>", 4->"\<\"Character8\"\>", 5->"\<\"Character16\"\>", 
       6->"\<\"Integer8\"\>", 7->"\<\"Integer16\"\>", 8->"\<\"Integer24\"\>", 
       9->"\<\"Integer32\"\>", 10->"\<\"Integer64\"\>", 
       11->"\<\"Integer128\"\>", 12->"\<\"UnsignedInteger8\"\>", 
       13->"\<\"UnsignedInteger16\"\>", 14->"\<\"UnsignedInteger24\"\>", 
       15->"\<\"UnsignedInteger32\"\>", 16->"\<\"UnsignedInteger64\"\>", 
       17->"\<\"UnsignedInteger128\"\>", 18->"\<\"Real32\"\>", 
       19->"\<\"Real64\"\>", 20->"\<\"Complex64\"\>", 
       21->"\<\"Complex128\"\>", 22->"\<\"Complex256\"\>", 
       23->"\<\"String\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Real128", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Uniform sequence of IEEE quad-precision numbers.
Binary data format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read arbitrary binary data as a sequence of quad-precision numbers."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can convert a list of arbitrary integers or reals to binary quad-precision \
numbers."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Real128\>\""}], "]"}]], 
  "InlineFormula"],
 " imports any file as 128-bit IEEE quad-precision numbers, returning a \
packed array of real numbers."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<Real128\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of real numbers to ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Real128\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Real128\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "Real128",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "list of real numbers", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Real128\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "reads the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quad-precision number from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->61452522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " for IEEE \"infinity\", and ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " for IEEE \[OpenCurlyDoubleQuote]not\[Hyphen]a\[Hyphen]number\
\[CloseCurlyDoubleQuote]. "
}], "FormatNotes",
 CellID->1851343939],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Bit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex256",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex256"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->344804987]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->657390947],

Cell["\<\
Convert a list of integers and reals to IEEE quad-precision numbers: \
\>", "ExampleText",
 CellID->1096476082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "2.5", ",", "Pi", ",", "E"}], "}"}], ",", 
   " ", "\"\<Real128\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946785396],

Cell[BoxData["\<\"\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\
\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\[YDoubleDot]?\.00\
\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00\.00@\.00@\.b8\.01\.17\
\[CapitalARing]\.8c\.89i\.84\[CapitalNTilde]BD\[Micro]\.1f\.92\.00@zN@\[Not]\
\.b8_5\.95vE\[PlusMinus]\.a8\[Eth][\.00@\"\>"], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"Out[1]=",
 CellID->761783940]
}, Open  ]],

Cell[TextData[{
 "Convert the previous result back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " numbers:"
}], "ExampleText",
 CellID->916335267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", " ", "\"\<Real128\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->196716535],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0``4965.188748481706", ",", "1.`33.71535951436589", ",", 
   "2.5`33.71535951436589", ",", 
   "3.141592653589793238462643383279502797479068098137`33.71535951436589", 
   ",", "2.718281828459045235360287471352662314358421867194`33.\
71535951436589"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->5176166]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Real128 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 50, 46.5601042}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran", "IEEE 754"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Uniform sequence of IEEE quad-precision numbers. Binary data format.", 
    "synonyms" -> {}, "title" -> "Real128", "type" -> "Format", "uri" -> 
    "ref/format/Real128"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18165, 608, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20970, 700}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3997, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4620, 107, 53, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[4676, 110, 118, 4, 70, "FormatUsage",
 CellID->37585799],
Cell[4797, 116, 245, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[5045, 125, 260, 8, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5342, 138, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5409, 141, 384, 12, 70, "FormatNotes",
 CellID->28652],
Cell[5796, 155, 417, 15, 70, "FormatNotes",
 CellID->8194],
Cell[6216, 172, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6258, 175, 745, 27, 70, "FormatNotes",
 CellID->29174],
Cell[7006, 204, 625, 22, 70, "FormatNotes",
 CellID->943],
Cell[7634, 228, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7675, 231, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[8039, 247, 356, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8432, 266, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8491, 269, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[8690, 279, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9385, 295, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[9429, 298, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[9503, 301, 351, 9, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[9857, 312, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[10247, 329, 631, 23, 70, "FormatNotes",
 CellID->61452522],
Cell[10881, 354, 558, 18, 70, "FormatNotes",
 CellID->1851343939],
Cell[11442, 374, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[11627, 383, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[11683, 386, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[11744, 389, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[12208, 403, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[12393, 412, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[12823, 426, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12881, 429, 4901, 160, 70, "SeeAlso",
 CellID->344804987]
}, Open  ]],
Cell[CellGroupData[{
Cell[17819, 594, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[17879, 597, 113, 2, 70, "MoreAbout"],
Cell[17995, 601, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18165, 608, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18281, 614, 60, 1, 70, "ExampleSection",
 CellID->657390947],
Cell[18344, 617, 121, 3, 70, "ExampleText",
 CellID->1096476082],
Cell[CellGroupData[{
Cell[18490, 624, 241, 7, 70, "Input",
 CellID->946785396],
Cell[18734, 633, 456, 8, 70, "Output",
 CellID->761783940]
}, Open  ]],
Cell[19205, 644, 157, 6, 70, "ExampleText",
 CellID->916335267],
Cell[CellGroupData[{
Cell[19387, 654, 150, 4, 70, "Input",
 CellID->196716535],
Cell[19540, 660, 353, 9, 70, "Output",
 CellID->5176166]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19932, 674, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

