(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36438,       1167]
NotebookOptionsPosition[     30115,        971]
NotebookOutlinePosition[     31684,       1013]
CellTagsIndexPosition[     31598,       1008]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"AVI\"" :> Documentation`HelpLookup["paclet:ref/format/AVI"], 
          "\"FLV\"" :> Documentation`HelpLookup["paclet:ref/format/FLV"], 
          "\"GIF\"" :> Documentation`HelpLookup["paclet:ref/format/GIF"], 
          "\"JPEG\"" :> Documentation`HelpLookup["paclet:ref/format/JPEG"], 
          "\"PNG\"" :> Documentation`HelpLookup["paclet:ref/format/PNG"], 
          "\"TIFF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TIFF"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"AVI\\\"\"\>", 
       2->"\<\"\\\"FLV\\\"\"\>", 3->"\<\"\\\"GIF\\\"\"\>", 
       4->"\<\"\\\"JPEG\\\"\"\>", 5->"\<\"\\\"PNG\\\"\"\>", 
       6->"\<\"\\\"TIFF\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Multimedia Formats" :> 
          Documentation`HelpLookup["paclet:guide/MultimediaFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"], "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Creating Web Pages\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 5->"\<\"Multimedia Formats\"\>", 
       6->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       7->"\<\"New in 6.0: Import & Export Formats\"\>", 
       8->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       9->"\<\"New in 6.0: Visualization & Graphics\"\>", 
       10->"\<\"Web Formats\"\>", 
       11->"\<\"Web Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SWF ",
 StyleBox["(.swf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->24307],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/x-shockwave-flash", "InlineCode"],
 "\nAdobe/Macromedia Flash file format.\nUsed for interactive and animated \
vector graphics, video and sound on the web.\nSWF is an acronym derived from \
Shockwave Flash.\nSWF files are normally embedded in HTML and played by a \
browser plug-in."
}], "FormatUsage",
 CellID->23481],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates SWF files compatible with Adobe Flash Player Version 7.0 or later. \
"
}], "FormatNotes",
 CellID->1012]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->21136],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"swf\", \"MR\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports a list of arbitrary expressions to SWF."
}], "FormatNotes",
 CellID->1838044116],

Cell[TextData[{
 "When exporting a list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["expr", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]]],
 ", the animation is composed from frames corresponding to rasterized images \
of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->455195517],

Cell["\<\
The duration of the SWF animation is determined by the number of frames and \
the specified frame rate.\
\>", "FormatNotes",
 CellID->624431530],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"swf\", \"MR\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Manipulate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports an animated demonstration of a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->1447928605],

Cell[TextData[{
 "The exported Flash animation will play at the same speed and will have the \
same size as the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object."
}], "FormatNotes",
 CellID->195249723],

Cell[TextData[{
 "If bookmarks are set in the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " will create an SWF file by interpolating between the bookmarks, while \
preserving the speed and duration of the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->68141821],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"swf\", \"MR\"]\)\>\"", ",", 
    RowBox[{
     ButtonBox["ListAnimate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ListAnimate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " object as a Flash animation."
}], "FormatNotes",
 CellID->4084],

Cell["", "WeakDivider",
 CellID->23556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).swf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an SWF file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12290],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).swf\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->29996],

Cell["", "WeakDivider",
 CellID->1054],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->25345],

Cell[TextData[{
 " ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the Flash SWF format."
}], "FormatNotes",
 CellID->14708]
}, Closed]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->13712],

Cell["General options:", "FormatNotes",
 CellID->5131],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["White",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/White"], Cell[
    "color of area padded around the exported animation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "pixel dimensions of the animated object", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30114],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", and the image size cannot be determined from the expression given, the \
first frame of the exported object will be rasterized and taken as the size \
of the resulting animation."
}], "FormatNotes",
 CellID->24722],

Cell["", "WeakDivider",
 CellID->804924484],

Cell["Video encoding and compression settings:", "FormatNotes",
 CellID->870393702],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CompressionMethod\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "whether the SWF data should be compressed", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VideoEncoding\>\"", 
    "\"\<ScreenVideo\>\"", Cell[
    "encoding method used for animation video", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->48346150],

Cell[TextData[{
 "Allowed settings for ",
 Cell[BoxData["\"\<CompressionMethod\>\""], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<GZ\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1052],

Cell[TextData[{
 "Method options for ",
 Cell[BoxData[
  RowBox[{"\"\<VideoEncoding\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"\"\<ScreenVideo\>\"", ",", " ", 
     StyleBox["opts", "TI"]}], "}"}]}]], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->927256357],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BlockSize\>\"", "32", Cell[
    "block size parameter of the screen video codec", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->108765820],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<Blocksize\>\"", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"\"\<Blocksize\>\"", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["n", "TI"], ",", 
     StyleBox["m", "TI"]}], "}"}]}]], "InlineFormula"],
 " sets the block size parameter of the Flash inter-frame compression method. \
Allowed values for the pixel dimensions are of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{"16", "*", "k"}], TraditionalForm]], "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"k", "<=", "16"}], TraditionalForm]], "InlineMath"],
 "."
}], "FormatNotes",
 CellID->1487492595],

Cell["", "WeakDivider",
 CellID->1366310135],

Cell["Playback controls:", "FormatNotes",
 CellID->531801574],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AnimationDuration\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "length of the animation in seconds when exporting a ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ControlAppearance\>\"", 
    "\"\<Generic\>\"", Cell[TextData[{
     "how ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " control elements are rendered in the exported file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FlashPlayback\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "settings for interactive playback controls ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FrameRate\>\"", "15", Cell[
    "number of frames shown per second", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RepeatAnimation\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the animation loops indefinitely", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Scalable\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether the animation scales to fit into the window when played with a \
browser plug-in \
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->162115404],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData["\"\<ControlAppearance\>\""], "InlineFormula"],
 ": "
}], "FormatNotes",
 CellID->20328],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
captures user controls exactly as seen in the notebook interface, using the \
style elements of the local computer system\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Generic\>\"", Cell[
    "renders graphical controls in a generic style ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "excludes control elements when exporting an animation", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->22646],

Cell[TextData[{
 "An animation exported with the default setting ",
 Cell[BoxData[
  RowBox[{"\"\<ControlAppearance\>\"", "->", "\"\<Generic\>\""}]], 
  "InlineFormula"],
 " will look the same regardless of the computer system on which it was \
created."
}], "FormatNotes",
 CellID->562049616],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<ControlAppearance\>\"", " "}]], "InlineFormula"],
 "-> ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", no user controls are included in the exported animation."
}], "FormatNotes",
 CellID->777555376],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).swf\>\"", ",", "  ", 
    RowBox[{
     ButtonBox["Manipulate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Manipulate"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", " ", 
    RowBox[{"\"\<ControlAppearance\>\"", " ", "->", " ", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 "exports a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " object to a Flash animation file, rendering user controls in the style of \
the local notebook interface."
}], "FormatNotes",
 CellID->677221723],

Cell[TextData[{
 "Controls elements captured from a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " animation cannot be manipulated when playing an animation file."
}], "FormatNotes",
 CellID->402169361],

Cell[TextData[{
 "Interactive controls such as \"Play\" and \"Stop\" buttons in various \
configurations can be added to the exported animation, using one of the \
following settings for ",
 Cell[BoxData["\"\<FlashPlayback\>\""], "InlineFormula"],
 ":"
}], "FormatNotes",
 CellID->155043978],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
no interactive elements are included in the exported SWF file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Animator\>\"", Cell[
    "adds button and slider controls to the exported animation", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<Animator\>\"", ",", " ", 
      StyleBox["opts", "TI"]}], "}"}], Cell[
    "user controls with additional options specified", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->307421018],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData["\"\<FlashPlayback\>\""], "InlineFormula"],
 " -> ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", no active controls are included in the exported animation."
}], "FormatNotes",
 CellID->1319726750],

Cell[TextData[{
 "Properties of the interactive playback controls can be specified using the \
form ",
 Cell[BoxData[
  RowBox[{"\"\<FlashPlayback\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<Animator\>\"", ",", " ", 
     StyleBox["opts", "TI"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->2126878491],

Cell["The following options can be chosen:", "FormatNotes",
 CellID->926474435],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Autohide\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether controls are invisible while the mouse pointer is outside the \
animation\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Autoplay\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the animation starts playing automatically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ControlPlacement\>\"", 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell["\<\
whether the interactive controls appear at the top or the bottom of the \
animation\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InitialImage\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "image displayed before the animation starts playing", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1581493922],

Cell["", "FormatNotes",
 CellID->1430429849],

Cell["Additional properties and settings:", "FormatNotes",
 CellID->16439],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HTMLFile\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "name of the file to which an HTML wrapper should be written", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThumbnailFile\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["\<\
name of the file to which a small preview image of the first frame should be \
exported\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->716285122]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->27918],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<AVI\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/AVI"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<FLV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/FLV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JPEG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JPEG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PNG\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PNG"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TIFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TIFF"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1409815940]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->5567886],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Multimedia Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MultimediaFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->16435652],

Cell[TextData[{
 "Create a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " to be exported to Flash:"
}], "ExampleText",
 CellID->1009558061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "+", "a"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", " ", 
     RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", 
     RowBox[{"Axes", " ", "\[Rule]", " ", "None"}], ",", " ", 
     RowBox[{"ColorFunction", " ", "\[Rule]", " ", "\"\<IslandColors\>\""}]}],
     "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1641178647],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 2 Pi}}, Typeset`size$$ = {180., {71., 75.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$25088$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$25088$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[$CellContext`x $CellContext`y + $CellContext`a$$], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}, Mesh -> False, Boxed -> False,
         Axes -> None, ColorFunction -> "IslandColors"], 
      "Specifications" :> {{$CellContext`a$$, 0, 2 Pi}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {115., 120.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->793095926]
}, Open  ]],

Cell["Export it to SWF:", "ExampleText",
 CellID->521611049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<manipulate.swf\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1261699475],

Cell[BoxData["\<\"manipulate.swf\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1129545847]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1569113084],

Cell[TextData[{
 "You can export a ",
 Cell[BoxData[
  ButtonBox["ListAnimate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListAnimate"]], "InlineFormula"],
 " object to Flash:"
}], "ExampleText",
 CellID->142820278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", " ", 
  RowBox[{"\"\<test.swf\>\"", ",", " ", 
   RowBox[{"ListAnimate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", "x"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2145816484],

Cell[BoxData["\<\"test.swf\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->2044762517]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SWF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 15.9983578}", "context" -> "", 
    "keywords" -> {
     "web", "web technology", "WWW", "world wide web", "w3c", "internet", 
      "HTTP", "hypertext", "hyperlink", "Flash", "animation", "multimedia", 
      "video"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/x-shockwave-flash Adobe/Macromedia \
Flash file format. Used for interactive and animated vector graphics, video \
and sound on the web. SWF is an acronym derived from Shockwave Flash. SWF \
files are normally embedded in HTML and played by a browser plug-in.", 
    "synonyms" -> {}, "title" -> "SWF", "type" -> "Format", "uri" -> 
    "ref/format/SWF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[25849, 830, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31464, 1001}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3418, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4041, 98, 102, 4, 70, "ObjectNameAlt",
 CellID->24307],
Cell[4146, 104, 385, 8, 70, "FormatUsage",
 CellID->23481],
Cell[4534, 114, 246, 8, 70, "FormatNotes",
 CellID->1012]
}, Open  ]],
Cell[CellGroupData[{
Cell[4817, 127, 53, 1, 70, "ImportExportSection",
 CellID->21136],
Cell[4873, 130, 633, 21, 70, "FormatNotes",
 CellID->1838044116],
Cell[5509, 153, 529, 20, 70, "FormatNotes",
 CellID->455195517],
Cell[6041, 175, 154, 4, 70, "FormatNotes",
 CellID->624431530],
Cell[6198, 181, 669, 22, 70, "FormatNotes",
 CellID->1447928605],
Cell[6870, 205, 288, 9, 70, "FormatNotes",
 CellID->195249723],
Cell[7161, 216, 585, 19, 70, "FormatNotes",
 CellID->68141821],
Cell[7749, 237, 659, 22, 70, "FormatNotes",
 CellID->4084],
Cell[8411, 261, 39, 1, 70, "WeakDivider",
 CellID->23556],
Cell[8453, 264, 515, 18, 70, "FormatNotes",
 CellID->12290],
Cell[8971, 284, 662, 22, 70, "FormatNotes",
 CellID->29996],
Cell[9636, 308, 38, 1, 70, "WeakDivider",
 CellID->1054],
Cell[9677, 311, 236, 9, 70, "FormatNotes",
 CellID->25345],
Cell[9916, 322, 218, 8, 70, "FormatNotes",
 CellID->14708]
}, Closed]],
Cell[CellGroupData[{
Cell[10171, 335, 49, 1, 70, "OptionsSection",
 CellID->13712],
Cell[10223, 338, 54, 1, 70, "FormatNotes",
 CellID->5131],
Cell[10280, 341, 847, 23, 70, "3ColumnTableMod",
 CellID->30114],
Cell[11130, 366, 500, 15, 70, "FormatNotes",
 CellID->24722],
Cell[11633, 383, 43, 1, 70, "WeakDivider",
 CellID->804924484],
Cell[11679, 386, 83, 1, 70, "FormatNotes",
 CellID->870393702],
Cell[11765, 389, 638, 15, 70, "3ColumnTableMod",
 CellID->48346150],
Cell[12406, 406, 320, 12, 70, "FormatNotes",
 CellID->1052],
Cell[12729, 420, 262, 9, 70, "FormatNotes",
 CellID->927256357],
Cell[12994, 431, 388, 9, 70, "3ColumnTableMod",
 CellID->108765820],
Cell[13385, 442, 668, 22, 70, "FormatNotes",
 CellID->1487492595],
Cell[14056, 466, 44, 1, 70, "WeakDivider",
 CellID->1366310135],
Cell[14103, 469, 61, 1, 70, "FormatNotes",
 CellID->531801574],
Cell[14167, 472, 1893, 46, 70, "3ColumnTableMod",
 CellID->162115404],
Cell[16063, 520, 163, 5, 70, "FormatNotes",
 CellID->20328],
Cell[16229, 527, 885, 21, 70, "2ColumnTableMod",
 CellID->22646],
Cell[17117, 550, 293, 8, 70, "FormatNotes",
 CellID->562049616],
Cell[17413, 560, 325, 11, 70, "FormatNotes",
 CellID->777555376],
Cell[17741, 573, 847, 25, 70, "FormatNotes",
 CellID->677221723],
Cell[18591, 600, 210, 6, 70, "FormatNotes",
 CellID->402169361],
Cell[18804, 608, 291, 7, 70, "FormatNotes",
 CellID->155043978],
Cell[19098, 617, 849, 21, 70, "2ColumnTableMod",
 CellID->307421018],
Cell[19950, 640, 337, 10, 70, "FormatNotes",
 CellID->1319726750],
Cell[20290, 652, 334, 10, 70, "FormatNotes",
 CellID->2126878491],
Cell[20627, 664, 79, 1, 70, "FormatNotes",
 CellID->926474435],
Cell[20709, 667, 1246, 31, 70, "3ColumnTableMod",
 CellID->1581493922],
Cell[21958, 700, 44, 1, 70, "FormatNotes",
 CellID->1430429849],
Cell[22005, 703, 74, 1, 70, "FormatNotes",
 CellID->16439],
Cell[22082, 706, 760, 20, 70, "3ColumnTableMod",
 CellID->716285122]
}, Closed]],
Cell[CellGroupData[{
Cell[22879, 731, 50, 1, 70, "SeeAlsoSection",
 CellID->27918],
Cell[22932, 734, 1218, 41, 70, "SeeAlso",
 CellID->1409815940]
}, Open  ]],
Cell[CellGroupData[{
Cell[24187, 780, 56, 1, 70, "MoreAboutSection",
 CellID->5567886],
Cell[24246, 783, 126, 2, 70, "MoreAbout"],
Cell[24375, 787, 151, 2, 70, "MoreAbout"],
Cell[24529, 791, 134, 2, 70, "MoreAbout"],
Cell[24666, 795, 133, 2, 70, "MoreAbout"],
Cell[24802, 799, 127, 2, 70, "MoreAbout"],
Cell[24932, 803, 165, 2, 70, "MoreAbout"],
Cell[25100, 807, 156, 2, 70, "MoreAbout"],
Cell[25259, 811, 153, 2, 70, "MoreAbout"],
Cell[25415, 815, 159, 2, 70, "MoreAbout"],
Cell[25577, 819, 113, 2, 70, "MoreAbout"],
Cell[25693, 823, 119, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25849, 830, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[25965, 836, 59, 1, 70, "ExampleSection",
 CellID->16435652],
Cell[26027, 839, 221, 8, 70, "ExampleText",
 CellID->1009558061],
Cell[CellGroupData[{
Cell[26273, 851, 774, 21, 70, "Input",
 CellID->1641178647],
Cell[27050, 874, 1671, 35, 70, "Output",
 CellID->793095926]
}, Open  ]],
Cell[28736, 912, 60, 1, 70, "ExampleText",
 CellID->521611049],
Cell[CellGroupData[{
Cell[28821, 917, 147, 4, 70, "Input",
 CellID->1261699475],
Cell[28971, 923, 93, 2, 70, "Output",
 CellID->1129545847]
}, Open  ]],
Cell[29079, 928, 126, 3, 70, "ExampleDelimiter",
 CellID->1569113084],
Cell[29208, 933, 222, 8, 70, "ExampleText",
 CellID->142820278],
Cell[CellGroupData[{
Cell[29455, 945, 504, 15, 70, "Input",
 CellID->2145816484],
Cell[29962, 962, 87, 2, 70, "Output",
 CellID->2044762517]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[30088, 969, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

