(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32392,       1072]
NotebookOptionsPosition[     27400,        912]
NotebookOutlinePosition[     28873,        952]
CellTagsIndexPosition[     28788,        947]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Graph6\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Graph6"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"\\\"Graph6\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Mathematical Data" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalData"], 
          "Mathematical Data Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalDataFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 3->"\<\"Mathematical Data\"\>", 
       4->"\<\"Mathematical Data Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Sparse6 ",
 StyleBox["(.s6)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->5045],

Cell[TextData[{
 "sparse6 graph data format.\nUsed for storing undirected graphs.\nASCII \
format.\nStores connectivity information for multiple undirected graphs.\n\
Suitable for large sparse graphs, stores up ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["2", "18"], "-", "1"}], TraditionalForm]], "InlineMath"],
 " vertices.\nRelated to graph6 which is optimized for small graphs or large \
dense graphs.\nDeveloped by Brendan McKay at the Australian National \
University."
}], "FormatUsage",
 CellID->20778],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the sparse6 file format."
}], "FormatNotes",
 CellID->5821]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", "]"}]], "InlineFormula"],
 "gives a graphical rendering of the first graph stored in the specified \
file."
}], "FormatNotes",
 CellID->2520],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an adjacency matrix or edge information for one graph or multiple \
graphs to the sparse6 format."
}], "FormatNotes",
 CellID->12927],

Cell["", "WeakDivider",
 CellID->24773],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", "]"}], " "}]], "InlineFormula"],
 "imports the first graph from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 " and returns it as a ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25134],

Cell["", "WeakDivider",
 CellID->27251],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a sparse6 file."
}], "FormatNotes",
 CellID->22675],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->13336],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->16334],

Cell[TextData[{
 "The import format can be specified with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<Sparse6\>\""}], "]"}]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Sparse6\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->21001],

Cell["", "WeakDivider",
 CellID->2737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a sparse6 file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9310],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5974],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->7590],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->20356],

Cell["", "WeakDivider",
 CellID->1071],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32080],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the sparse6 format."
}], "FormatNotes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->32145],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->17282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1825],

Cell["", "WeakDivider",
 CellID->18718],

Cell["Data representation elements:", "FormatNotes",
 CellID->13573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdjacencyMatrix\>\"", Cell["\<\
edge information for all graphs in this file, given as a list of sparse \
matrices\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EdgeRules\>\"", Cell[
    "connectivity data for all graphs, given as an array of rules", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[TextData[{
     "first graph stored in this file, rendered as ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsList\>\"", Cell[TextData[{
     "all graphs stored in this file, given as a list of ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " objects"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexCount\>\"", Cell["\<\
number of vertices in each graph, given as a list of integers\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->977886736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element by default. "
}], "FormatNotes",
 CellID->7162],

Cell["", "WeakDivider",
 CellID->700968940],

Cell["\<\
Element specifications for sparse6 files containing multiple graphs:\
\>", "FormatNotes",
 CellID->650021461],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "data representation element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " graph in this file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for graphs ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["n", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     StyleBox["elem", "TI"], ",", " ", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " for all graphs, given as a list"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->661382738],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).s6\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Graphics\>\"", ",", 
      ButtonBox["All",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/All"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives a list of ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " objects, each representing a rendering of a graph stored in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["file", "TI"], ".", "s6"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->484320694],

Cell[TextData[{
 "When importing a graph6 file using the ",
 Cell[BoxData["\"\<EdgeRules\>\""], "InlineFormula"],
 " element, no rules are returned for possible unconnected vertices."
}], "FormatNotes",
 CellID->1014881928],

Cell[TextData[{
 "Graphs including unconnected vertices can be fully specified using the ",
 Cell[BoxData["\"\<AdjacencyMatrix\>\""], "InlineFormula"],
 " element, or as a combination of ",
 Cell[BoxData["\"\<EdgeRules\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<VertexCount\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->76433444]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->8692],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->19539],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
specifies the overall size of the image to display for a graph\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->28047]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->20829],

Cell[TextData[Cell[BoxData[
 ButtonBox["\"\<Graph6\>\"",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/format/Graph6"]], "InlineFormula"]], "SeeAlso", \
"InlineFormula",
 CellID->305581829]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->572827639],

Cell["\<\
Import a sparse6 example file, giving a visual representation:\
\>", "ExampleText",
 CellID->749592553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/sparse.s6\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17199],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.9691326261392774`, 0.}, {3.570213402151439, 
    0.46336300881763814`}, {2.2628733606848623`, 0.27272997332310944`}, {
    2.7820500827438224`, 0.8268951465169423}, {3.3216282726383133`, 
    3.071468486700189}, {2.006179683824068, 3.2210763236226576`}, {
    2.396273387020025, 3.1866788874698857`}, {0., 2.15135145710932}, {
    0.02874686654687464, 1.6472082622055484`}, {0.6730412579423919, 
    2.220950075995824}, {2.913679206476027, 3.653272087143466}, {
    3.8155673314735274`, 3.1093634531213787`}, {0.7793835872546397, 
    2.6947056466482504`}, {1.9210321614639203`, 2.310107997490522}, {
    0.5047737313953962, 1.6335777530333013`}, {0.08755545387363783, 
    1.073812389722074}, {0.7210459185324256, 1.1797542036078337`}, {
    2.5019341210592967`, 2.5072298317218453`}, {3.0714544111900257`, 
    2.5750254459576873`}, {3.826154535550151, 1.949793829086371}, {
    3.03595783394795, 1.5469166388209938`}, {1.8967295901053505`, 
    1.4329369857854615`}, {0.9591241244131878, 0.6317644016353561}, {
    3.5799516414311237`, 1.4488344448050365`}, {3.425426851567682, 
    0.8493206683334835}, {4.117763389840608, 0.730798421974691}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{2, 21}], LineBox[{2, 26}], LineBox[{3, 23}], 
      LineBox[{3, 25}], LineBox[{4, 22}], LineBox[{4, 24}], LineBox[{5, 12}], 
      LineBox[{5, 18}], LineBox[{5, 19}], LineBox[{6, 11}], LineBox[{6, 13}], 
      LineBox[{6, 19}], LineBox[{7, 11}], LineBox[{7, 14}], LineBox[{7, 18}], 
      LineBox[{8, 10}], LineBox[{8, 13}], LineBox[{8, 16}], LineBox[{9, 10}], 
      LineBox[{9, 15}], LineBox[{9, 17}], LineBox[{10, 14}], 
      LineBox[{11, 12}], LineBox[{12, 20}], LineBox[{13, 15}], 
      LineBox[{14, 21}], LineBox[{15, 23}], LineBox[{16, 17}], 
      LineBox[{16, 23}], LineBox[{17, 22}], LineBox[{18, 22}], 
      LineBox[{19, 24}], LineBox[{20, 21}], LineBox[{20, 25}], 
      LineBox[{24, 26}], LineBox[{25, 26}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.9691326261392774`, 0.}, {3.570213402151439, 
     0.46336300881763814`}, {2.2628733606848623`, 0.27272997332310944`}, {
     2.7820500827438224`, 0.8268951465169423}, {3.3216282726383133`, 
     3.071468486700189}, {2.006179683824068, 3.2210763236226576`}, {
     2.396273387020025, 3.1866788874698857`}, {0., 2.15135145710932}, {
     0.02874686654687464, 1.6472082622055484`}, {0.6730412579423919, 
     2.220950075995824}, {2.913679206476027, 3.653272087143466}, {
     3.8155673314735274`, 3.1093634531213787`}, {0.7793835872546397, 
     2.6947056466482504`}, {1.9210321614639203`, 2.310107997490522}, {
     0.5047737313953962, 1.6335777530333013`}, {0.08755545387363783, 
     1.073812389722074}, {0.7210459185324256, 1.1797542036078337`}, {
     2.5019341210592967`, 2.5072298317218453`}, {3.0714544111900257`, 
     2.5750254459576873`}, {3.826154535550151, 1.949793829086371}, {
     3.03595783394795, 1.5469166388209938`}, {1.8967295901053505`, 
     1.4329369857854615`}, {0.9591241244131878, 0.6317644016353561}, {
     3.5799516414311237`, 1.4488344448050365`}, {3.425426851567682, 
     0.8493206683334835}, {4.117763389840608, 0.730798421974691}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1113951694]
}, Open  ]],

Cell[TextData[{
 "Read the adjacency matrix of the above example and render it as ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->534703361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/sparse.s6\>\"", ",", "\"\<AdjacencyMatrix\>\""}],
     "]"}], " ", "[", 
   RowBox[{"[", "1", "]"}], "]"}], " ", "//", " ", "MatrixPlot"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1262964969],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmM0JwkAUhBfswpuVpAdLEDxbj2hnNmEJRuLFQ4QENzsz+20IXw4hzJs3
ZH8Op8vxvCul7D/3+3kaz2GO9+ttvB5D+Rrz78NszuWhdk7IoSbV+kIOM+ji
8790utTbiq3mnd6In+tIPvusdynV/FHTA38ztV+9rduZLzLo0q+lOl3qcic+
r6OLb2o61fSoMdUftbrU9Kixt/VwbVJv2++4Ex8mpu4jXHSmUs1/NT3UtQ3V
zuXoFySf0IUuOSS3GVTb55KrPumSH/KZQff5Tk0PXEe1Pqrtj2rXBbPZ6j9P
3uCWOSRv2XQ/F0pdV8C6fAFTDhns
   "], {{0, 0}, {26, 26}}, {0, 1}],
  Frame->True,
  FrameLabel->{None, None},
  FrameTicks->{{{{25.5, 
       FormBox["1", TraditionalForm]}, {21.5, 
       FormBox["5", TraditionalForm]}, {16.5, 
       FormBox["10", TraditionalForm]}, {11.5, 
       FormBox["15", TraditionalForm]}, {6.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["26", TraditionalForm]}}, {{25.5, 
       FormBox["1", TraditionalForm]}, {21.5, 
       FormBox["5", TraditionalForm]}, {16.5, 
       FormBox["10", TraditionalForm]}, {11.5, 
       FormBox["15", TraditionalForm]}, {6.5, 
       FormBox["20", TraditionalForm]}, {0.5, 
       FormBox["26", TraditionalForm]}}}, {{{0.5, 
       FormBox["1", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {14.5, 
       FormBox["15", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {25.5, 
       FormBox["26", TraditionalForm]}}, {{0.5, 
       FormBox["1", TraditionalForm]}, {4.5, 
       FormBox["5", TraditionalForm]}, {9.5, 
       FormBox["10", TraditionalForm]}, {14.5, 
       FormBox["15", TraditionalForm]}, {19.5, 
       FormBox["20", TraditionalForm]}, {25.5, 
       FormBox["26", TraditionalForm]}}}},
  PlotRangeClipping->True]], "Output",
 CellLabel->"Out[2]=",
 CellID->923867035]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Mathematical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Sparse6 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 14.3889416}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "sparse6 graph data format. Used for storing undirected graphs. ASCII \
format. Stores connectivity information for multiple undirected graphs. \
Suitable for large sparse graphs, stores up 2^18-1 vertices. Related to \
graph6 which is optimized for small graphs or large dense graphs. Developed \
by Brendan McKay at the Australian National University.", "synonyms" -> {}, 
    "title" -> "Sparse6", "type" -> "Format", "uri" -> 
    "ref/format/Sparse6"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17921, 641, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28654, 940}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1650, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2273, 67, 104, 4, 70, "ObjectNameAlt",
 CellID->5045],
Cell[2380, 73, 526, 12, 70, "FormatUsage",
 CellID->20778],
Cell[2909, 87, 332, 12, 70, "FormatNotes",
 CellID->5821]
}, Open  ]],
Cell[CellGroupData[{
Cell[3278, 104, 64, 1, 70, "ImportExportSection",
 CellID->13855],
Cell[3345, 107, 322, 10, 70, "FormatNotes",
 CellID->2520],
Cell[3670, 119, 399, 12, 70, "FormatNotes",
 CellID->12927],
Cell[4072, 133, 39, 1, 70, "WeakDivider",
 CellID->24773],
Cell[4114, 136, 511, 18, 70, "FormatNotes",
 CellID->25134],
Cell[4628, 156, 39, 1, 70, "WeakDivider",
 CellID->27251],
Cell[4670, 159, 344, 11, 70, "FormatNotes",
 CellID->22675],
Cell[5017, 172, 573, 20, 70, "FormatNotes",
 CellID->13336],
Cell[5593, 194, 581, 21, 70, "FormatNotes",
 CellID->16334],
Cell[6177, 217, 689, 25, 70, "FormatNotes",
 CellID->21001],
Cell[6869, 244, 38, 1, 70, "WeakDivider",
 CellID->2737],
Cell[6910, 247, 516, 18, 70, "FormatNotes",
 CellID->9310],
Cell[7429, 267, 1074, 40, 70, "FormatNotes",
 CellID->5974],
Cell[8506, 309, 660, 22, 70, "FormatNotes",
 CellID->7590],
Cell[9169, 333, 815, 28, 70, "FormatNotes",
 CellID->20356],
Cell[9987, 363, 38, 1, 70, "WeakDivider",
 CellID->1071],
Cell[10028, 366, 361, 14, 70, "FormatNotes",
 CellID->32080],
Cell[10392, 382, 346, 12, 70, "FormatNotes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[10775, 399, 51, 1, 70, "ElementsSection",
 CellID->32145],
Cell[10829, 402, 192, 8, 70, "FormatNotes",
 CellID->17282],
Cell[11024, 412, 667, 13, 70, "2ColumnTableMod",
 CellID->1825],
Cell[11694, 427, 39, 1, 70, "WeakDivider",
 CellID->18718],
Cell[11736, 430, 68, 1, 70, "FormatNotes",
 CellID->13573],
Cell[11807, 433, 1374, 32, 70, "2ColumnTableMod",
 CellID->977886736],
Cell[13184, 467, 257, 9, 70, "FormatNotes",
 CellID->7162],
Cell[13444, 478, 43, 1, 70, "WeakDivider",
 CellID->700968940],
Cell[13490, 481, 119, 3, 70, "FormatNotes",
 CellID->650021461],
Cell[13612, 486, 1843, 59, 70, "2ColumnTableMod",
 CellID->661382738],
Cell[15458, 547, 720, 24, 70, "FormatNotes",
 CellID->484320694],
Cell[16181, 573, 223, 5, 70, "FormatNotes",
 CellID->1014881928],
Cell[16407, 580, 352, 9, 70, "FormatNotes",
 CellID->76433444]
}, Open  ]],
Cell[CellGroupData[{
Cell[16796, 594, 48, 1, 70, "OptionsSection",
 CellID->8692],
Cell[16847, 597, 190, 8, 70, "FormatNotes",
 CellID->19539],
Cell[17040, 607, 564, 16, 70, "3ColumnTableMod",
 CellID->28047]
}, Closed]],
Cell[CellGroupData[{
Cell[17641, 628, 50, 1, 70, "SeeAlsoSection",
 CellID->20829],
Cell[17694, 631, 190, 5, 70, "SeeAlso",
 CellID->305581829]
}, Open  ]],
Cell[CellGroupData[{
Cell[17921, 641, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18037, 647, 60, 1, 70, "ExampleSection",
 CellID->572827639],
Cell[18100, 650, 113, 3, 70, "ExampleText",
 CellID->749592553],
Cell[CellGroupData[{
Cell[18238, 657, 126, 3, 70, "Input",
 CellID->17199],
Cell[18367, 662, 6058, 159, 70, "Output",
 CellID->1113951694]
}, Open  ]],
Cell[24440, 824, 251, 8, 70, "ExampleText",
 CellID->534703361],
Cell[CellGroupData[{
Cell[24716, 836, 284, 8, 70, "Input",
 CellID->1262964969],
Cell[25003, 846, 1712, 38, 70, "Output",
 CellID->923867035]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26776, 891, 38, 0, 70, "MoreAboutSection"],
Cell[26817, 893, 134, 2, 70, "MoreAbout"],
Cell[26954, 897, 133, 2, 70, "MoreAbout"],
Cell[27090, 901, 125, 2, 70, "MoreAbout"],
Cell[27218, 905, 140, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[27373, 910, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

