(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57028,       1211]
NotebookOptionsPosition[     53537,       1097]
NotebookOutlinePosition[     54766,       1133]
CellTagsIndexPosition[     54680,       1128]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Binary\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "\"Text\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Text"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"Binary\\\"\"\>", 
       2->"\<\"\\\"Text\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["String", "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "Arbitrary binary data represented as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string.\nUsed for importing or exporting entire raw binary data."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 "Using ",
 Cell[BoxData["\"\<String\>\""], "InlineFormula"],
 " as the format specification, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can represent any file as a sequence of ordinary or special characters."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<String\>\""}], "]"}]], 
  "InlineFormula"],
 " imports a file as a raw string, representing each byte of the file as the \
character corresponding to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["FromCharacterCode",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FromCharacterCode"], "[", 
    StyleBox["byte", "TI"], "]"}], "."}]], "InlineFormula"]
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["str", "TI"], ",", "\"\<String\>\""}], "]"}]], "InlineFormula"],
 " exports a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string of characters to a binary file. Characters with an encoding greater \
than 255 are converted to their ASCII representation before exporting."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 "The format ",
 Cell[BoxData["\"\<String\>\""], "InlineFormula"],
 " must be explicitly specified."
}], "FormatNotes",
 CellID->236987809],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ExportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExportString"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 "and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Export",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Export"], "[", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"tmp\", \"TI\"]\)\>\"", ",", 
      StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "]"}], ",", 
    ButtonBox["\"\<String\>\"",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/format/String"]}], "]"}]], "InlineFormula"],
 " return the same expression."
}], "FormatNotes",
 CellID->677099614],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<String\>\""}], "]"}]], 
  "InlineFormula"],
 " reads any binary file, representing its raw content as a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string object. "
}], "FormatNotes",
 CellID->890855534],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", 
    StyleBox["str", "TI"], ",", "\"\<String\>\""}], "]"}]], "InlineFormula"],
 " exports a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string to a file."
}], "FormatNotes",
 CellID->352973054],

Cell[TextData[{
 "No character encoding transformations are performed when importing or \
exporting as ",
 Cell[BoxData["\"\<String\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1680454893],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", 
    StyleBox["expr", "TI"], ",", "\"\<String\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a textual representation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->416257196],

Cell["", "WeakDivider",
 CellID->1068285564],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 Cell[BoxData["\"\<String\>\""], "InlineFormula"],
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<Binary\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Text\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Text"]], "InlineFormula"]
}], "SeeAlso",
 CellID->375994224]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->406679136],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->87396537],

Cell[TextData[{
 "Read an arbitrary binary file and return it as a raw ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " string:"
}], "ExampleText",
 CellID->1935643026],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{"Import", "[", 
    RowBox[{"\"\<ExampleData/ocelot.jpg\>\"", ",", "\"\<String\>\""}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1473472933],

Cell["\<\
Show the first bytes of the result, which contains unprintable characters:\
\>", "ExampleText",
 CellID->122569579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringTake", "[", 
  RowBox[{"s", ",", "120"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2025651374],

Cell[BoxData["\<\"\[YDoubleDot]\[CapitalOSlash]\[YDoubleDot]\[AGrave]\.00\.10\
JFIF\.00\.01\.01\.01\.01\.00\.00\.01\.01\.00\.01\.01\.00\.00\[YDoubleDot]\
\[Thorn]\.00XCREATOR: XV Version 3.10a  Rev: 12/29/94 (PNG patch 1.1)  \
Quality = 95, Smoothing = \
0\\n\[YDoubleDot]\[CapitalUHat]\.00C\.00\.02\.01\.01\.01\.01\.01\.01\.01\.01\"\
\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1064386927]
}, Open  ]],

Cell[TextData[{
 "Convert the string which represents the file ",
 StyleBox["\"ocelot.jpg\"", "InlineCode"],
 " to graphics:"
}], "ExampleText",
 CellID->590096780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", "s", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->612302579],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJxMuwd8XNd9Jqpkk01e8naTfXlJ7NiO7Xg3StzfOlacYrnJKra6RFGkSLCC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   "], {{0, 0}, {200, 200}}, {0, 255},
   ColorFunction->GrayLevel],
  ImageSize->{200, 200},
  PlotRange->{{0, 200}, {0, 200}}]], "Output",
 CellLabel->"Out[3]=",
 CellID->227808829]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"String - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 15.1858370}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Arbitrary binary data represented as a Mathematica string. Used for \
importing or exporting entire raw binary data.", "synonyms" -> {}, "title" -> 
    "String", "type" -> "Format", "uri" -> "ref/format/String"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8521, 312, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 54547, 1121}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1572, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2195, 65, 52, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2250, 68, 215, 6, 70, "FormatUsage",
 CellID->37585799],
Cell[2468, 76, 467, 15, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[2972, 96, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3039, 99, 600, 19, 70, "FormatNotes",
 CellID->28652],
Cell[3642, 120, 524, 15, 70, "FormatNotes",
 CellID->8194],
Cell[4169, 137, 155, 5, 70, "FormatNotes",
 CellID->236987809],
Cell[4327, 144, 876, 29, 70, "FormatNotes",
 CellID->677099614],
Cell[5206, 175, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[5247, 178, 414, 14, 70, "FormatNotes",
 CellID->890855534],
Cell[5664, 194, 404, 14, 70, "FormatNotes",
 CellID->352973054],
Cell[6071, 210, 201, 6, 70, "FormatNotes",
 CellID->1680454893],
Cell[6275, 218, 428, 15, 70, "FormatNotes",
 CellID->416257196],
Cell[6706, 235, 44, 1, 70, "WeakDivider",
 CellID->1068285564],
Cell[6753, 238, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[7117, 254, 395, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[7549, 273, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[7607, 276, 389, 13, 70, "SeeAlso",
 CellID->375994224]
}, Open  ]],
Cell[CellGroupData[{
Cell[8033, 294, 58, 1, 70, "MoreAboutSection",
 CellID->406679136],
Cell[8094, 297, 117, 2, 70, "MoreAbout"],
Cell[8214, 301, 134, 2, 70, "MoreAbout"],
Cell[8351, 305, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8521, 312, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[8637, 318, 59, 1, 70, "ExampleSection",
 CellID->87396537],
Cell[8699, 321, 174, 6, 70, "ExampleText",
 CellID->1935643026],
Cell[8876, 329, 227, 7, 70, "Input",
 CellID->1473472933],
Cell[9106, 338, 125, 3, 70, "ExampleText",
 CellID->122569579],
Cell[CellGroupData[{
Cell[9256, 345, 132, 4, 70, "Input",
 CellID->2025651374],
Cell[9391, 351, 394, 7, 70, "Output",
 CellID->1064386927]
}, Open  ]],
Cell[9800, 361, 164, 5, 70, "ExampleText",
 CellID->590096780],
Cell[CellGroupData[{
Cell[9989, 370, 108, 3, 70, "Input",
 CellID->612302579],
Cell[10100, 375, 43371, 715, 70, "Output",
 CellID->227808829]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[53510, 1095, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

