(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42196,       1439]
NotebookOptionsPosition[     34984,       1208]
NotebookOutlinePosition[     36338,       1246]
CellTagsIndexPosition[     36252,       1241]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"CSV\"" :> Documentation`HelpLookup["paclet:ref/format/CSV"], 
          "\"Table\"" :> Documentation`HelpLookup["paclet:ref/format/Table"], 
          "\"XLS\"" :> Documentation`HelpLookup["paclet:ref/format/XLS"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"CSV\\\"\"\>", 
       2->"\<\"\\\"Table\\\"\"\>", 
       3->"\<\"\\\"XLS\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Formats" :> 
          Documentation`HelpLookup["paclet:guide/BasicFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"], 
          "Tabular & Spreadsheet Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/TabularAndSpreadsheetFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 4->"\<\"Numerical Data\"\>", 
       5->"\<\"Numerical Data Formats\"\>", 
       6->"\<\"Tabular & Spreadsheet Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TSV ",
 StyleBox["(.tsv)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["text/tab-separated-values", "InlineCode"],
 "\nTSV tabular data format.\nStores records of numerical and textual \
information as lines, using tab characters to separate fields.\nTSV is an \
acronym for Tab-Separated Values.\nPlain text format.\nSimilar to CSV."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ",
 "TSV",
 " format and provide various data conversion and formatting options. "
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes common number formats, including C and Fortran \
notations."
}], "FormatNotes",
 CellID->56646289],

Cell["Numbers without decimal points are imported as integers.", "FormatNotes",
 CellID->718923602]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", "]"}]], "InlineFormula"],
 " imports a ",
 "TSV",
 " file, returning a list of lists."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a two-dimensional array to a ",
 "TSV",
 " file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a two-dimensional array of strings and numbers, representing the \
rows and columns stored in the file."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates a TSV file from an array ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", using the ",
 Cell[BoxData[
  ButtonBox["CForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CForm"]], "InlineFormula"],
 " of non-numeric table elements."
}], "FormatNotes",
 CellID->7572],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically transforms arbitrary expressions to a list of lists when \
exporting to TSV."
}], "FormatNotes",
 CellID->1052031979],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "TSV",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<TSV\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<TSV\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "TSV",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tsv\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "TSV",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->2075609843],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook as a TSV file."
}], "FormatNotes",
 CellID->1050269433]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell["\<\
two-dimensional array, representing the rows and columns of a TSV file\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Grid\>\"", Cell[TextData[{
     "table data as a ",
     Cell[BoxData[
      ButtonBox["Grid",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
     " object"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how data is aligned within table columns", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<UTF8\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->275885706],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1175867229],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->431454156],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["CharacterEncoding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/CharacterEncoding"], "\"\<ASCII\>\"", Cell[
    "raw character encoding used in the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1545207620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->363422294],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    "how to represent empty fields", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TextDelimiters\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "string or list of strings used to delimit non-numeric fields", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->595003190],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " delimits text fields containing tab characters with double-quote \
characters."
}], "FormatNotes",
 CellID->751587654],

Cell[TextData[{
 "With an explicit setting of ",
 Cell[BoxData["\"\<TextDelimiters\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always uses the specified string tokens to delimit text fields, \
effectively cycling through the list of delimiters."
}], "FormatNotes",
 CellID->1294656327],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"\"\<TextDelimiters\>\"", " "}]], "InlineFormula"],
 Cell[BoxData[
  RowBox[{"->", " ", "\"\<\\\"\>\""}]], "InlineFormula"],
 " puts double-quotes around each text field when exporting to TSV. "
}], "FormatNotes",
 CellID->1132802757],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<TextDelimiters\>\"", " ", "->", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}]}]], "InlineFormula"],
 " , ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " wraps each text field in parentheses."
}], "FormatNotes",
 CellID->984576485],

Cell["\<\
Double-quote characters delimiting text fields are not imported by default.\
\>", "FormatNotes",
 CellID->689403646],

Cell["", "WeakDivider",
 CellID->1791006941],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->175377388],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CurrencyTokens\>\"", 
    RowBox[{
     StyleBox["{", "MR"], 
     RowBox[{
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "$", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Sterling]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Yen]",
          TraditionalForm], 
         StyleBox["\"\<\>", "MR"]}], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Euro]",
          TraditionalForm], "\"\<\>"}]}], "}"}], ",", 
      StyleBox[" ", "TR"], 
      RowBox[{
       StyleBox["{", "MR"], 
       RowBox[{
        StyleBox[
         RowBox[{"\"\<\>", "c", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        RowBox[{
         StyleBox["\"\<\>", "MR"], 
         FormBox["\[Cent]",
          TraditionalForm], "\"\<\>"}], ",", 
        StyleBox[" ", "TR"], 
        StyleBox[
         RowBox[{"\"\<\>", "p", "\"\<\>"}], "MR"], 
        StyleBox[",", "MR"], " ", 
        StyleBox[
         RowBox[{"\"\<\>", "F", "\"\<\>"}], "MR"]}], 
       StyleBox["}", "MR"]}]}], 
     StyleBox["}", "MR"]}], Cell[
    "currency units to be skipped when importing numerical values", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateStringFormat\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "date format, given as a ",
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Numeric\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to import data fields as numbers if possible", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberPoint\>\"", "\"\<.\>\"", Cell[
    "string to use for a decimal point", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NumberSigns\>\"", 
    RowBox[{"{", 
     RowBox[{"\"\<-\>\"", ",", "\"\<+\>\""}], "}"}], Cell[
    "strings to use for signs of negative and positive numbers", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HeaderLines\>\"", "0", Cell[
    "number of lines to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->1220196432],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " converts table entries formatted as specified by the ",
 Cell[BoxData[
  RowBox[{"\"\<DateStringFormat\>\"", " "}]], "InlineFormula"],
 "option to a ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " representation of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "FormatNotes",
 CellID->968510758],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"\"\<Numeric\>\"", " ", "->", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", numbers will be imported as strings in the form they appear in the file."
}], "FormatNotes",
 CellID->2005072920],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " automatically recognizes all common conventions for the encoding of line \
separator characters."
}], "FormatNotes",
 CellID->1534753898],

Cell["", "WeakDivider",
 CellID->1520087421],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1643820035],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<TableHeadings\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "headings for table columns and rows", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->306209590],

Cell[TextData[{
 Cell[BoxData["\"\<TableHeadings\>\""], "InlineFormula"],
 " can be set to the following values: "
}], "FormatNotes",
 CellID->5556],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "gives successive integer labels for columns and rows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"col\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "list of column labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox[
      RowBox[{"rhead", ",", " ", "chead"}], "TI"], 
     StyleBox["}", "TI"]}], Cell[
    "specifies separate labels for the rows and columns", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " encodes line separator characters using the convention of the computer \
system on which ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is being run."
}], "FormatNotes",
 CellID->1182679569]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<CSV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CSV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Table\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Table"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XLS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XLS"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->281528422],

Cell[TextData[ButtonBox["Basic Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BasicFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Tabular & Spreadsheet Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TabularAndSpreadsheetFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->219648491],

Cell["This imports an entire TSV file:", "ExampleText",
 CellID->73952109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/classification.tsv\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Rank\"\>", ",", "\<\"Fruit Fly\"\>", ",", "\<\"Human\"\>", 
     ",", "\<\"Pea\"\>", ",", "\<\"E.coli\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Domain\"\>", ",", "\<\"Eukaryota\"\>", 
     ",", "\<\"Eukaryota\"\>", ",", "\<\"Eukaryota\"\>", 
     ",", "\<\"Bacteria\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Kingdom\"\>", ",", "\<\"Animalia\"\>", 
     ",", "\<\"Animalia\"\>", ",", "\<\"Plantae\"\>", ",", "\<\"Monera\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Phylum\"\>", ",", "\<\"Arthropoda\"\>", 
     ",", "\<\"Chordata\"\>", ",", "\<\"Magnoliophyta\"\>", 
     ",", "\<\"Proteobacteria\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Class\"\>", ",", "\<\"Insecta\"\>", ",", "\<\"Mammalia\"\>", 
     ",", "\<\"Magnoliopsida\"\>", ",", "\<\"Proteobacteria\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Order\"\>", ",", "\<\"Diptera\"\>", ",", "\<\"Primates\"\>", 
     ",", "\<\"Fabales\"\>", ",", "\<\"Enterobacteriales\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Family\"\>", ",", "\<\"Drosophilidae\"\>", 
     ",", "\<\"Hominidae\"\>", ",", "\<\"Fabaceae\"\>", 
     ",", "\<\"Enterobacteriaceae\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Genus\"\>", ",", "\<\"Drosophila\"\>", ",", "\<\"Homo\"\>", 
     ",", "\<\"Pisum\"\>", ",", "\<\"Escherichia\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Species\"\>", ",", "\<\"D.melanogaster\"\>", 
     ",", "\<\"H.sapiens\"\>", ",", "\<\"P.sativum\"\>", 
     ",", "\<\"E.coli\"\>"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1419438571]
}, Open  ]],

Cell[TextData[{
 "Format the previous output as a ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1667547997],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "LightGreen", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"LightGreen", ",", 
        RowBox[{"{", 
         RowBox[{"None", ",", "LightGray"}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->185532426],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Rank\"\>", "\<\"Fruit Fly\"\>", "\<\"Human\"\>", "\<\"Pea\"\>", "\<\
\"E.coli\"\>"},
    {"\<\"Domain\"\>", "\<\"Eukaryota\"\>", "\<\"Eukaryota\"\>", \
"\<\"Eukaryota\"\>", "\<\"Bacteria\"\>"},
    {"\<\"Kingdom\"\>", "\<\"Animalia\"\>", "\<\"Animalia\"\>", \
"\<\"Plantae\"\>", "\<\"Monera\"\>"},
    {"\<\"Phylum\"\>", "\<\"Arthropoda\"\>", "\<\"Chordata\"\>", \
"\<\"Magnoliophyta\"\>", "\<\"Proteobacteria\"\>"},
    {"\<\"Class\"\>", "\<\"Insecta\"\>", "\<\"Mammalia\"\>", \
"\<\"Magnoliopsida\"\>", "\<\"Proteobacteria\"\>"},
    {"\<\"Order\"\>", "\<\"Diptera\"\>", "\<\"Primates\"\>", \
"\<\"Fabales\"\>", "\<\"Enterobacteriales\"\>"},
    {"\<\"Family\"\>", "\<\"Drosophilidae\"\>", "\<\"Hominidae\"\>", \
"\<\"Fabaceae\"\>", "\<\"Enterobacteriaceae\"\>"},
    {"\<\"Genus\"\>", "\<\"Drosophila\"\>", "\<\"Homo\"\>", "\<\"Pisum\"\>", \
"\<\"Escherichia\"\>"},
    {"\<\"Species\"\>", "\<\"D.melanogaster\"\>", "\<\"H.sapiens\"\>", \
"\<\"P.sativum\"\>", "\<\"E.coli\"\>"}
   },
   GridBoxBackground->{"Columns" -> {
       RGBColor[0.88, 1, 0.88]}, "Rows" -> {
       RGBColor[0.88, 1, 0.88], {None, 
        GrayLevel[0.85]}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 CellLabel->"Out[2]=",
 CellID->108228274]
}, Open  ]],

Cell["Read this file, ignoring the first line:", "ExampleText",
 CellID->1745332150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/classification.tsv\>\"", ",", 
   RowBox[{"\"\<HeaderLines\>\"", " ", "\[Rule]", " ", "1"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1817592229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Domain\"\>", ",", "\<\"Eukaryota\"\>", 
     ",", "\<\"Eukaryota\"\>", ",", "\<\"Eukaryota\"\>", 
     ",", "\<\"Bacteria\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Kingdom\"\>", ",", "\<\"Animalia\"\>", 
     ",", "\<\"Animalia\"\>", ",", "\<\"Plantae\"\>", ",", "\<\"Monera\"\>"}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Phylum\"\>", ",", "\<\"Arthropoda\"\>", 
     ",", "\<\"Chordata\"\>", ",", "\<\"Magnoliophyta\"\>", 
     ",", "\<\"Proteobacteria\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Class\"\>", ",", "\<\"Insecta\"\>", ",", "\<\"Mammalia\"\>", 
     ",", "\<\"Magnoliopsida\"\>", ",", "\<\"Proteobacteria\"\>"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Order\"\>", ",", "\<\"Diptera\"\>", ",", "\<\"Primates\"\>", 
     ",", "\<\"Fabales\"\>", ",", "\<\"Enterobacteriales\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Family\"\>", ",", "\<\"Drosophilidae\"\>", 
     ",", "\<\"Hominidae\"\>", ",", "\<\"Fabaceae\"\>", 
     ",", "\<\"Enterobacteriaceae\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Genus\"\>", ",", "\<\"Drosophila\"\>", ",", "\<\"Homo\"\>", 
     ",", "\<\"Pisum\"\>", ",", "\<\"Escherichia\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Species\"\>", ",", "\<\"D.melanogaster\"\>", 
     ",", "\<\"H.sapiens\"\>", ",", "\<\"P.sativum\"\>", 
     ",", "\<\"E.coli\"\>"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->1178683554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1497700896],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically converts expressions to a list of lists when exporting to \
CSV:"
}], "ExampleText",
 CellID->1203132585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", "\"\<TSV\>\""}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343335943],

Cell[BoxData["\<\"1\\n1\\t2\\t3\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->159824205]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<TSV\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1143037257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1810854685]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TSV - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 24.0454388}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: text/tab-separated-values TSV tabular data format. Stores \
records of numerical and textual information as lines, using tab characters \
to separate fields. TSV is an acronym for Tab-Separated Values. Plain text \
format. Similar to CSV.", "synonyms" -> {}, "title" -> "TSV", "type" -> 
    "Format", "uri" -> "ref/format/TSV"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[27863, 986, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36118, 1234}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2141, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2764, 75, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2874, 81, 343, 7, 70, "FormatUsage",
 CellID->37585799],
Cell[3220, 90, 398, 14, 70, "FormatNotes",
 CellID->344331575],
Cell[3621, 106, 257, 8, 70, "FormatNotes",
 CellID->56646289],
Cell[3881, 116, 99, 1, 70, "FormatNotes",
 CellID->718923602]
}, Open  ]],
Cell[CellGroupData[{
Cell[4017, 122, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[4084, 125, 303, 11, 70, "FormatNotes",
 CellID->28652],
Cell[4390, 138, 350, 13, 70, "FormatNotes",
 CellID->8194],
Cell[4743, 153, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4785, 156, 379, 11, 70, "FormatNotes",
 CellID->28396],
Cell[5167, 169, 576, 20, 70, "FormatNotes",
 CellID->7572],
Cell[5746, 191, 199, 6, 70, "FormatNotes",
 CellID->1052031979],
Cell[5948, 199, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[5990, 202, 351, 13, 70, "FormatNotes",
 CellID->29174],
Cell[6344, 217, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[6921, 239, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[7504, 262, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[8210, 289, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[8251, 292, 529, 20, 70, "FormatNotes",
 CellID->20289],
Cell[8783, 314, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[9861, 356, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[10525, 380, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[11343, 410, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11384, 413, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[11748, 429, 352, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[12137, 448, 75, 1, 70, "NotebookInterfaceSection",
 CellID->2075609843],
Cell[12215, 451, 158, 4, 70, "FormatNotes",
 CellID->1050269433]
}, Closed]],
Cell[CellGroupData[{
Cell[12410, 460, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[12469, 463, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[12668, 473, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[13381, 489, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[13425, 492, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[13500, 495, 675, 18, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[14178, 515, 382, 14, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[14597, 534, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[14653, 537, 195, 8, 70, "FormatNotes",
 CellID->577662107],
Cell[14851, 547, 775, 20, 70, "3ColumnTableMod",
 CellID->275885706],
Cell[15629, 569, 693, 28, 70, "FormatNotes",
 CellID->1175867229],
Cell[16325, 599, 194, 8, 70, "FormatNotes",
 CellID->431454156],
Cell[16522, 609, 482, 12, 70, "3ColumnTableMod",
 CellID->1545207620],
Cell[17007, 623, 307, 12, 70, "FormatNotes",
 CellID->363422294],
Cell[17317, 637, 641, 15, 70, "3ColumnTableMod",
 CellID->595003190],
Cell[17961, 654, 269, 9, 70, "FormatNotes",
 CellID->751587654],
Cell[18233, 665, 391, 11, 70, "FormatNotes",
 CellID->1294656327],
Cell[18627, 678, 275, 7, 70, "FormatNotes",
 CellID->1132802757],
Cell[18905, 687, 387, 13, 70, "FormatNotes",
 CellID->984576485],
Cell[19295, 702, 126, 3, 70, "FormatNotes",
 CellID->689403646],
Cell[19424, 707, 44, 1, 70, "WeakDivider",
 CellID->1791006941],
Cell[19471, 710, 182, 7, 70, "FormatNotes",
 CellID->175377388],
Cell[19656, 719, 2858, 78, 70, "3ColumnTableMod",
 CellID->1220196432],
Cell[22517, 799, 733, 25, 70, "FormatNotes",
 CellID->968510758],
Cell[23253, 826, 307, 9, 70, "FormatNotes",
 CellID->2005072920],
Cell[23563, 837, 271, 8, 70, "FormatNotes",
 CellID->1534753898],
Cell[23837, 847, 44, 1, 70, "WeakDivider",
 CellID->1520087421],
Cell[23884, 850, 182, 7, 70, "FormatNotes",
 CellID->1643820035],
Cell[24069, 859, 459, 12, 70, "3ColumnTableMod",
 CellID->306209590],
Cell[24531, 873, 148, 4, 70, "FormatNotes",
 CellID->5556],
Cell[24682, 879, 1222, 31, 70, "2ColumnTableMod",
 CellID->1993],
Cell[25907, 912, 332, 11, 70, "FormatNotes",
 CellID->1182679569]
}, Closed]],
Cell[CellGroupData[{
Cell[26276, 928, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[26334, 931, 593, 20, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[26964, 956, 58, 1, 70, "MoreAboutSection",
 CellID->281528422],
Cell[27025, 959, 117, 2, 70, "MoreAbout"],
Cell[27145, 963, 134, 2, 70, "MoreAbout"],
Cell[27282, 967, 133, 2, 70, "MoreAbout"],
Cell[27418, 971, 119, 2, 70, "MoreAbout"],
Cell[27540, 975, 134, 2, 70, "MoreAbout"],
Cell[27677, 979, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[27863, 986, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[27979, 992, 60, 1, 70, "ExampleSection",
 CellID->219648491],
Cell[28042, 995, 74, 1, 70, "ExampleText",
 CellID->73952109],
Cell[CellGroupData[{
Cell[28141, 1000, 142, 4, 70, "Input",
 CellID->976592890],
Cell[28286, 1006, 1680, 37, 70, "Output",
 CellID->1419438571]
}, Open  ]],
Cell[29981, 1046, 208, 8, 70, "ExampleText",
 CellID->1667547997],
Cell[CellGroupData[{
Cell[30214, 1058, 432, 14, 70, "Input",
 CellID->185532426],
Cell[30649, 1074, 1307, 28, 70, "Output",
 CellID->108228274]
}, Open  ]],
Cell[31971, 1105, 84, 1, 70, "ExampleText",
 CellID->1745332150],
Cell[CellGroupData[{
Cell[32080, 1110, 224, 6, 70, "Input",
 CellID->1817592229],
Cell[32307, 1118, 1523, 34, 70, "Output",
 CellID->1178683554]
}, Open  ]],
Cell[33845, 1155, 126, 3, 70, "ExampleDelimiter",
 CellID->1497700896],
Cell[33974, 1160, 187, 6, 70, "ExampleText",
 CellID->1203132585],
Cell[CellGroupData[{
Cell[34186, 1170, 256, 9, 70, "Input",
 CellID->343335943],
Cell[34445, 1181, 91, 2, 70, "Output",
 CellID->159824205]
}, Open  ]],
Cell[CellGroupData[{
Cell[34573, 1188, 142, 4, 70, "Input",
 CellID->1143037257],
Cell[34718, 1194, 200, 7, 70, "Output",
 CellID->1810854685]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[34957, 1206, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

