(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29490,       1007]
NotebookOptionsPosition[     24235,        839]
NotebookOutlinePosition[     25688,        878]
CellTagsIndexPosition[     25603,        873]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"EPS\"" :> Documentation`HelpLookup["paclet:ref/format/EPS"], 
          "\"HTML\"" :> Documentation`HelpLookup["paclet:ref/format/HTML"], 
          "\"LaTeX\"" :> Documentation`HelpLookup["paclet:ref/format/LaTeX"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"NB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/NB"], "\"PDF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PDF"], "\"RTF\"" :> 
          Documentation`HelpLookup["paclet:ref/format/RTF"], "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"EPS\\\"\"\>", 
       2->"\<\"\\\"HTML\\\"\"\>", 3->"\<\"\\\"LaTeX\\\"\"\>", 
       4->"\<\"\\\"MathML\\\"\"\>", 5->"\<\"\\\"NB\\\"\"\>", 
       6->"\<\"\\\"PDF\\\"\"\>", 7->"\<\"\\\"RTF\\\"\"\>", 
       8->"\<\"\\\"XHTML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Formats" :> 
          Documentation`HelpLookup["paclet:guide/DocumentFormats"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "Print Formats" :> 
          Documentation`HelpLookup["paclet:guide/PrintFormats"], 
          "Vector Graphics Formats" :> 
          Documentation`HelpLookup["paclet:guide/VectorGraphicsFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Document Formats\"\>", 
       2->"\<\"Graphics Importing & Exporting\"\>", 
       3->"\<\"Importing & Exporting\"\>", 
       4->"\<\"Listing of All Formats\"\>", 5->"\<\"Print Formats\"\>", 
       6->"\<\"Vector Graphics Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TeX ",
 StyleBox["(", "FilenameExtension"],
 ".tex",
 StyleBox[")", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->14713],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/x-tex", "InlineCode"],
 "\n",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " typesetting system and programming language.\nCommonly used for \
typesetting mathematical and scientific publications and other technical \
documents.\nPlain text format.\nDescribes the contents and the layout of \
multi-page documents.\nDeveloped since 1977 by Donald Knuth."
}], "FormatUsage",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " creates files compatible with AMS-",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8486],

Cell[TextData[{
 "See the ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 " reference page for complete information about importing ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " documents."
}], "FormatNotes",
 CellID->1625118130]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->3455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports arbitrary expressions,",
 " ",
 Cell[BoxData[
  ButtonBox["Notebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Notebook"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " objects, as well as any box expressions obtained from ",
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " to the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " format."
}], "FormatNotes",
 CellID->29614],

Cell[TextData[{
 "The exported ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " includes markup material which maintains much of the document structure \
that exists within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "FormatNotes",
 CellID->28213],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " always generates complete AMS-",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " documents, not merely ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " language fragments."
}], "FormatNotes",
 CellID->894165379],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " can be used to create a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " version of a typeset expression."
}], "FormatNotes",
 CellID->146963147],

Cell["", "WeakDivider",
 CellID->29082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).tex\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12455],

Cell[TextData[{
 "The export format can be explicitly specified with the command",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "expr", ",", "\"\<TeX\>\""}], "]"}]], 
  "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8752],

Cell["", "WeakDivider",
 CellID->15821],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " format."
}], "FormatNotes",
 CellID->26281]
}, Closed]],

Cell[CellGroupData[{

Cell["NOTEBOOK INTERFACE", "NotebookInterfaceSection",
 CellID->1615],

Cell[TextData[{
 "In the notebook front end, ",
 StyleBox["Save As", "MenuName"],
 " exports the active notebook as a ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->1680934938],

Cell[TextData[{
 StyleBox["Save Selection As", "MenuName"],
 " exports the selected part of a notebook to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->11064]
}, Closed]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->524436405],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BoxRules\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "specifies mappings from",
     StyleBox[" Mathematica",
      FontSlant->"Italic"],
     " box expressions to ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " elements"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ConversionRules\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "specifies mappings from ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     Cell[BoxData[
      FormBox[
       StyleBox["cell", "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " styles to ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " elements"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DocumentClass\>\"", 
    "\"\<article\>\"", Cell[TextData[{
     "what ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"L", 
         StyleBox[
          AdjustmentBox["A",
           BoxBaselineShift->-0.4,
           BoxMargins->{{-0.5, -0.3}, {0, 0}}],
          FontSize->Smaller], "T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " document type to use"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MathOutput\>\"", "\"\<TeX\>\"", Cell[
    "format to use for typeset expressions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UsePackages\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "list of packages to include in \\",
     StyleBox["usepackage{}", "InlineCode"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->583498391],

Cell[TextData[{
 "Typical settings for ",
 Cell[BoxData["\"\<DocumentClass\>\""], "InlineFormula"],
 " include ",
 StyleBox["\"article\"", "InlineCode"],
 ", ",
 StyleBox["\"report\"", "InlineCode"],
 " and ",
 StyleBox["\"letter\"", "InlineCode"],
 "."
}], "FormatNotes",
 CellID->2045784812],

Cell[TextData[{
 "Possible values for ",
 Cell[BoxData["\"\<MathOutput\>\""], "InlineFormula"],
 " are:"
}], "FormatNotes",
 CellID->144663167],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EPS\>\"", Cell["\<\
converts typeset expressions to EPS, stored in separate files\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<TeX\>\"", Cell[TextData[{
     "formats all typeset expressions to embedded ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " macros"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->27843152]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<EPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/EPS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<HTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/HTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LaTeX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LaTeX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PDF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PDF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RTF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RTF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1616912827]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->248182674],

Cell[TextData[ButtonBox["Document Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Print Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrintFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Vector Graphics Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/VectorGraphicsFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->26371081],

Cell[TextData[{
 "Export an arbitrary expression to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1678575301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "#"}]}], "&"}], ",", "x", ",", "5"}], "]"}], ",", 
   "\"\<TeX\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2040975413],

Cell[BoxData["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\n\\n\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\n\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{\
}}\\n\\n\\\\begin{document}\\n\\\\[1+\\\\frac{1}{1+\\\\frac{1}{1+\\\\frac{1}{\
1+\\\\frac{1}{1+\\\\frac{1}{x}}}}}\\\\]\\n\\n\\\\end{document}\\n\"\>"], \
"Output",
 CellLabel->"Out[1]=",
 CellID->286747913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->506981241],

Cell[TextData[{
 "This converts a ",
 Cell[BoxData[
  ButtonBox["Cell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
 " expression to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1766089838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{
     "TextData", "[", "\"\<Exporting a Cell expression to TeX\>\"", "]"}], 
     ",", "\"\<Subsection\>\""}], "]"}], ",", "\"\<TeX\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->2129048764],

Cell[BoxData["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\n\\n\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\n\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{\
}}\\n\\n\\\\begin{document}\\n\\\\subsection*{Exporting a Cell expression to \
TeX}\\n\\n\\\\end{document}\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->418869923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1651235102],

Cell[TextData[{
 "Specify ",
 Cell[BoxData["\"\<ConversionRules\>\""], "InlineFormula"],
 " for the translation of a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " style element to a user-defined ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " macro:"
}], "ExampleText",
 CellID->152938432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Cell", "[", 
    RowBox[{
     RowBox[{
     "TextData", "[", "\"\<Exporting Cell expressions to TeX\>\"", "]"}], 
     ",", "\"\<Subsection\>\""}], "]"}], ",", "\"\<TeX\>\"", ",", 
   RowBox[{"\"\<ConversionRules\>\"", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Subsection\>\"", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\\n\\\\mymacro{\>\"", ",", "\"\<}\\n\>\""}], "}"}]}], 
     "}"}]}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1382031393],

Cell[BoxData["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\n\\n\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\n\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{\
}}\\n\\n\\\\begin{document}\\n\\n\\\\mymacro{Exporting Cell expressions to \
TeX}\\n\\n\\n\\\\end{document}\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->410423546]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1955904265],

Cell["\<\
Convert typeset expressions to EPS, stored in separate files:\
\>", "ExampleText",
 CellID->1350797226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"x", "-", "y"}], "]"}], ",", "\"\<TeX\>\"", ",", " ", 
   RowBox[{"\"\<MathOutput\>\"", " ", "\[Rule]", " ", "\"\<EPS\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1195814251],

Cell[BoxData["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\n\\n\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\n\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{\
}}\\n\\n\\\\begin{document}\\n\\\\includegraphics{m00001350391_gr1.eps}\\n\\n\
\\\\end{document}\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->271063458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1858295164],

Cell[TextData[{
 "Use the ",
 Cell[BoxData["\"\<BoxRules\>\""], "InlineFormula"],
 " option to customize how ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " boxes are translated to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1512143027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "3", "]"}], ",", "\"\<TeX\>\"", ",", 
   RowBox[{"\"\<TeXRules\>\"", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SqrtBox", "[", "x_", "]"}], ":>", 
      RowBox[{"x", "<>", "\"\<^(1/2)\>\""}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182961002],

Cell[BoxData["\<\"%% AMS-LaTeX Created by Wolfram Mathematica \
6.0\\n\\n\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, \
graphics}\\n\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{\
}}\\n\\n\\\\begin{document}\\n\\\\[\\\\sqrt{3}\\\\]\\n\\n\\\\end{document}\\n\
\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->950723319]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TeX - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 22.2797686}", "context" -> "", 
    "keywords" -> {"PostScript", "page layout", "typesetting"}, "index" -> 
    True, "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/x-tex TEX typesetting system and programming \
language. Commonly used for typesetting mathematical and scientific \
publications and other technical documents. Plain text format. Describes the \
contents and the layout of multi-page documents. Developed since 1977 by \
Donald Knuth.", "synonyms" -> {}, "title" -> "TeX", "type" -> "Format", "uri" -> 
    "ref/format/TeX"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17698, 611, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25469, 866}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2700, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3323, 83, 143, 6, 70, "ObjectNameAlt",
 CellID->14713],
Cell[3469, 91, 633, 17, 70, "FormatUsage",
 CellID->27666],
Cell[4105, 110, 589, 21, 70, "FormatNotes",
 CellID->8486],
Cell[4697, 133, 506, 17, 70, "FormatNotes",
 CellID->1625118130]
}, Open  ]],
Cell[CellGroupData[{
Cell[5240, 155, 52, 1, 70, "ImportExportSection",
 CellID->3455],
Cell[5295, 158, 1006, 36, 70, "FormatNotes",
 CellID->29614],
Cell[6304, 196, 455, 16, 70, "FormatNotes",
 CellID->28213],
Cell[6762, 214, 870, 30, 70, "FormatNotes",
 CellID->894165379],
Cell[7635, 246, 471, 16, 70, "FormatNotes",
 CellID->146963147],
Cell[8109, 264, 39, 1, 70, "WeakDivider",
 CellID->29082],
Cell[8151, 267, 749, 27, 70, "FormatNotes",
 CellID->12455],
Cell[8903, 296, 365, 13, 70, "FormatNotes",
 CellID->8752],
Cell[9271, 311, 39, 1, 70, "WeakDivider",
 CellID->15821],
Cell[9313, 314, 236, 9, 70, "FormatNotes",
 CellID->17296],
Cell[9552, 325, 441, 16, 70, "FormatNotes",
 CellID->26281]
}, Closed]],
Cell[CellGroupData[{
Cell[10030, 346, 69, 1, 70, "NotebookInterfaceSection",
 CellID->1615],
Cell[10102, 349, 403, 14, 70, "FormatNotes",
 CellID->1680934938],
Cell[10508, 365, 381, 13, 70, "FormatNotes",
 CellID->11064]
}, Closed]],
Cell[CellGroupData[{
Cell[10926, 383, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[10978, 386, 196, 8, 70, "FormatNotes",
 CellID->524436405],
Cell[11177, 396, 2571, 73, 70, "3ColumnTableMod",
 CellID->583498391],
Cell[13751, 471, 293, 11, 70, "FormatNotes",
 CellID->2045784812],
Cell[14047, 484, 143, 5, 70, "FormatNotes",
 CellID->144663167],
Cell[14193, 491, 828, 22, 70, "2ColumnTableMod",
 CellID->27843152]
}, Closed]],
Cell[CellGroupData[{
Cell[15058, 518, 49, 1, 70, "SeeAlsoSection",
 CellID->4747],
Cell[15110, 521, 1644, 55, 70, "SeeAlso",
 CellID->1616912827]
}, Open  ]],
Cell[CellGroupData[{
Cell[16791, 581, 58, 1, 70, "MoreAboutSection",
 CellID->248182674],
Cell[16852, 584, 123, 2, 70, "MoreAbout"],
Cell[16978, 588, 151, 2, 70, "MoreAbout"],
Cell[17132, 592, 134, 2, 70, "MoreAbout"],
Cell[17269, 596, 133, 2, 70, "MoreAbout"],
Cell[17405, 600, 117, 2, 70, "MoreAbout"],
Cell[17525, 604, 136, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17698, 611, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[17814, 617, 59, 1, 70, "ExampleSection",
 CellID->26371081],
Cell[17876, 620, 332, 12, 70, "ExampleText",
 CellID->1678575301],
Cell[CellGroupData[{
Cell[18233, 636, 289, 10, 70, "Input",
 CellID->2040975413],
Cell[18525, 648, 423, 7, 70, "Output",
 CellID->286747913]
}, Open  ]],
Cell[18963, 658, 125, 3, 70, "ExampleDelimiter",
 CellID->506981241],
Cell[19091, 663, 445, 17, 70, "ExampleText",
 CellID->1766089838],
Cell[CellGroupData[{
Cell[19561, 684, 309, 10, 70, "Input",
 CellID->2129048764],
Cell[19873, 696, 386, 6, 70, "Output",
 CellID->418869923]
}, Open  ]],
Cell[20274, 705, 126, 3, 70, "ExampleDelimiter",
 CellID->1651235102],
Cell[20403, 710, 489, 17, 70, "ExampleText",
 CellID->152938432],
Cell[CellGroupData[{
Cell[20917, 731, 551, 15, 70, "Input",
 CellID->1382031393],
Cell[21471, 748, 387, 6, 70, "Output",
 CellID->410423546]
}, Open  ]],
Cell[21873, 757, 126, 3, 70, "ExampleDelimiter",
 CellID->1955904265],
Cell[22002, 762, 113, 3, 70, "ExampleText",
 CellID->1350797226],
Cell[CellGroupData[{
Cell[22140, 769, 284, 8, 70, "Input",
 CellID->1195814251],
Cell[22427, 779, 376, 6, 70, "Output",
 CellID->271063458]
}, Open  ]],
Cell[22818, 788, 126, 3, 70, "ExampleDelimiter",
 CellID->1858295164],
Cell[22947, 793, 468, 17, 70, "ExampleText",
 CellID->1512143027],
Cell[CellGroupData[{
Cell[23440, 814, 370, 10, 70, "Input",
 CellID->182961002],
Cell[23813, 826, 356, 6, 70, "Output",
 CellID->950723319]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[24208, 837, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

