(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20789,        758]
NotebookOptionsPosition[     16417,        617]
NotebookOutlinePosition[     17804,        655]
CellTagsIndexPosition[     17719,        650]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Base64\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Base64"], "\"GZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GZIP"], "\"MBOX\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MBOX"], "\"TAR\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TAR"], "\"ZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ZIP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"Base64\\\"\"\>", 
       2->"\<\"\\\"GZIP\\\"\"\>", 3->"\<\"\\\"MBOX\\\"\"\>", 
       4->"\<\"\\\"TAR\\\"\"\>", 
       5->"\<\"\\\"ZIP\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "UUE ",
 StyleBox["(.enc, .uue)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Unix uuencoding format.
Encodes binary data as a sequence of printable ASCII characters.
Commonly used for the transmission of binary content by email.
The name uuencode is derived from Unix-to-Unix encoding.
ASCII format.
Uses printable ASCII characters to encode binary data.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " support the uuencoding format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", "]"}]], "InlineFormula"],
 " imports a uuencoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->162514879],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", " ", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an expression to a uuencoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).uue\>\"", "]"}]], "InlineFormula"],
 "decodes a uuencoded file and imports its contents as an expression, \
automatically inferring the format from the file contents."
}], "FormatNotes",
 CellID->450071431],

Cell[TextData[{
 "The import format can be given explicitly with",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<UUE\>\"", ",", " ", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\""}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->913136083],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a uuencoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"]}]], "InlineFormula"],
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format and file encoding can be explicitly specified with ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "[ \"",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "\", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<UUE\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
     SubscriptBox[
      StyleBox["elems", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["elems", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->790737906],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a uuencoded ",
 Cell[BoxData[
  RowBox[{".", 
   StyleBox["ext", "TI"], " "}]], "InlineFormula"],
 "file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).\!\(\*
StyleBox[\"ext\", \"TI\"]\).uue\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell[TextData[{
 "The export format and file encoding can be explicitly specified with",
 " ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "[",
 StyleBox["\"file\"", "TI"],
 ", ",
 Cell[BoxData[
  StyleBox["exprs", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<UUE\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", 
     StyleBox["elems", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->1935856016],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support UUE encoding."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<Base64\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Base64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MBOX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MBOX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TAR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TAR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ZIP"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1206266236]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->3426295],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->650554598],

Cell["This applies uuencoding to text:", "ExampleText",
 CellID->225373930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{"\"\<One fish two fish\>\"", ",", " ", 
   RowBox[{"{", 
    RowBox[{"\"\<UUE\>\"", ",", " ", "\"\<Text\>\""}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData["\<\"begin 666 \
filename.ext\\n13VYE(&9I<V@@='=O(&9I<V@`\\n`\\nend\\n\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1653461066]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<UUE\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1278230740],

Cell[BoxData["\<\"One fish two fish\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1281744082]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->864323117],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " can uuencode arbitrary expressions:"
}], "ExampleText",
 CellID->1099239111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "/", "12"}], ",", 
   "\"\<UUE\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109923436],

Cell[BoxData["\<\"begin 666 filename.ext\\n/*&$@*R!3:6Y;>%TI+S$R\\n`\\nend\\n\
\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1845971849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"%", ",", "\"\<UUE\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1366952569],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{"a", "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "Output",
 CellLabel->"Out[2]=",
 CellID->552617934]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UUE - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 31.9206404}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Unix uuencoding format. Encodes binary data as a sequence of printable \
ASCII characters. Commonly used for the transmission of binary content by \
email. The name uuencode is derived from Unix-to-Unix encoding. ASCII format. \
Uses printable ASCII characters to encode binary data.", "synonyms" -> {}, 
    "title" -> "UUE", "type" -> "Format", "uri" -> "ref/format/UUE"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14323, 522, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17585, 643}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2164, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2787, 76, 113, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2903, 82, 327, 8, 70, "FormatUsage",
 CellID->37585799],
Cell[3233, 92, 329, 12, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3599, 109, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3666, 112, 395, 14, 70, "FormatNotes",
 CellID->162514879],
Cell[4064, 128, 460, 16, 70, "FormatNotes",
 CellID->8194],
Cell[4527, 146, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[4569, 149, 378, 10, 70, "FormatNotes",
 CellID->450071431],
Cell[4950, 161, 443, 15, 70, "FormatNotes",
 CellID->913136083],
Cell[5396, 178, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[5438, 181, 466, 16, 70, "FormatNotes",
 CellID->29174],
Cell[5907, 199, 609, 21, 70, "FormatNotes",
 CellID->18819],
Cell[6519, 222, 615, 22, 70, "FormatNotes",
 CellID->943],
Cell[7137, 246, 697, 24, 70, "FormatNotes",
 CellID->790737906],
Cell[7837, 272, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[7878, 275, 643, 23, 70, "FormatNotes",
 CellID->20289],
Cell[8524, 300, 1110, 41, 70, "FormatNotes",
 CellID->8419],
Cell[9637, 343, 696, 23, 70, "FormatNotes",
 CellID->5565],
Cell[10336, 368, 850, 29, 70, "FormatNotes",
 CellID->3805],
Cell[11189, 399, 559, 21, 70, "FormatNotes",
 CellID->1935856016],
Cell[11751, 422, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[11792, 425, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[12156, 441, 340, 12, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[12533, 458, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12591, 461, 1016, 34, 70, "SeeAlso",
 CellID->1206266236]
}, Open  ]],
Cell[CellGroupData[{
Cell[13644, 500, 56, 1, 70, "MoreAboutSection",
 CellID->3426295],
Cell[13703, 503, 151, 2, 70, "MoreAbout"],
Cell[13857, 507, 134, 2, 70, "MoreAbout"],
Cell[13994, 511, 133, 2, 70, "MoreAbout"],
Cell[14130, 515, 156, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14323, 522, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14439, 528, 60, 1, 70, "ExampleSection",
 CellID->650554598],
Cell[14502, 531, 75, 1, 70, "ExampleText",
 CellID->225373930],
Cell[CellGroupData[{
Cell[14602, 536, 238, 7, 70, "Input",
 CellID->976592890],
Cell[14843, 545, 144, 3, 70, "Output",
 CellID->1653461066]
}, Open  ]],
Cell[CellGroupData[{
Cell[15024, 553, 142, 4, 70, "Input",
 CellID->1278230740],
Cell[15169, 559, 96, 2, 70, "Output",
 CellID->1281744082]
}, Open  ]],
Cell[15280, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->864323117],
Cell[15408, 569, 144, 5, 70, "ExampleText",
 CellID->1099239111],
Cell[CellGroupData[{
Cell[15577, 578, 255, 9, 70, "Input",
 CellID->109923436],
Cell[15835, 589, 140, 3, 70, "Output",
 CellID->1845971849]
}, Open  ]],
Cell[CellGroupData[{
Cell[16012, 597, 142, 4, 70, "Input",
 CellID->1366952569],
Cell[16157, 603, 194, 7, 70, "Output",
 CellID->552617934]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[16390, 615, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

