(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24003,        820]
NotebookOptionsPosition[     19677,        678]
NotebookOutlinePosition[     20941,        714]
CellTagsIndexPosition[     20856,        709]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary" :> 
          Documentation`HelpLookup["paclet:ref/format/Binary"], "Bit" :> 
          Documentation`HelpLookup["paclet:ref/format/Bit"], "Byte" :> 
          Documentation`HelpLookup["paclet:ref/format/Byte"], "Character8" :> 
          Documentation`HelpLookup["paclet:ref/format/Character8"], 
          "Character16" :> 
          Documentation`HelpLookup["paclet:ref/format/Character16"], 
          "Integer8" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer8"], "Integer16" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer16"], 
          "Integer24" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer24"], 
          "Integer32" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer32"], 
          "Integer64" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer64"], 
          "Integer128" :> 
          Documentation`HelpLookup["paclet:ref/format/Integer128"], 
          "UnsignedInteger8" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger8"], 
          "UnsignedInteger16" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger16"], 
          "UnsignedInteger32" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger32"], 
          "UnsignedInteger64" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger64"], 
          "UnsignedInteger128" :> 
          Documentation`HelpLookup["paclet:ref/format/UnsignedInteger128"], 
          "Real32" :> Documentation`HelpLookup["paclet:ref/format/Real32"], 
          "Real64" :> Documentation`HelpLookup["paclet:ref/format/Real64"], 
          "Real128" :> Documentation`HelpLookup["paclet:ref/format/Real128"], 
          "Complex64" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex64"], 
          "Complex128" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex128"], 
          "Complex256" :> 
          Documentation`HelpLookup["paclet:ref/format/Complex256"], "String" :> 
          Documentation`HelpLookup["paclet:ref/format/String"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary\"\>", 2->"\<\"Bit\"\>", 
       3->"\<\"Byte\"\>", 4->"\<\"Character8\"\>", 5->"\<\"Character16\"\>", 
       6->"\<\"Integer8\"\>", 7->"\<\"Integer16\"\>", 8->"\<\"Integer24\"\>", 
       9->"\<\"Integer32\"\>", 10->"\<\"Integer64\"\>", 
       11->"\<\"Integer128\"\>", 12->"\<\"UnsignedInteger8\"\>", 
       13->"\<\"UnsignedInteger16\"\>", 14->"\<\"UnsignedInteger32\"\>", 
       15->"\<\"UnsignedInteger64\"\>", 16->"\<\"UnsignedInteger128\"\>", 
       17->"\<\"Real32\"\>", 18->"\<\"Real64\"\>", 19->"\<\"Real128\"\>", 
       20->"\<\"Complex64\"\>", 21->"\<\"Complex128\"\>", 
       22->"\<\"Complex256\"\>", 23->"\<\"String\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Listing of All Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnsignedInteger32", "ObjectNameAlt",
 CellID->2066222148],

Cell["\<\
Sequence of unsigned 32-bit integers.
Raw binary format.
Equivalent to the Byte format.\
\>", "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " can read any file as a sequence of unsigned 32-bit integers."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " writes a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "32"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 " to a binary file."
}], "FormatNotes",
 CellID->1289702565]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<UnsignedInteger32\>\""}], "]"}]],
   "InlineFormula"],
 " imports any file, returning a packed array of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "32"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["list", "TI"], ",", "\"\<UnsignedInteger32\>\""}], "]"}]], 
  "InlineFormula"],
 " exports a list of integers in the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{"0", ",", 
     SuperscriptBox["2", "32"], "-", "1"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "FormatNotes",
 CellID->8194],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UnsignedInteger32\>\"", ",", 
       StyleBox["elem", "TI"]}]}]}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    StyleBox["elem", "TI"]}], 
   StyleBox[" ", "TI"], "]"}]], "InlineFormula"],
 " imports the specified element from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<UnsignedInteger32\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["elem", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "UnsignedInteger32",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation element:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[TextData[{
     "list of integers in the range ",
     Cell[BoxData[
      FormBox[
       RowBox[{"(", 
        RowBox[{"0", ",", 
         SuperscriptBox["2", "32"], "-", "1"}], ")"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->611127238],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " use the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element."
}], "FormatNotes",
 CellID->456888197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<UnsignedInteger32\>\"", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], " "}]], "InlineFormula"],
 "gives the ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " 32-bit integer from ",
 Cell[BoxData[
  StyleBox["file", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->61452522],

Cell["\<\
Trailing bytes are ignored if the size of the imported file is not a multiple \
of the data size.\
\>", "FormatNotes",
 CellID->647021390]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell["General option:", "FormatNotes",
 CellID->577662107],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ByteOrdering",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ByteOrdering"], 
    RowBox[{"-", "1"}], Cell["what byte ordering to use", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->2140947909],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->1838786897],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<HeaderBytes\>\"", "0", Cell[
    "how many bytes to skip at the beginning of the file", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->54213902]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Binary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Binary"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Bit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Bit"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Byte",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Byte"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Character16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Character16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer24",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer24"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Integer128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Integer128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger8",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger8"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger16",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger16"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["UnsignedInteger128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/UnsignedInteger128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real32",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real32"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Real128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Real128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex64",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex64"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex128",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex128"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["Complex256",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Complex256"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["String",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/String"]], "InlineFormula"]
}], "SeeAlso",
 CellID->344804987]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->28203978],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->19840131],

Cell["\<\
Convert a list of integers to a string representing binary 32-bit unsigned \
integers:\
\>", "ExampleText",
 CellID->1155101741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"ExportString", "[", 
   RowBox[{
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "9"}], "]"}], ",", "\"\<UnsignedInteger32\>\""}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->841536072],

Cell[BoxData["\<\"\.00\.00\.00\.00\.01\.00\.00\.00\.02\.00\.00\.00\.03\.00\.00\
\.00\.04\.00\.00\.00\.05\.00\.00\.00\.06\.00\.00\.00\.07\.00\.00\.00\.08\.00\
\.00\.00\\t\.00\.00\.00\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->201927358]
}, Open  ]],

Cell["Verify that the correct number of bytes was written:", "ExampleText",
 CellID->542792107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringLength", "[", "s", "]"}], "/", "4"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->947343766],

Cell[BoxData["10"], "Output",
 CellLabel->"Out[2]=",
 CellID->768943646]
}, Open  ]],

Cell["Convert the binary data back to an expression:", "ExampleText",
 CellID->378706212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ImportString", "[", 
  RowBox[{"s", ",", "\"\<UnsignedInteger32\>\""}], " ", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1921259023],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
   ",", "8", ",", "9"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->79270676]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnsignedInteger32 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 24.9985882}", "context" -> "", 
    "keywords" -> {"binary data", "C", "Fortran"}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Sequence of unsigned 32-bit integers. Raw binary format. Equivalent to \
the Byte format.", "synonyms" -> {}, "title" -> "UnsignedInteger32", "type" -> 
    "Format", "uri" -> "ref/format/UnsignedInteger32"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17937, 604, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20722, 702}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3830, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4453, 103, 63, 1, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[4519, 106, 137, 5, 70, "FormatUsage",
 CellID->37585799],
Cell[4659, 113, 234, 7, 70, "FormatNotes",
 CellID->344331575],
Cell[4896, 122, 391, 14, 70, "FormatNotes",
 CellID->1289702565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5324, 141, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[5391, 144, 522, 18, 70, "FormatNotes",
 CellID->28652],
Cell[5916, 164, 527, 19, 70, "FormatNotes",
 CellID->8194],
Cell[6446, 185, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[6488, 188, 755, 27, 70, "FormatNotes",
 CellID->29174],
Cell[7246, 217, 635, 22, 70, "FormatNotes",
 CellID->943],
Cell[7884, 241, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7925, 244, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[8289, 260, 366, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[8692, 279, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[8751, 282, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[8950, 292, 692, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[9645, 308, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[9689, 311, 71, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[9763, 314, 557, 16, 70, "2ColumnTableMod",
 CellID->611127238],
Cell[10323, 332, 387, 15, 70, "FormatNotes",
 CellID->456888197],
Cell[10713, 349, 634, 23, 70, "FormatNotes",
 CellID->61452522],
Cell[11350, 374, 148, 4, 70, "FormatNotes",
 CellID->647021390]
}, Open  ]],
Cell[CellGroupData[{
Cell[11535, 383, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[11591, 386, 58, 1, 70, "FormatNotes",
 CellID->577662107],
Cell[11652, 389, 461, 12, 70, "3ColumnTableMod",
 CellID->2140947909],
Cell[12116, 403, 182, 7, 70, "FormatNotes",
 CellID->1838786897],
Cell[12301, 412, 393, 9, 70, "3ColumnTableMod",
 CellID->54213902]
}, Closed]],
Cell[CellGroupData[{
Cell[12731, 426, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12789, 429, 4881, 160, 70, "SeeAlso",
 CellID->344804987]
}, Open  ]],
Cell[CellGroupData[{
Cell[17707, 594, 57, 1, 70, "MoreAboutSection",
 CellID->28203978],
Cell[17767, 597, 133, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17937, 604, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18053, 610, 59, 1, 70, "ExampleSection",
 CellID->19840131],
Cell[18115, 613, 138, 4, 70, "ExampleText",
 CellID->1155101741],
Cell[CellGroupData[{
Cell[18278, 621, 253, 8, 70, "Input",
 CellID->841536072],
Cell[18534, 631, 241, 4, 70, "Output",
 CellID->201927358]
}, Open  ]],
Cell[18790, 638, 95, 1, 70, "ExampleText",
 CellID->542792107],
Cell[CellGroupData[{
Cell[18910, 643, 131, 4, 70, "Input",
 CellID->947343766],
Cell[19044, 649, 72, 2, 70, "Output",
 CellID->768943646]
}, Open  ]],
Cell[19131, 654, 89, 1, 70, "ExampleText",
 CellID->378706212],
Cell[CellGroupData[{
Cell[19245, 659, 161, 4, 70, "Input",
 CellID->1921259023],
Cell[19409, 665, 202, 6, 70, "Output",
 CellID->79270676]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[19650, 676, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

