(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20497,        659]
NotebookOptionsPosition[     16106,        524]
NotebookOutlinePosition[     17712,        565]
CellTagsIndexPosition[     17627,        560]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Importing & Exporting" :> 
         Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
         "Listing of All Formats" :> 
         Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
         "Systems & Utility Formats" :> 
         Documentation`HelpLookup[
          "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Importing & Exporting\"\>", 
      2->"\<\"Listing of All Formats\"\>", 
      3->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
      StyleBox["\<\"more about\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "VCF ",
 StyleBox["(.vcf)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME types:",
 StyleBox[" text/directory, text/x-vcard", "InlineCode"],
 "\nvCard personal data format.\nCommonly used in email and personal \
information management applications and on mobile devices.\nStandard format \
for electronic business cards.\nVCF is an acronym derived from Versitcard.\n\
Stores names, addresses, and other contact information.\nCan contain multiple \
records.\nPlain text format.\nVersion 3.0 is described in internet standard \
recommendations RFC 2425 and 2426.\nDeveloped in 1995 by Apple, AT&T, IBM and \
Siemens."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports VCF Versions 2.1 and 3.0."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", "]"}]], "InlineFormula"],
 " imports a vCard as an array of rules."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", "]"}], " "}]], "InlineFormula"],
 "gives an array of rules for each record and each data field in the file."
}], "FormatNotes",
 CellID->28396],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ",
 "VCF",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<VCF\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<VCF\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the ",
 "VCF",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "records arranged as a table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Labels\>\"", Cell[TextData[{
     "labels associated with the columns of the table given by the ",
     Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Records\>\"", Cell[
    "rules for each record", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Records\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", "]"}]], "InlineFormula"],
 "reads all records and returns them as a list of list of rules."
}], "FormatNotes",
 CellID->676807488],

Cell["Selecting individual data fields:", "FormatNotes",
 CellID->301601943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<NamePrefix\>\"", Cell[
    "honorific prefix part of the name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NameFirst\>\"", Cell[
    "given name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NameMiddle\>\"", Cell[
    "middle name or initial", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NameLast\>\"", Cell[
    "last name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Organization\>\"", Cell[
    "organization or institution name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<JobTitle\>\"", Cell[
    "title or position in the organization", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Email\>\"", Cell[
    "email addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Phone\>\"", Cell[
    "phone numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Fax\>\"", Cell[
    "fax numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MobilePhone\>\"", Cell[
    "mobile phone numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BirthDate\>\"", Cell[TextData[{
     "birthday, given as a ",
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<InstantMessaging\>\"", Cell[
    "instant messaging addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Address1\>\"", Cell[
    "street address", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Address2\>\"", Cell[
    "continued street address", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<POBox\>\"", Cell[
    "post office box number, given as a string", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<City\>\"", Cell[
    "city name", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ZIPCode\>\"", Cell[
    "ZIP code", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<State\>\"", Cell[
    "state name or abbreviation", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Country\>\"", Cell[
    "country name", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True}}}},
 CellID->962449081],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).vcf\>\"", ",", "\"\<City\>\""}], "]"}]], 
  "InlineFormula"],
 " returns the city name for each record as a list of strings. "
}], "FormatNotes",
 CellID->1141620938]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Attribute\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "specifies what address type to import", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how missing information is represented", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->30333],

Cell[TextData[{
 "Possible settings for \"",
 Cell[BoxData["Attribute"], "InlineFormula"],
 "\" are:"
}], "FormatNotes",
 CellID->1858153612],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "all addresses stored in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "selects a single address per record", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Domestic\>\"", Cell[
    "domestic addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Home\>\"", Cell[
    "home addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<International\>\"", Cell[
    "international addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Postal\>\"", Cell[
    "postal addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Shipping\>\"", Cell[
    "shipping addresses", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Work\>\"", Cell[
    "work addresses", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1280562210],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<EmptyField\>\"", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", no rules are returned for missing information."
}], "FormatNotes",
 CellID->327953236]
}, Closed]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->2761177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", "\"\<ExampleData/wolfram.vcf\>\"", " ", "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"FormattedName\"\>", 
     "\[Rule]", "\<\"Wolfram Research, Inc.\"\>"}], ",", 
    RowBox[{"\<\"Organization\"\>", 
     "\[Rule]", "\<\"Wolfram Research, Inc.\"\>"}], ",", 
    RowBox[{"\<\"Email\"\>", "\[Rule]", "\<\"info@wolfram.com\"\>"}], ",", 
    RowBox[{"\<\"Phone\"\>", "\[Rule]", "\<\"217-398-0700\"\>"}], ",", 
    RowBox[{"\<\"Fax\"\>", "\[Rule]", "\<\"217-398-0747\"\>"}], ",", 
    RowBox[{"\<\"Address1\"\>", "\[Rule]", "\<\"100 Trade Center Drive\"\>"}],
     ",", 
    RowBox[{"\<\"City\"\>", "\[Rule]", "\<\"Champaign\"\>"}], ",", 
    RowBox[{"\<\"State\"\>", "\[Rule]", "\<\"IL\"\>"}], ",", 
    RowBox[{"\<\"ZIPCode\"\>", "\[Rule]", "\<\"61820\"\>"}], ",", 
    RowBox[{"\<\"Country\"\>", "\[Rule]", "\<\"USA\"\>"}]}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->510487310]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VCF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 32.1081452}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME types: text/directory, text/x-vcard vCard personal data format. \
Commonly used in email and personal information management applications and \
on mobile devices. Standard format for electronic business cards. VCF is an \
acronym derived from Versitcard. Stores names, addresses, and other contact \
information. Can contain multiple records. Plain text format. Version 3.0 is \
described in internet standard recommendations RFC 2425 and 2426. Developed \
in 1995 by Apple, AT&T, IBM and Siemens.", "synonyms" -> {}, "title" -> "VCF",
     "type" -> "Format", "uri" -> "ref/format/VCF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14791, 480, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17493, 553}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 938, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1561, 48, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[1671, 54, 602, 11, 70, "FormatUsage",
 CellID->37585799],
Cell[2276, 67, 214, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[2527, 79, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[2583, 82, 284, 9, 70, "FormatNotes",
 CellID->28652],
Cell[2870, 93, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[2912, 96, 340, 10, 70, "FormatNotes",
 CellID->28396],
Cell[3255, 108, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[3297, 111, 351, 13, 70, "FormatNotes",
 CellID->29174],
Cell[3651, 126, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[4228, 148, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[4811, 171, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[5517, 198, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[5558, 201, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[5797, 212, 216, 9, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[6050, 226, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[6109, 229, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[6308, 239, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[6983, 254, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[7027, 257, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[7102, 260, 720, 16, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[7825, 278, 261, 9, 70, "FormatNotes",
 CellID->1999285391],
Cell[8089, 289, 312, 9, 70, "FormatNotes",
 CellID->676807488],
Cell[8404, 300, 76, 1, 70, "FormatNotes",
 CellID->301601943],
Cell[8483, 303, 2666, 56, 70, "2ColumnTableMod",
 CellID->962449081],
Cell[11152, 361, 350, 11, 70, "FormatNotes",
 CellID->1141620938]
}, Open  ]],
Cell[CellGroupData[{
Cell[11539, 377, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[11591, 380, 178, 7, 70, "FormatNotes",
 CellID->31322],
Cell[11772, 389, 694, 17, 70, "3ColumnTableMod",
 CellID->30333],
Cell[12469, 408, 141, 5, 70, "FormatNotes",
 CellID->1858153612],
Cell[12613, 415, 1323, 31, 70, "2ColumnTableMod",
 CellID->1280562210],
Cell[13939, 448, 303, 9, 70, "FormatNotes",
 CellID->327953236]
}, Closed]],
Cell[CellGroupData[{
Cell[14279, 462, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[14340, 465, 134, 2, 70, "MoreAbout"],
Cell[14477, 469, 133, 2, 70, "MoreAbout"],
Cell[14613, 473, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14791, 480, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14907, 486, 58, 1, 70, "ExampleSection",
 CellID->2761177],
Cell[CellGroupData[{
Cell[14990, 491, 163, 5, 70, "Input",
 CellID->976592890],
Cell[15156, 498, 884, 19, 70, "Output",
 CellID->510487310]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[16079, 522, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

