(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47781,       1179]
NotebookOptionsPosition[     43522,       1044]
NotebookOutlinePosition[     44971,       1084]
CellTagsIndexPosition[     44885,       1079]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"3DS\"" :> Documentation`HelpLookup["paclet:ref/format/3DS"], 
          "\"BYU\"" :> Documentation`HelpLookup["paclet:ref/format/BYU"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"LWO\"" :> Documentation`HelpLookup["paclet:ref/format/LWO"], 
          "\"Maya\"" :> Documentation`HelpLookup["paclet:ref/format/Maya"], 
          "\"NOFF\"" :> Documentation`HelpLookup["paclet:ref/format/NOFF"], 
          "\"OBJ\"" :> Documentation`HelpLookup["paclet:ref/format/OBJ"], 
          "\"PLY\"" :> Documentation`HelpLookup["paclet:ref/format/PLY"], 
          "\"POV\"" :> Documentation`HelpLookup["paclet:ref/format/POV"], 
          "\"RIB\"" :> Documentation`HelpLookup["paclet:ref/format/RIB"], 
          "\"STL\"" :> Documentation`HelpLookup["paclet:ref/format/STL"], 
          "\"VRML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/VRML"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"3DS\\\"\"\>", 
       2->"\<\"\\\"BYU\\\"\"\>", 3->"\<\"\\\"JVX\\\"\"\>", 
       4->"\<\"\\\"LWO\\\"\"\>", 5->"\<\"\\\"Maya\\\"\"\>", 
       6->"\<\"\\\"NOFF\\\"\"\>", 7->"\<\"\\\"OBJ\\\"\"\>", 
       8->"\<\"\\\"PLY\\\"\"\>", 9->"\<\"\\\"POV\\\"\"\>", 
       10->"\<\"\\\"RIB\\\"\"\>", 11->"\<\"\\\"STL\\\"\"\>", 
       12->"\<\"\\\"VRML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Geometry & Modeling Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/3DGeometryAndModelingFormats"], 
          "Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Graphics Importing & Exporting" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsImportingAndExporting"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Geometry & Modeling Formats\"\>", 
       2->"\<\"Computational Geometry\"\>", 
       3->"\<\"Graphics Importing & Exporting\"\>", 
       4->"\<\"Importing & Exporting\"\>", 
       5->"\<\"Listing of All Formats\"\>", 
       6->"\<\"New in 6.0: Data Handling & Data Sources\"\>", 
       7->"\<\"New in 6.0: Import & Export Formats\"\>", 
       8->"\<\"Web Formats\"\>", 9->"\<\"XML Formats\"\>", 
       10->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "X3D ",
 StyleBox["(.x3d)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->30422],

Cell[TextData[{
 "MIME type: ",
 StyleBox["model/x3d+xml", "InlineCode"],
 "\nWeb3D geometry format.\nUsed for distributing 3D models on the web and in \
media applications.\nXML format.\nCan store multiple geometries.\nIntroduced \
in 2003, maintained by the Web3D Consortium.\nSuccessor of the VRML format."
}], "FormatUsage",
 CellID->27666],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " supports the X3D format Version 3.0."
}], "FormatNotes",
 CellID->8486]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXPORT", "ImportExportSection",
 CellID->3455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).x3d\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports a ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " object to an X3D file."
}], "FormatNotes",
 CellID->29614],

Cell["", "WeakDivider",
 CellID->29082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).x3d\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "X3D",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->12455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).x3d\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["elem", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->14197],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).x3d\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->22106],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).x3d\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->8752],

Cell["", "WeakDivider",
 CellID->15821],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->17296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " supports the X3D format."
}], "FormatNotes",
 CellID->26281]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->26021],

Cell["Data representation elements:", "FormatNotes",
 CellID->18318],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Graphics3D\>\"", Cell[TextData[{
     "X3D",
     " file containing 3D geometries, represented as a ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " object"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GraphicsComplex\>\"", Cell[
    TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " objects, each representing a geometry stored in the file"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineData\>\"", Cell[TextData[{
     "lines represented as lists of indices, referencing the vertices as \
given by the ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"],
     " element"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LineObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Line",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Line"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointData\>\"", Cell[
    "point data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PointObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Point",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Point"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonData\>\"", Cell[
    "polygon data in indexed form", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PolygonObjects\>\"", Cell[TextData[{
     "list of ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " primitives given in absolute coordinates"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexData\>\"", Cell[
    "list of vertex coordinates", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VertexNormals\>\"", Cell[TextData[{
     "normal vectors corresponding to the vertices given by ",
     Cell[BoxData["\"\<VertexData\>\""], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->9135]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell["Advanced options:", "FormatNotes",
 CellID->2132824898],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<InvertNormals\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to invert the orientation of vertex normals", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<VerticalAxis\>\"", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], Cell["\<\
orientation to assume for the coordinate system used in the file\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->28047],

Cell[TextData[{
 "By default, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assumes that in the coordinate system used by the X3D format the vertical \
axis corresponds to the third coordinate."
}], "FormatNotes",
 CellID->1642809193],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"\"\<VerticalAxis\>\"", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will apply the transformation ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     RowBox[{"-", 
      StyleBox["y", "TI"]}]}], "}"}], " "}]], "InlineFormula"],
 "to all graphics coordinates when exporting to X3D."
}], "FormatNotes",
 CellID->182941150]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->4747],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<3DS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/3DS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<BYU\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BYU"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<LWO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/LWO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Maya\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Maya"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NOFF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NOFF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<OBJ\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/OBJ"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PLY\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PLY"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<POV\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/POV"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<RIB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/RIB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<STL\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/STL"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<VRML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/VRML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1314740650]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->248182674],

Cell[TextData[ButtonBox["3D Geometry & Modeling Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGeometryAndModelingFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout"],

Cell[TextData[ButtonBox["Graphics Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->577226905],

Cell["Use ParametricPlot3D to create a solid 3D geometry:", "ExampleText",
 CellID->1040958143],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", 
        RowBox[{"Cos", "[", "v", "]"}]}], ")"}], 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", 
     RowBox[{"Sin", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"Axes", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Boxed", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"Mesh", " ", "\[Rule]", " ", "False"}], ",", " ", 
   RowBox[{"ColorFunction", "\[Rule]", "\"\<CandyColors\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1981720939],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1Wwl0VdUVTUIA7bJgVXBAUQaRocwqg799XwVEIQXCULRItVVwAJVQQxCV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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[Polygon3DBox[CompressedData["
1:eJxNmwfcl2MXx+/7jsjIFjIayCbKHil7hAoZaVhJZsPWIGTzGklSiZLKyAwt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        "]]]}, {}, {}, {}}, {}},
   VertexColors->CompressedData["
1:eJztnGtIU2EYx49mF7zNBrXZxSG08kNqqQSW8ECBNXFOTBQaBBnaTMkQU+kq
fai+1VIzo3DdzMIPmX6qWF6iD0tNMs3rYOnZ1jlLMghl2Q06fhm8dM48g3Pq
gX368eO/8XLe53l5D89iC8pyCoMpilq5jKJ+f6hLUfn99kYG1KcSrSaFAxSz
CuPJFBqQi8tD8o5vTLY7Ifexus50zQmrdZl5lUMMcpF5rVZ5IPwMDTUt25PG
ehgoUlZn/PzuQS4yz3bPVmm0NJww7JrLfMXC/JV3dzOykSOXJ5fa/vpXuW/d
VhLqOfKl8YvcOSSaO4dEcecQ5OLyzWzzhL7YDR2dBysLtw7C0SQDW7d2ArnI
PMybEJdvd8CK7nCN5+FrsFTsD7p9Zxi5yLzcMHVWoRiH9m5zcnmuDYpv9Rkr
IpAjlycP9XnOm7jnHLm4XMvV7Sdc3TZxdRu5uHzxfknFnUMife6dkIvD9S+3
lLBWN/TuLdR/00xDU+zndSU1biK3XPgar2FoGEhcGGr/4oaCqGNtKVkeok+6
JxSajzmYgzmByyFx1aztWW86DVpd2GXDYRZKVebRt1fJvlg56KPPx+/6wU50
RNOwI6a0bdzFgkq57enzVOE+cv/WTSwfuX/rFui6/b9xsdYtk+u/fVz/tfjZ
f4XmoI8+H5/EI21BesbMAGVptek0Y2CqN885dY6A56CPPh+fxF98ynIs30RD
//R5xhj8BkKrRlzespGA56CPPh+fxDvV19XeQ3YYmDnSmvbeBpH9PakN6cMB
z0EffT5+zmBCc+PMKHiSFh6sj7PBZEPy+BrvkGAfuX/rZvXxI/z0kfu5btx+
6eX2yypuvwj2kYu6bov9d6HpT/8t4vpvoHPQR5+PT+Kk97CBzkEffT6+0PeJ
pPkU9NFfio9zTzjfhBy51PaL3LnU5nfkzqU2pyN3LrV5HLlzqc3dyJ1Lbe4D
OXKcA8J5H7nwrq5zZdOPPoJ1/l51/I0P0JKSsydm0knkrB422OsZuGk8va9W
bQfX7p33Q9KmiJyU87f/sfG9ByPlk3KE/n7S9/4Ciz1NTQ==
    "],
   VertexNormals->CompressedData["
1:eJx1nHuMltURxldb06ZRCss11aTV2vhHWy+gUuSjLyBUxUUbtbVeqoiK7kpd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    "]],
  Boxed->False,
  Lighting->"Neutral",
  PlotRange->{{-3., 3.}, {-3., 3.}, {-1., 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1467853409]
}, Open  ]],

Cell["Export it to X3D:", "ExampleText",
 CellID->231524072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<torus.x3d\>\"", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70992528],

Cell[BoxData["\<\"torus.x3d\"\>"], "Output",
 CellLabel->"Out[2]=",
 CellID->1317994011]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"X3D - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 38.2489274}", "context" -> "", 
    "keywords" -> {
     "3D", "geometry", "modeling", "rendering", "visualization", "XML", "WWW",
       "W3C"}, "index" -> True, "label" -> "Mathematica Import/Export Format",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "MIME type: model/x3d+xml Web3D geometry format. Used for distributing 3D \
models on the web and in media applications. XML format. Can store multiple \
geometries. Introduced in 2003, maintained by the Web3D Consortium. Successor \
of the VRML format.", "synonyms" -> {}, "title" -> "X3D", "type" -> "Format", 
    "uri" -> "ref/format/X3D"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18018, 575, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44751, 1072}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3843, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4466, 103, 102, 4, 70, "ObjectNameAlt",
 CellID->30422],
Cell[4571, 109, 344, 7, 70, "FormatUsage",
 CellID->27666],
Cell[4918, 118, 205, 7, 70, "FormatNotes",
 CellID->8486]
}, Open  ]],
Cell[CellGroupData[{
Cell[5160, 130, 52, 1, 70, "ImportExportSection",
 CellID->3455],
Cell[5215, 133, 456, 16, 70, "FormatNotes",
 CellID->29614],
Cell[5674, 151, 39, 1, 70, "WeakDivider",
 CellID->29082],
Cell[5716, 154, 525, 20, 70, "FormatNotes",
 CellID->12455],
Cell[6244, 176, 1039, 38, 70, "FormatNotes",
 CellID->14197],
Cell[7286, 216, 621, 21, 70, "FormatNotes",
 CellID->22106],
Cell[7910, 239, 815, 28, 70, "FormatNotes",
 CellID->8752],
Cell[8728, 269, 39, 1, 70, "WeakDivider",
 CellID->15821],
Cell[8770, 272, 236, 9, 70, "FormatNotes",
 CellID->17296],
Cell[9009, 283, 206, 7, 70, "FormatNotes",
 CellID->26281]
}, Closed]],
Cell[CellGroupData[{
Cell[9252, 295, 51, 1, 70, "ElementsSection",
 CellID->26021],
Cell[9306, 298, 68, 1, 70, "FormatNotes",
 CellID->18318],
Cell[9377, 301, 2733, 68, 70, "2ColumnTableMod",
 CellID->9135]
}, Open  ]],
Cell[CellGroupData[{
Cell[12147, 374, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[12199, 377, 61, 1, 70, "FormatNotes",
 CellID->2132824898],
Cell[12263, 380, 707, 17, 70, "3ColumnTableMod",
 CellID->28047],
Cell[12973, 399, 243, 7, 70, "FormatNotes",
 CellID->1642809193],
Cell[13219, 408, 701, 25, 70, "FormatNotes",
 CellID->182941150]
}, Closed]],
Cell[CellGroupData[{
Cell[13957, 438, 49, 1, 70, "SeeAlsoSection",
 CellID->4747],
Cell[14009, 441, 2468, 83, 70, "SeeAlso",
 CellID->1314740650]
}, Open  ]],
Cell[CellGroupData[{
Cell[16514, 529, 58, 1, 70, "MoreAboutSection",
 CellID->248182674],
Cell[16575, 532, 150, 2, 70, "MoreAbout"],
Cell[16728, 536, 135, 2, 70, "MoreAbout"],
Cell[16866, 540, 151, 2, 70, "MoreAbout"],
Cell[17020, 544, 134, 2, 70, "MoreAbout"],
Cell[17157, 548, 133, 2, 70, "MoreAbout"],
Cell[17293, 552, 165, 2, 70, "MoreAbout"],
Cell[17461, 556, 156, 2, 70, "MoreAbout"],
Cell[17620, 560, 113, 2, 70, "MoreAbout"],
Cell[17736, 564, 113, 2, 70, "MoreAbout"],
Cell[17852, 568, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18018, 575, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18134, 581, 60, 1, 70, "ExampleSection",
 CellID->577226905],
Cell[18197, 584, 95, 1, 70, "ExampleText",
 CellID->1040958143],
Cell[CellGroupData[{
Cell[18317, 589, 952, 28, 70, "Input",
 CellID->1981720939],
Cell[19272, 619, 23853, 402, 70, "Output",
 CellID->1467853409]
}, Open  ]],
Cell[43140, 1024, 60, 1, 70, "ExampleText",
 CellID->231524072],
Cell[CellGroupData[{
Cell[43225, 1029, 140, 4, 70, "Input",
 CellID->70992528],
Cell[43368, 1035, 88, 2, 70, "Output",
 CellID->1317994011]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[43495, 1042, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

