(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27679,        945]
NotebookOptionsPosition[     22430,        772]
NotebookOutlinePosition[     23826,        811]
CellTagsIndexPosition[     23741,        806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ImportingGraphicsAndSounds"], 
          "Exporting Graphics and Sounds" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExportingGraphicsAndSounds"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Importing Graphics and Sounds\"\>", 
       2->"\<\"Exporting Graphics and Sounds\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"CUR\"" :> Documentation`HelpLookup["paclet:ref/format/CUR"], 
          "\"ICO\"" :> Documentation`HelpLookup["paclet:ref/format/ICO"], 
          "\"PICT\"" :> 
          Documentation`HelpLookup["paclet:ref/format/PICT"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"CUR\\\"\"\>", 
       2->"\<\"\\\"ICO\\\"\"\>", 
       3->"\<\"\\\"PICT\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Raster Image Formats" :> 
          Documentation`HelpLookup["paclet:guide/RasterImageFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Listing of All Formats\"\>", 
       2->"\<\"New in 6.0: Import & Export Formats\"\>", 
       3->"\<\"Raster Image Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XBM",
 " (",
 Cell[".xbm", "FilenameExtension"],
 Cell["", "FilenameExtension"],
 ")"
}], "ObjectNameAlt",
 CellID->7514],

Cell[TextData[{
 "MIME type: ",
 StyleBox["image/x-xbitmap", "InlineCode"],
 " \nX Window bitmap format.\nUsed in the X11 windowing system for storing \
icons, cursors, and other graphics resources.\nASCII format.\nStores a \
monochrome bitmap as C language source code.\nXBM is an acronym derived from \
X Bitmap.\nDeveloped in the 1980s at MIT."
}], "FormatUsage",
 CellID->10168],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the XBM format."
}], "FormatNotes",
 CellID->5055]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->5973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", "]"}]], "InlineFormula"],
 " imports an ",
 "XBM",
 " file, returning a graphics object."
}], "FormatNotes",
 CellID->8922],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports graphics or any other expression as an image to XBM."
}], "FormatNotes",
 CellID->6748],

Cell["", "WeakDivider",
 CellID->5651],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Raster",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Raster"], "[", 
     StyleBox["data", "TI"], "]"}], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " is an array of bit values."
}], "FormatNotes",
 CellID->10986],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
     StyleBox["expr", "TI"]}], "]"}], " "}]], "InlineFormula"],
 "creates an ",
 "XBM",
 " image with the same image size as the displayed form of ",
 Cell[BoxData[
  FormBox[
   StyleBox["expr", "TI"], TraditionalForm]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->2144],

Cell["\<\
Because XBM is a raster image format, all fonts are rasterized on export.\
\>", "FormatNotes",
 CellID->16446],

Cell["", "WeakDivider",
 CellID->31577],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "XBM",
 " file."
}], "FormatNotes",
 CellID->26517],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->14629],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->29916],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", "\"\<XBM\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XBM\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5874],

Cell["", "WeakDivider",
 CellID->15791],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 "XBM",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->15469],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], 
      StyleBox["}", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->22912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->8146],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xbm\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->30693],

Cell["", "WeakDivider",
 CellID->9091],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->9815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "XBM",
 " format."
}], "FormatNotes",
 CellID->26949]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->236],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->8551],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", " ", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties, and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->9487],

Cell["", "WeakDivider",
 CellID->31226],

Cell["Data representation elements:", "FormatNotes",
 CellID->28162],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "array of color values", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Graphics\>\"", Cell["", "TableText"]}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " object representing an image"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<GrayLevels\>\"", Cell[
    "array of normalized gray-level values", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->16955],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<RGBColorArray\>\"", Cell[TextData[{
     "array of ",
     Cell[BoxData[
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " by default use the ",
 Cell[BoxData["\"\<Graphics\>\""], "InlineFormula"],
 " element for ",
 "XBM",
 " files."
}], "FormatNotes",
 CellID->8394],

Cell[TextData[{
 "Advanced ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->450361849],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<BitDepth\>\"", Cell[
    "bits used to represent each color channel in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorSpace\>\"", Cell[
    "color encoding used in the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ImageSize\>\"", Cell[
    "raster dimensions", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->1499224115]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->30180],

Cell["General option:", "FormatNotes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall image size", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->3065]
}, Closed]],

Cell[CellGroupData[{

Cell["TUTORIALS", "TutorialsSection",
 CellID->24750],

Cell[TextData[ButtonBox["Importing Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ImportingGraphicsAndSounds"]], "Tutorials",
 CellID->9009],

Cell[TextData[ButtonBox["Exporting Graphics and Sounds",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExportingGraphicsAndSounds"]], "Tutorials",
 CellID->503348882]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->22214],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<CUR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/CUR"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ICO\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ICO"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<PICT\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/PICT"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1890622554]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->327643250],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Raster Image Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RasterImageFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->330882469],

Cell["This imports a XBM example file:", "ExampleText",
 CellID->1579580491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/rule30.xbm\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27432],

Cell[BoxData[
 GraphicsBox[
  RasterBox[{{0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 
   1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 
   1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 0, 
   0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 
   1, 1, 0, 1, 1}, {1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 
   0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1}, {1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 
   1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1}, {1, 
   1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 
   0, 0, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 
   0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 
   0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 
   1}, {1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 
   1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 
   0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 
   1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 
   1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 
   0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   0, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 
   1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 
   1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
   1, 1, 1, 1, 1, 1, 1}}, {{0, 0}, {33, 17}}, {0, 1},
   ColorFunction->GrayLevel],
  ImageSize->{33, 17},
  PlotRange->{{0, 33}, {0, 17}}]], "Output",
 CellLabel->"Out[1]=",
 CellID->1390936859]
}, Open  ]],

Cell["Import three metadata elements:", "ExampleText",
 CellID->816468023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rule30.xbm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "\"\<ImageSize\>\"", ",", " ", "\"\<BitDepth\>\"", ",", 
      "\"\<ColorSpace\>\""}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1203333358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"33", ",", "17"}], "}"}], ",", "1", ",", "GrayLevel"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1068679136]
}, Open  ]],

Cell["\<\
Importing as \"Text\" gives the entire original file as a string:\
\>", "ExampleText",
 CellID->2105041878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/rule30.xbm\>\"", ",", " ", "\"\<Text\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1884498891],

Cell[BoxData["\<\"#define math_width 33\\n#define math_height 17\\nstatic \
char math_bits[] = {\\n 0x00 0x00 0x01 0x00 0x00 0x00 0x80 0x03 0x00 0x00 \
0x00 0xc0\\n 0x04 0x00 0x00 0x00 0x60 0x0f 0x00 0x00 0x00 0x30 0x11 0x00\\n \
0x00 0x00 0xd8 0x3b 0x00 0x00 0x00 0x4c 0x48 0x00 0x00 0x00\\n 0xf6 0xfc 0x00 \
0x00 0x00 0x13 0x07 0x01 0x00 0x80 0xbd 0x89\\n 0x03 0x00 0xc0 0x84 0xde 0x04 \
0x00 0x60 0xcf 0x42 0x0f 0x00\\n 0x30 0x71 0x66 0x11 0x00 0xd8 0x9b 0x3b 0x3b \
0x00 0x4c 0xe8\\n 0xc8 0x49 0x00 0xf6 0x2c 0x7d 0xfe 0x00 0x13 0xe7 0x85 0x03\
\\n 0x01\\n};\\n\"\>"], "Output",
 CellLabel->"Out[3]=",
 CellID->1684035081]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XBM - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 38.8583180}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Mathematica Import/Export Format", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: image/x-xbitmap X Window bitmap format. Used in the X11 \
windowing system for storing icons, cursors, and other graphics resources. \
ASCII format. Stores a monochrome bitmap as C language source code. XBM is an \
acronym derived from X Bitmap. Developed in the 1980s at MIT.", 
    "synonyms" -> {}, "title" -> "XBM", "type" -> "Format", "uri" -> 
    "ref/format/XBM"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18362, 664, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23607, 799}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2537, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3160, 87, 139, 7, 70, "ObjectNameAlt",
 CellID->7514],
Cell[3302, 96, 382, 8, 70, "FormatUsage",
 CellID->10168],
Cell[3687, 106, 323, 12, 70, "FormatNotes",
 CellID->5055]
}, Open  ]],
Cell[CellGroupData[{
Cell[4047, 123, 63, 1, 70, "ImportExportSection",
 CellID->5973],
Cell[4113, 126, 305, 11, 70, "FormatNotes",
 CellID->8922],
Cell[4421, 139, 354, 11, 70, "FormatNotes",
 CellID->6748],
Cell[4778, 152, 38, 1, 70, "WeakDivider",
 CellID->5651],
Cell[4819, 155, 746, 26, 70, "FormatNotes",
 CellID->10986],
Cell[5568, 183, 494, 18, 70, "FormatNotes",
 CellID->2144],
Cell[6065, 203, 120, 3, 70, "FormatNotes",
 CellID->16446],
Cell[6188, 208, 39, 1, 70, "WeakDivider",
 CellID->31577],
Cell[6230, 211, 352, 13, 70, "FormatNotes",
 CellID->26517],
Cell[6585, 226, 574, 20, 70, "FormatNotes",
 CellID->14629],
Cell[7162, 248, 582, 21, 70, "FormatNotes",
 CellID->29916],
Cell[7747, 271, 697, 25, 70, "FormatNotes",
 CellID->5874],
Cell[8447, 298, 39, 1, 70, "WeakDivider",
 CellID->15791],
Cell[8489, 301, 524, 20, 70, "FormatNotes",
 CellID->15469],
Cell[9016, 323, 1096, 40, 70, "FormatNotes",
 CellID->22912],
Cell[10115, 365, 661, 22, 70, "FormatNotes",
 CellID->8146],
Cell[10779, 389, 816, 28, 70, "FormatNotes",
 CellID->30693],
Cell[11598, 419, 38, 1, 70, "WeakDivider",
 CellID->9091],
Cell[11639, 422, 360, 14, 70, "FormatNotes",
 CellID->9815],
Cell[12002, 438, 352, 14, 70, "FormatNotes",
 CellID->26949]
}, Closed]],
Cell[CellGroupData[{
Cell[12391, 457, 49, 1, 70, "ElementsSection",
 CellID->236],
Cell[12443, 460, 191, 8, 70, "FormatNotes",
 CellID->8551],
Cell[12637, 470, 711, 14, 70, "2ColumnTableMod",
 CellID->9487],
Cell[13351, 486, 39, 1, 70, "WeakDivider",
 CellID->31226],
Cell[13393, 489, 68, 1, 70, "FormatNotes",
 CellID->28162],
Cell[13464, 492, 801, 19, 70, "2ColumnTableMod",
 CellID->16955],
Cell[14268, 513, 515, 15, 70, "2ColumnTableMod",
 CellID->23183],
Cell[14786, 530, 404, 16, 70, "FormatNotes",
 CellID->8394],
Cell[15193, 548, 197, 8, 70, "FormatNotes",
 CellID->450361849],
Cell[15393, 558, 634, 13, 70, "2ColumnTableMod",
 CellID->1499224115]
}, Open  ]],
Cell[CellGroupData[{
Cell[16064, 576, 49, 1, 70, "OptionsSection",
 CellID->30180],
Cell[16116, 579, 54, 1, 70, "FormatNotes",
 CellID->16097],
Cell[16173, 582, 516, 15, 70, "3ColumnTableMod",
 CellID->3065]
}, Closed]],
Cell[CellGroupData[{
Cell[16726, 602, 53, 1, 70, "TutorialsSection",
 CellID->24750],
Cell[16782, 605, 165, 3, 70, "Tutorials",
 CellID->9009],
Cell[16950, 610, 170, 3, 70, "Tutorials",
 CellID->503348882]
}, Closed]],
Cell[CellGroupData[{
Cell[17157, 618, 50, 1, 70, "SeeAlsoSection",
 CellID->22214],
Cell[17210, 621, 592, 20, 70, "SeeAlso",
 CellID->1890622554]
}, Open  ]],
Cell[CellGroupData[{
Cell[17839, 646, 58, 1, 70, "MoreAboutSection",
 CellID->327643250],
Cell[17900, 649, 133, 2, 70, "MoreAbout"],
Cell[18036, 653, 156, 2, 70, "MoreAbout"],
Cell[18195, 657, 130, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18362, 664, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[18478, 670, 60, 1, 70, "ExampleSection",
 CellID->330882469],
Cell[18541, 673, 76, 1, 70, "ExampleText",
 CellID->1579580491],
Cell[CellGroupData[{
Cell[18642, 678, 127, 3, 70, "Input",
 CellID->27432],
Cell[18772, 683, 2020, 30, 70, "Output",
 CellID->1390936859]
}, Open  ]],
Cell[20807, 716, 74, 1, 70, "ExampleText",
 CellID->816468023],
Cell[CellGroupData[{
Cell[20906, 721, 306, 9, 70, "Input",
 CellID->1203333358],
Cell[21215, 732, 189, 7, 70, "Output",
 CellID->1068679136]
}, Open  ]],
Cell[21419, 742, 117, 3, 70, "ExampleText",
 CellID->2105041878],
Cell[CellGroupData[{
Cell[21561, 749, 174, 5, 70, "Input",
 CellID->1884498891],
Cell[21738, 756, 626, 9, 70, "Output",
 CellID->1684035081]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[22403, 770, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

