(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41894,       1327]
NotebookOptionsPosition[     35474,       1130]
NotebookOutlinePosition[     37348,       1175]
CellTagsIndexPosition[     37262,       1170]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"ExpressionML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ExpressionML"], 
          "\"JVX\"" :> Documentation`HelpLookup["paclet:ref/format/JVX"], 
          "\"MathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/MathML"], "\"NB\"" :> 
          Documentation`HelpLookup["paclet:ref/format/NB"], "\"ODS\"" :> 
          Documentation`HelpLookup["paclet:ref/format/ODS"], "\"SXC\"" :> 
          Documentation`HelpLookup["paclet:ref/format/SXC"], "\"XHTML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTML"], 
          "\"XHTMLMathML\"" :> 
          Documentation`HelpLookup["paclet:ref/format/XHTMLMathML"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"\\\"ExpressionML\\\"\"\>", 
       2->"\<\"\\\"JVX\\\"\"\>", 3->"\<\"\\\"MathML\\\"\"\>", 
       4->"\<\"\\\"NB\\\"\"\>", 5->"\<\"\\\"ODS\\\"\"\>", 
       6->"\<\"\\\"SXC\\\"\"\>", 7->"\<\"\\\"XHTML\\\"\"\>", 
       8->"\<\"\\\"XHTMLMathML\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Importing & Exporting in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ImportingAndExportingInNotebooks"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup["paclet:guide/SystemsAndUtilityFormats"], 
          "Web Formats" :> 
          Documentation`HelpLookup["paclet:guide/WebFormats"], 
          "Web Operations" :> 
          Documentation`HelpLookup["paclet:guide/WebOperations"], 
          "XML Formats" :> 
          Documentation`HelpLookup["paclet:guide/XMLFormats"], 
          "XML Import & Export" :> 
          Documentation`HelpLookup["paclet:guide/XMLImportAndExport"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Importing & Exporting in Notebooks\"\>", 
       3->"\<\"Listing of All Formats\"\>", 4->"\<\"String Manipulation\"\>", 
       5->"\<\"Systems & Utility Formats\"\>", 6->"\<\"Web Formats\"\>", 
       7->"\<\"Web Operations\"\>", 8->"\<\"XML Formats\"\>", 
       9->"\<\"XML Import & Export\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XML ",
 StyleBox["(.xml)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["text/xml", "InlineCode"],
 "\nXML general-purpose markup language and structured document format.\n\
Primarily used for the exchange of data across different systems in computer \
networks.\nUses a hierarchical model for the representation of structured \
data.\nStores data in a tree-based structure consisting of markup tags, \
attributes, and character contents.\nPlain text file, normally encoded as \
UTF-8. \nXML is an acronym derived from Extensible Markup Language.\nIs a \
subset of the Standard Generalized Markup Language (SGML).\nDeveloped since \
1996 by the XML Working Group.\nPublished in 2001 as W3C standard \
recommendation RFC 3076."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the XML standard Version 1.0."
}], "FormatNotes",
 CellID->344331575],

Cell[TextData[{
 "Special converters are used for the following XML-based formats: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["\"\<ExpressionML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/ExpressionML"], ",", " ", 
   ButtonBox["\"\<JVX\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/JVX"], ",", " ", 
   ButtonBox["\"\<MathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/MathML"], ",", " ", 
   ButtonBox["\"\<ODS\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/ODS"], ",", " ", 
   ButtonBox["\"\<SXC\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/SXC"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["\"\<XHTML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/XHTML"], ",", " ", 
   ButtonBox["\"\<XHTMLMathML\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/format/XHTMLMathML"]}]], "InlineFormula"]
}], "FormatNotes",
 CellID->397331581]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", "]"}]], "InlineFormula"],
 " imports an XML file and returns an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " expression."
}], "FormatNotes",
 CellID->28652],

Cell[TextData[{
 "Since both XML and ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " represent data as a tree structure, there is a natural mapping from one to \
the other. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stores XML data structures as nested ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " objects, and an entire XML document as XML data embedded in an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->782465067],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " exports an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " expression to XML."
}], "FormatNotes",
 CellID->8194],

Cell[TextData[{
 "Expressions of types other than ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " are exported as ExpressionML. "
}], "FormatNotes",
 CellID->13152],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an ",
 Cell[BoxData[
  ButtonBox["XMLObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLObject"]], "InlineFormula"],
 " expression, representing the entire XML document in symbolic form as a \
tree of ",
 Cell[BoxData[
  ButtonBox["XMLElement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
 " expressions."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default returns numeric data stored in XML as strings."
}], "FormatNotes",
 CellID->1425223344],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
     RowBox[{
      ButtonBox["XMLObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLObject"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Export",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Export"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
     RowBox[{
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"], "[", 
      StyleBox["\[Ellipsis]", "TR"], "]"}]}], "]"}], " "}]], 
  "InlineFormula"],
 "creates a generic XML file from a symbolic XML representation."
}], "FormatNotes",
 CellID->7572],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "XML",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<XML\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XML\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->1941],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"], ",", " ", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates an ",
 "XML",
 " file by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->20289],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->8419],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->5565],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).xml\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->3805],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support the ",
 "XML",
 " format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<Elements\>\"", Cell["", "TableText"]}], Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<CDATA\>\"", Cell[
    "CDATA sections as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Comments\>\"", Cell[
    "XML comments as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EmbeddedDTD\>\"", Cell[
    "DTD included in the XML document", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Plaintext\>\"", Cell[
    "a plain text representation of the file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Tags\>\"", Cell[
    "list of all tags occurring in the file", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<XMLObject\>\"", Cell[
    "entire document as a symbolic XML expression", "TableText"]},
   {Cell[" ", "TableRowIcon"], "\"\<XMLElement\>\"", Cell[TextData[{
     "nested ",
     Cell[BoxData[
      ButtonBox["XMLElement",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/XMLElement"]], "InlineFormula"],
     " objects"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<XMLObject\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->853175818],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->751548701],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AllowRemoteDTDAccess\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to attempt to retrieve an external DTD over a network\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AllowUnrecognizedEntities\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to allow parsing to work around unrecognized entities in the XML \
document\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeDefaultedAttributes\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to fill in default values for attributes", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeEmbeddedObjects\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[TextData[{
     "embedded objects (of ",
     Cell[BoxData["\"\<Comments\>\""], "InlineFormula"],
     " and ",
     Cell[BoxData["\"\<ProcessingInstructions\>\""], "InlineFormula"],
     ") to include"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<IncludeNamepaces\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to return fully qualified tag and attribute names", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NormalizeWhiteSpace\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
whether to remove leading and trailing whitespace and to reduce consecutive \
spaces to a single space in character data\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PreserveCDATASections\>\"", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to preserve character data sections as special objects\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ReadDTD\>\"", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to read an external DTD", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ValidateAgainstDTD\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to validate the document against the specified DTD", 
     "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1927689700],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " options:"
}], "FormatNotes",
 CellID->1643820035],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AttributeQuoting\>\"", "\"\<'\>\"", 
    Cell["specifies the delimiter for attribute values", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ElementFormatting\>\"", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
indentation of elements and line breaking of long strings in the exported \
document\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Entities\>\"", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "rules for replacing characters with named entities", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<NamespacePrefixes\>\"", 
    RowBox[{"{", "}"}], Cell[TextData[{
     "namespace prefix designations, of the form ",
     Cell[BoxData[
      RowBox[{"\"\<\!\(\*
StyleBox[\"namespace\", \"TI\"]\)\>\"", "->", "\"\<\!\(\*
StyleBox[\"prefix\", \"TI\"]\)\>\""}]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->8326]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<ExpressionML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ExpressionML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<JVX\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/JVX"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MathML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<NB\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/NB"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<ODS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ODS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<SXC\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/SXC"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTML"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XHTMLMathML\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XHTMLMathML"]], "InlineFormula"]
}], "SeeAlso",
 CellID->948563271]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->114190233],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExportingInNotebooks"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Web Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WebOperations"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["XML Import & Export",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/XMLImportAndExport"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->403981096],

Cell["Import an XML sample file as symbolic XML:", "ExampleText",
 CellID->308183666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<ExampleData/paintings.xml\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{
  RowBox[{"XMLObject", "[", "\<\"Document\"\>", "]"}], "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"XMLObject", "[", "\<\"Declaration\"\>", "]"}], "[", 
     RowBox[{
      RowBox[{"\<\"Version\"\>", "\[Rule]", "\<\"1.0\"\>"}], ",", 
      RowBox[{"\<\"Encoding\"\>", "\[Rule]", "\<\"ISO8859-1\"\>"}]}], "]"}], 
    "}"}], ",", 
   RowBox[{"XMLElement", "[", 
    RowBox[{"\<\"PAINTINGS\"\>", ",", 
     RowBox[{"{", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"No.5, 1948\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Jackson Pollock\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1948\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$140,000,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Woman III\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Willem de Kooning\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1953\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$137,500,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Portrait of Adele Block-Bauer I\"\>", "}"}]}], 
            "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Gustav Klimt\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1907\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$135,000,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Portrait of Dr. Gachet\"\>", "}"}]}], "]"}], 
           ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Vincent van Gogh\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1890\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$82,500,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"XMLElement", "[", 
        RowBox[{"\<\"SALE\"\>", ",", 
         RowBox[{"{", "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"TITLE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{
             "{", "\<\"Bal au moulin de la Galette, Montmartre\"\>", "}"}]}], 
            "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"ARTIST\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"Pierre-Auguste Renoir\"\>", "}"}]}], "]"}], 
           ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"YEAR\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"1876\"\>", "}"}]}], "]"}], ",", 
           RowBox[{"XMLElement", "[", 
            RowBox[{"\<\"PRICE\"\>", ",", 
             RowBox[{"{", "}"}], ",", 
             RowBox[{"{", "\<\"$78,100,000\"\>", "}"}]}], "]"}]}], "}"}]}], 
        "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "}"}]}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->2006184859]
}, Open  ]],

Cell[TextData[{
 "Show the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements available in this file:"
}], "ExampleText",
 CellID->2059801545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/paintings.xml\>\"", ",", "\"\<Elements\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1640055299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"CDATA\"\>", ",", "\<\"Comments\"\>", 
   ",", "\<\"EmbeddedDTD\"\>", ",", "\<\"Plaintext\"\>", ",", "\<\"Tags\"\>", 
   ",", "\<\"XMLElement\"\>", ",", "\<\"XMLObject\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1456801048]
}, Open  ]],

Cell["Import all CDATA sections:", "ExampleText",
 CellID->1604101484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/paintings.xml\>\"", ",", "\"\<CDATA\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->145067315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"No.5, 1948\"\>", ",", "\<\"Jackson Pollock\"\>", 
   ",", "\<\"1948\"\>", ",", "\<\"$140,000,000\"\>", ",", "\<\"Woman III\"\>",
    ",", "\<\"Willem de Kooning\"\>", ",", "\<\"1953\"\>", 
   ",", "\<\"$137,500,000\"\>", 
   ",", "\<\"Portrait of Adele Block-Bauer I\"\>", 
   ",", "\<\"Gustav Klimt\"\>", ",", "\<\"1907\"\>", 
   ",", "\<\"$135,000,000\"\>", ",", "\<\"Portrait of Dr. Gachet\"\>", 
   ",", "\<\"Vincent van Gogh\"\>", ",", "\<\"1890\"\>", 
   ",", "\<\"$82,500,000\"\>", 
   ",", "\<\"Bal au moulin de la Galette, Montmartre\"\>", 
   ",", "\<\"Pierre-Auguste Renoir\"\>", ",", "\<\"1876\"\>", 
   ",", "\<\"$78,100,000\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->752423860]
}, Open  ]],

Cell["Convert to plain text:", "ExampleText",
 CellID->548039493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/paintings.xml\>\"", ",", "\"\<Plaintext\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->623937150],

Cell[BoxData["\<\"No.5, 1948\\nJackson Pollock\\n1948\\n$140,000,000\\nWoman \
III\\nWillem de Kooning\\n1953\\n$137,500,000\\nPortrait of Adele Block-Bauer \
I\\nGustav Klimt\\n1907\\n$135,000,000\\nPortrait of Dr. Gachet\\nVincent van \
Gogh\\n1890\\n$82,500,000\\nBal au moulin de la Galette, \
Montmartre\\nPierre-Auguste Renoir\\n1876\\n$78,100,000\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->349031749]
}, Open  ]],

Cell["Get the list of all XML tags that occur in this sample file:", \
"ExampleText",
 CellID->1468594610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<ExampleData/paintings.xml\>\"", ",", "\"\<Tags\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->342396868],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ARTIST\"\>", ",", "\<\"PAINTINGS\"\>", ",", "\<\"PRICE\"\>", 
   ",", "\<\"SALE\"\>", ",", "\<\"TITLE\"\>", ",", "\<\"YEAR\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1555470163]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XML - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 40.2333532}", "context" -> "", 
    "keywords" -> {
     "markup language", "W3C", "DOM", "SAX", "symbolicxml", "symbolic xml", 
      "XHTML", "MathML", "XML parser", "DTD", "name space"}, "index" -> True, 
    "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: text/xml XML general-purpose markup language and structured \
document format. Primarily used for the exchange of data across different \
systems in computer networks. Uses a hierarchical model for the \
representation of structured data. Stores data in a tree-based structure \
consisting of markup tags, attributes, and character contents. Plain text \
file, normally encoded as UTF-8. XML is an acronym derived from Extensible \
Markup Language. Is a subset of the Standard Generalized Markup Language \
(SGML). Developed since 1996 by the XML Working Group. Published in 2001 as \
W3C standard recommendation RFC 3076.", "synonyms" -> {}, "title" -> "XML", 
    "type" -> "Format", "uri" -> "ref/format/XML"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26524, 870, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37128, 1163}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3180, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3803, 92, 107, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[3913, 98, 734, 13, 70, "FormatUsage",
 CellID->37585799],
Cell[4650, 113, 342, 12, 70, "FormatNotes",
 CellID->344331575],
Cell[4995, 127, 974, 29, 70, "FormatNotes",
 CellID->397331581]
}, Open  ]],
Cell[CellGroupData[{
Cell[6006, 161, 64, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[6073, 164, 420, 14, 70, "FormatNotes",
 CellID->28652],
Cell[6496, 180, 631, 20, 70, "FormatNotes",
 CellID->782465067],
Cell[7130, 202, 582, 21, 70, "FormatNotes",
 CellID->8194],
Cell[7715, 225, 375, 13, 70, "FormatNotes",
 CellID->13152],
Cell[8093, 240, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[8135, 243, 628, 21, 70, "FormatNotes",
 CellID->28396],
Cell[8766, 266, 232, 7, 70, "FormatNotes",
 CellID->1425223344],
Cell[9001, 275, 927, 32, 70, "FormatNotes",
 CellID->7572],
Cell[9931, 309, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[9973, 312, 352, 13, 70, "FormatNotes",
 CellID->29174],
Cell[10328, 327, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[10905, 349, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[11488, 372, 703, 25, 70, "FormatNotes",
 CellID->32611],
Cell[12194, 399, 38, 1, 70, "WeakDivider",
 CellID->1941],
Cell[12235, 402, 530, 20, 70, "FormatNotes",
 CellID->20289],
Cell[12768, 424, 1075, 40, 70, "FormatNotes",
 CellID->8419],
Cell[13846, 466, 661, 22, 70, "FormatNotes",
 CellID->5565],
Cell[14510, 490, 815, 28, 70, "FormatNotes",
 CellID->3805],
Cell[15328, 520, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[15369, 523, 361, 14, 70, "FormatNotes",
 CellID->16216],
Cell[15733, 539, 352, 14, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[16122, 558, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[16181, 561, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[16380, 571, 710, 14, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[17093, 587, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[17137, 590, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[17212, 593, 1317, 29, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[18532, 624, 263, 9, 70, "FormatNotes",
 CellID->1999285391]
}, Open  ]],
Cell[CellGroupData[{
Cell[18832, 638, 53, 1, 70, "OptionsSection",
 CellID->853175818],
Cell[18888, 641, 182, 7, 70, "FormatNotes",
 CellID->751548701],
Cell[19073, 650, 2767, 67, 70, "3ColumnTableMod",
 CellID->1927689700],
Cell[21843, 719, 183, 7, 70, "FormatNotes",
 CellID->1643820035],
Cell[22029, 728, 1401, 32, 70, "3ColumnTableMod",
 CellID->8326]
}, Closed]],
Cell[CellGroupData[{
Cell[23467, 765, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[23525, 768, 1671, 55, 70, "SeeAlso",
 CellID->948563271]
}, Open  ]],
Cell[CellGroupData[{
Cell[25233, 828, 58, 1, 70, "MoreAboutSection",
 CellID->114190233],
Cell[25294, 831, 134, 2, 70, "MoreAbout"],
Cell[25431, 835, 158, 2, 70, "MoreAbout"],
Cell[25592, 839, 133, 2, 70, "MoreAbout"],
Cell[25728, 843, 129, 2, 70, "MoreAbout"],
Cell[25860, 847, 141, 2, 70, "MoreAbout"],
Cell[26004, 851, 113, 2, 70, "MoreAbout"],
Cell[26120, 855, 119, 2, 70, "MoreAbout"],
Cell[26242, 859, 113, 2, 70, "MoreAbout"],
Cell[26358, 863, 129, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26524, 870, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[26640, 876, 60, 1, 70, "ExampleSection",
 CellID->403981096],
Cell[26703, 879, 85, 1, 70, "ExampleText",
 CellID->308183666],
Cell[CellGroupData[{
Cell[26813, 884, 134, 3, 70, "Input",
 CellID->976592890],
Cell[26950, 889, 5447, 133, 70, "Output",
 CellID->2006184859]
}, Open  ]],
Cell[32412, 1025, 221, 8, 70, "ExampleText",
 CellID->2059801545],
Cell[CellGroupData[{
Cell[32658, 1037, 176, 5, 70, "Input",
 CellID->1640055299],
Cell[32837, 1044, 280, 6, 70, "Output",
 CellID->1456801048]
}, Open  ]],
Cell[33132, 1053, 70, 1, 70, "ExampleText",
 CellID->1604101484],
Cell[CellGroupData[{
Cell[33227, 1058, 172, 5, 70, "Input",
 CellID->145067315],
Cell[33402, 1065, 750, 15, 70, "Output",
 CellID->752423860]
}, Open  ]],
Cell[34167, 1083, 65, 1, 70, "ExampleText",
 CellID->548039493],
Cell[CellGroupData[{
Cell[34257, 1088, 176, 5, 70, "Input",
 CellID->623937150],
Cell[34436, 1095, 413, 6, 70, "Output",
 CellID->349031749]
}, Open  ]],
Cell[34864, 1104, 106, 2, 70, "ExampleText",
 CellID->1468594610],
Cell[CellGroupData[{
Cell[34995, 1110, 171, 5, 70, "Input",
 CellID->342396868],
Cell[35169, 1117, 239, 6, 70, "Output",
 CellID->1555470163]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[35447, 1128, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

