(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41697,       1109]
NotebookOptionsPosition[     36769,        949]
NotebookOutlinePosition[     38115,        986]
CellTagsIndexPosition[     38030,        981]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"DBF\"" :> Documentation`HelpLookup["paclet:ref/format/DBF"], 
          "\"DIF\"" :> Documentation`HelpLookup["paclet:ref/format/DIF"], 
          "\"MAT\"" :> Documentation`HelpLookup["paclet:ref/format/MAT"], 
          "\"MPS\"" :> Documentation`HelpLookup["paclet:ref/format/MPS"], 
          "\"MTP\"" :> Documentation`HelpLookup["paclet:ref/format/MTP"], 
          "\"XLS\"" :> Documentation`HelpLookup["paclet:ref/format/XLS"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"\\\"DBF\\\"\"\>", 
       2->"\<\"\\\"DIF\\\"\"\>", 3->"\<\"\\\"MAT\\\"\"\>", 
       4->"\<\"\\\"MPS\\\"\"\>", 5->"\<\"\\\"MTP\\\"\"\>", 
       6->"\<\"\\\"XLS\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Numerical Data Formats" :> 
          Documentation`HelpLookup["paclet:guide/NumericalDataFormats"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Importing & Exporting\"\>", 
       2->"\<\"Listing of All Formats\"\>", 
       3->"\<\"New in 6.0: Import & Export Formats\"\>", 
       4->"\<\"Numerical Data Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "XPORT ",
 StyleBox["(.stx, .xpt)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->2066222148],

Cell[TextData[{
 "MIME type: ",
 StyleBox["application/x-sas-xport", "InlineCode"],
 "\nSAS XPORT transport format.\nLegacy data exchange format.\nStores \
numerical datasets in a portable format.\nText format.\nDeveloped in the late \
1980s by SAS Institute."
}], "FormatUsage",
 CellID->37585799],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " fully supports the XPORT format."
}], "FormatNotes",
 CellID->344331575]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT", "ImportExportSection",
 CellID->18373],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", "]"}]], "InlineFormula"],
 " imports an XPORT file, returning all datasets arranged as a table."
}], "FormatNotes",
 CellID->28652],

Cell["", "WeakDivider",
 CellID->23826],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", "]"}], " "}]], "InlineFormula"],
 "returns a table, representing each dataset as a column."
}], "FormatNotes",
 CellID->28396],

Cell[TextData[{
 "XPORT data is represented in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " by real or integer numbers, strings, Boolean values ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ",",
 " ",
 "and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications."
}], "FormatNotes",
 CellID->373727629],

Cell["", "WeakDivider",
 CellID->14640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from an ",
 "XPORT",
 " file."
}], "FormatNotes",
 CellID->29174],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->18819],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->943],

Cell[TextData[{
 "The import format can be specified with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<XPORT\>\""}], "]"}], " "}]],
   "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<XPORT\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->32611],

Cell["", "WeakDivider",
 CellID->7585],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->16216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " supports the XPORT format."
}], "FormatNotes",
 CellID->31450]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->1710265738],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->367643471],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->673364678],

Cell["", "WeakDivider",
 CellID->1323456],

Cell["Data representation elements:", "FormatNotes",
 CellID->768488522],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Data\>\"", Cell[
    "datasets arranged as a table", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LabeledData\>\"", Cell[
    "datasets given as a list of rules", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->1019936196],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<Data\>\""], "InlineFormula"],
 " element by default."
}], "FormatNotes",
 CellID->1999285391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", "]"}]], "InlineFormula"],
 "reads all datasets and returns them as a table."
}], "FormatNotes",
 CellID->676807488],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).stx\>\"", ",", " ", "\"\<LabeledData\>\""}], 
   "]"}]], "InlineFormula"],
 "imports the entire file and returns an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], " ", "->", " ", 
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["1", "TR"]]}], ",", " ", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], " ", "->", " ", 
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["2", "TR"]]}], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are the table headings."
}], "FormatNotes",
 CellID->729329788],

Cell["Meta-information elements:", "FormatNotes",
 CellID->301601943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Labels\>\"", Cell[
    "dataset names given as a list of strings", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Metadata\>\"", Cell[
    "information about each dataset, given as a list of strings", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->962449081]
}, Open  ]],

Cell[CellGroupData[{

Cell["OPTIONS", "OptionsSection",
 CellID->23811],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " option:"
}], "FormatNotes",
 CellID->31322],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<EmptyField\>\"", "\"\<\>\"", Cell[
    TextData[{
     "how empty cells are represented in ",
     StyleBox["Mathematica",
      FontSlant->"Italic"]
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->30333]
}, Closed]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->1978455776],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<DBF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/DBF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<DIF\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/DIF"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MAT\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MAT"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MPS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MPS"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<MTP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/MTP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<XLS\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/XLS"]], "InlineFormula"]
}], "SeeAlso",
 CellID->269437084]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->210521534],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Numerical Data Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalDataFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->347893154],

Cell["\<\
Import an XPT file from a website and return the labels of all datasets:\
\>", "ExampleText",
 CellID->1623164443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  "\"\<http://www.cdc.gov/nchs/about/major/nhanes/nhanes2003-2004/l13am_c.xpt\
\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1341864687],

Cell[BoxData["\<\"http://www.cdc.gov/nchs/about/major/nhanes/nhanes2003-2004/\
l13am_c.xpt\"\>"], "Output",
 CellLabel->"Out[1]=",
 CellID->1150094200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Import", "[", " ", 
   RowBox[{"f", ",", " ", "\"\<Labels\>\""}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->976592890],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SEQN\"\>", ",", "\<\"WTSAF2YR\"\>", ",", "\<\"LBXTR\"\>", 
   ",", "\<\"LBDTRSI\"\>", ",", "\<\"LBDLDL\"\>", ",", "\<\"LBDLDLSI\"\>"}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->132912753]
}, Open  ]],

Cell[TextData[{
 "Get the first few entries for the ",
 Cell[BoxData["\"\<LBDLDL\>\""], "InlineFormula"],
 " dataset:"
}], "ExampleText",
 CellID->1133101266],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", " ", 
  RowBox[{
   RowBox[{"Import", "[", " ", 
    RowBox[{"f", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<LabeledData\>\"", ",", "\"\<LBDLDL\>\""}], "}"}]}], "]"}], 
   ",", "30"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1040025660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "125", ",", "92", ",", "93", ",", "\<\"\"\>", ",", "94", ",", "160", ",", 
   "106", ",", "70", ",", "\<\"\"\>", ",", "115", ",", "49", ",", "129", ",", 
   "78", ",", "\<\"\"\>", ",", "116", ",", "63", ",", "77", ",", "72", ",", 
   "100", ",", "108", ",", "125", ",", "91", ",", "\<\"\"\>", ",", "110", ",",
    "123", ",", "\<\"\"\>", ",", "\<\"\"\>", ",", "\<\"\"\>", ",", "127", 
   ",", "\<\"\"\>"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->481646791]
}, Open  ]],

Cell[TextData[{
 "Import two datasets and visualize them as a ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1171750794],

Cell[BoxData[
 RowBox[{
  RowBox[{"d", " ", "=", " ", 
   RowBox[{"Import", "[", " ", 
    RowBox[{"f", ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<LabeledData\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<LBDTRSI\>\"", ",", "\"\<LBDLDLSI\>\""}], "}"}]}], 
      "}"}]}], "]"}]}], " ", ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->83759855],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"DeleteCases", "[", " ", 
   RowBox[{
    RowBox[{"Transpose", "[", "d", "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"___", ",", "\"\<\>\"", ",", "___"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1190551768],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJx13Xusr+lVF/B9v529z9n77DOnQ20RBBGDphIlTdOQ99UCChVUahRJQ0xF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     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 4.493}, {0., 6.025500000000001}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellLabel->"Out[5]=",
 CellID->1498425677]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"XPORT - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 40.5614866}", "context" -> "", 
    "keywords" -> {"SAS", "statistics", "data mining"}, "index" -> True, 
    "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "MIME type: application/x-sas-xport SAS XPORT transport format. Legacy \
data exchange format. Stores numerical datasets in a portable format. Text \
format. Developed in the late 1980s by SAS Institute.", "synonyms" -> {}, 
    "title" -> "XPORT", "type" -> "Format", "uri" -> "ref/format/XPORT"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14073, 498, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 37896, 974}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2201, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2824, 74, 115, 4, 70, "ObjectNameAlt",
 CellID->2066222148],
Cell[2942, 80, 298, 7, 70, "FormatUsage",
 CellID->37585799],
Cell[3243, 89, 206, 7, 70, "FormatNotes",
 CellID->344331575]
}, Open  ]],
Cell[CellGroupData[{
Cell[3486, 101, 53, 1, 70, "ImportExportSection",
 CellID->18373],
Cell[3542, 104, 313, 9, 70, "FormatNotes",
 CellID->28652],
Cell[3858, 115, 39, 1, 70, "WeakDivider",
 CellID->23826],
Cell[3900, 118, 323, 10, 70, "FormatNotes",
 CellID->28396],
Cell[4226, 130, 589, 23, 70, "FormatNotes",
 CellID->373727629],
Cell[4818, 155, 39, 1, 70, "WeakDivider",
 CellID->14640],
Cell[4860, 158, 354, 13, 70, "FormatNotes",
 CellID->29174],
Cell[5217, 173, 574, 20, 70, "FormatNotes",
 CellID->18819],
Cell[5794, 195, 580, 21, 70, "FormatNotes",
 CellID->943],
Cell[6377, 218, 707, 25, 70, "FormatNotes",
 CellID->32611],
Cell[7087, 245, 38, 1, 70, "WeakDivider",
 CellID->7585],
Cell[7128, 248, 236, 9, 70, "FormatNotes",
 CellID->16216],
Cell[7367, 259, 208, 7, 70, "FormatNotes",
 CellID->31450]
}, Closed]],
Cell[CellGroupData[{
Cell[7612, 271, 56, 1, 70, "ElementsSection",
 CellID->1710265738],
Cell[7671, 274, 196, 8, 70, "FormatNotes",
 CellID->367643471],
Cell[7870, 284, 672, 13, 70, "2ColumnTableMod",
 CellID->673364678],
Cell[8545, 299, 41, 1, 70, "WeakDivider",
 CellID->1323456],
Cell[8589, 302, 72, 1, 70, "FormatNotes",
 CellID->768488522],
Cell[8664, 305, 493, 11, 70, "2ColumnTableMod",
 CellID->1019936196],
Cell[9160, 318, 258, 9, 70, "FormatNotes",
 CellID->1999285391],
Cell[9421, 329, 297, 9, 70, "FormatNotes",
 CellID->676807488],
Cell[9721, 340, 1005, 35, 70, "FormatNotes",
 CellID->729329788],
Cell[10729, 377, 69, 1, 70, "FormatNotes",
 CellID->301601943],
Cell[10801, 380, 534, 12, 70, "2ColumnTableMod",
 CellID->962449081]
}, Open  ]],
Cell[CellGroupData[{
Cell[11372, 397, 49, 1, 70, "OptionsSection",
 CellID->23811],
Cell[11424, 400, 177, 7, 70, "FormatNotes",
 CellID->31322],
Cell[11604, 409, 460, 13, 70, "3ColumnTableMod",
 CellID->30333]
}, Closed]],
Cell[CellGroupData[{
Cell[12101, 427, 55, 1, 70, "SeeAlsoSection",
 CellID->1978455776],
Cell[12159, 430, 1213, 41, 70, "SeeAlso",
 CellID->269437084]
}, Open  ]],
Cell[CellGroupData[{
Cell[13409, 476, 58, 1, 70, "MoreAboutSection",
 CellID->210521534],
Cell[13470, 479, 134, 2, 70, "MoreAbout"],
Cell[13607, 483, 133, 2, 70, "MoreAbout"],
Cell[13743, 487, 156, 2, 70, "MoreAbout"],
Cell[13902, 491, 134, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14073, 498, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[14189, 504, 60, 1, 70, "ExampleSection",
 CellID->347893154],
Cell[14252, 507, 124, 3, 70, "ExampleText",
 CellID->1623164443],
Cell[CellGroupData[{
Cell[14401, 514, 175, 5, 70, "Input",
 CellID->1341864687],
Cell[14579, 521, 151, 3, 70, "Output",
 CellID->1150094200]
}, Open  ]],
Cell[CellGroupData[{
Cell[14767, 529, 167, 5, 70, "Input",
 CellID->976592890],
Cell[14937, 536, 243, 6, 70, "Output",
 CellID->132912753]
}, Open  ]],
Cell[15195, 545, 158, 5, 70, "ExampleText",
 CellID->1133101266],
Cell[CellGroupData[{
Cell[15378, 554, 287, 9, 70, "Input",
 CellID->1040025660],
Cell[15668, 565, 509, 10, 70, "Output",
 CellID->481646791]
}, Open  ]],
Cell[16192, 578, 228, 8, 70, "ExampleText",
 CellID->1171750794],
Cell[16423, 588, 357, 11, 70, "Input",
 CellID->83759855],
Cell[CellGroupData[{
Cell[16805, 603, 290, 9, 70, "Input",
 CellID->1190551768],
Cell[17098, 614, 19605, 328, 70, "Output",
 CellID->1498425677]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[36742, 947, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

