(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    149869,       3008]
NotebookOptionsPosition[    144514,       2836]
NotebookOutlinePosition[    145915,       2874]
CellTagsIndexPosition[    145828,       2869]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA IMPORT/EXPORT FORMAT", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"BZIP2\"" :> 
          Documentation`HelpLookup["paclet:ref/format/BZIP2"], 
          "\"Directory\"" :> 
          Documentation`HelpLookup["paclet:ref/format/Directory"], "\"GZIP\"" :> 
          Documentation`HelpLookup["paclet:ref/format/GZIP"], "\"TAR\"" :> 
          Documentation`HelpLookup["paclet:ref/format/TAR"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"\\\"BZIP2\\\"\"\>", 
       2->"\<\"\\\"Directory\\\"\"\>", 3->"\<\"\\\"GZIP\\\"\"\>", 
       4->"\<\"\\\"TAR\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compression and Archive Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/CompressionAndArchiveFormats"], 
          "Importing & Exporting" :> 
          Documentation`HelpLookup["paclet:guide/ImportingAndExporting"], 
          "Listing of All Formats" :> 
          Documentation`HelpLookup["paclet:guide/ListingOfAllFormats"], 
          "New in 6.0: Import & Export Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ImportAndExportFormats"], 
          "Systems & Utility Formats" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemsAndUtilityFormats"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Compression and Archive Formats\"\>", 
       2->"\<\"Importing & Exporting\"\>", 
       3->"\<\"Listing of All Formats\"\>", 
       4->"\<\"New in 6.0: Import & Export Formats\"\>", 
       5->"\<\"Systems & Utility Formats\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "ZIP ",
 StyleBox["(.zip)", "FilenameExtension"]
}], "ObjectNameAlt",
 CellID->3760],

Cell[TextData[{
 "Registered MIME type: ",
 StyleBox["application/zip", "InlineCode"],
 "\nPopular data compression and archival format.\nUsed to reduce storage \
space and transfer times.\nBinary format.\nCan contain multiple files.\n\
Supports a variety of compression methods.\nPublished by Phil Katz in 1989."
}], "FormatUsage",
 CellID->9984],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " fully support the ZIP format."
}], "FormatNotes",
 CellID->8729],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " can work with general ZIP archives as well as with specific application \
formats consisting of multiple related files."
}], "FormatNotes",
 CellID->1126358294]
}, Open  ]],

Cell[CellGroupData[{

Cell["IMPORT AND EXPORT", "ImportExportSection",
 CellID->2534],

Cell[TextData[{
 "When importing from a ZIP archive that constitutes a supported multi-file \
",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " format, the converter for this format will be used."
}], "FormatNotes",
 CellID->635498953],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"zip\", \"MR\"]\)\>\"", "]"}]], "InlineFormula"],
 " gives full path specifications for all files in a general ZIP file."
}], "FormatNotes",
 CellID->6050],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"zip\", \"MR\"]\)\>\"", ",", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\"", "->", 
     StyleBox["expr", "TI"]}]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to a file and compresses it as a ZIP archive, inferring the file format \
from the file extension of ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->28082],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\!\(\*
StyleBox[\".\", \"MR\"]\)\!\(\*
StyleBox[\"zip\", \"MR\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " exports multiple expressions to a ZIP file archive."
}], "FormatNotes",
 CellID->16806],

Cell["", "WeakDivider",
 CellID->1936],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", "]"}], " "}]], "InlineFormula"],
 "returns an expression of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", " ", "\"\<\!\(\*SubscriptBox[
StyleBox[\"fn\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ".  "
}], "FormatNotes",
 CellID->25584],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", "\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""}], "]"}], " "}]], "InlineFormula"],
 "extracts ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""], "InlineFormula"],
 " from the archive and imports it. "
}], "FormatNotes",
 CellID->10790],

Cell["", "WeakDivider",
 CellID->21617],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " imports the specified element from a ZIP file."
}], "FormatNotes",
 CellID->29182],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["elem", "TI"], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["a", "TI"]], ",", 
      SubscriptBox[
       StyleBox["sub", "TI"], 
       StyleBox["b", "TI"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports a subelement."
}], "FormatNotes",
 CellID->19066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " imports multiple elements."
}], "FormatNotes",
 CellID->23116],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", " ", "\"\<ZIP\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ZIP\>\"", ",", 
      StyleBox["elem", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " imports any file as a ZIP archive."
}], "FormatNotes",
 CellID->6388],

Cell["", "WeakDivider",
 CellID->9425],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    StyleBox["elem", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ZIP archive by treating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " as specifying element ",
 Cell[BoxData[
  StyleBox["elem", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->13101],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " treats each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " as specifying the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["elem", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5610],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     SubscriptBox[
      StyleBox["opt", "TI"], 
      StyleBox["1", "TR"]], "->", 
     SubscriptBox[
      StyleBox["val", "TI"], 
      StyleBox["1", "TR"]]}], ",", " ", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " exports ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with the specified option elements taken to have the specified values."
}], "FormatNotes",
 CellID->6450],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["1", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["1", "TR"]]}], ",", 
      RowBox[{
       SubscriptBox[
        StyleBox["elem", "TI"], 
        StyleBox["2", "TR"]], "->", 
       SubscriptBox[
        StyleBox["expr", "TI"], 
        StyleBox["2", "TR"]]}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", "\"\<Rules\>\""}], "]"}]], 
  "InlineFormula"],
 " uses rules to specify the elements to be exported."
}], "FormatNotes",
 CellID->19982],

Cell["", "WeakDivider",
 CellID->28621],

Cell[TextData[{
 "See the reference pages for full general",
 " information on ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->5193],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImportString"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ExportString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExportString"]], "InlineFormula"],
 " support ZIP compression."
}], "FormatNotes",
 CellID->27038]
}, Closed]],

Cell[CellGroupData[{

Cell["ELEMENTS", "ElementsSection",
 CellID->16754],

Cell[TextData[{
 "General ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " elements:"
}], "FormatNotes",
 CellID->4593],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Elements\>\"", Cell[
    "list of elements and options available in this file", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "full list of rules for each element and option", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Options\>\"", Cell[
    "list of rules for options, properties and settings", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->14895],

Cell["", "WeakDivider",
 CellID->20280],

Cell["\<\
The following can be used to select or specify individual files in a ZIP \
archive:\
\>", "FormatNotes",
 CellID->5638],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<FileNames\>\"", Cell[
    "list of filenames representing the contents of a ZIP archive", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", Cell["a single file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", " "}], Cell[
    "a single file, taken to be in the specified format", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"\"\<\!\(\*
StyleBox[\"filename\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"format\", \"TI\"]\)\>\"", ",", " ", 
     StyleBox["elem", "TI"]}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["elem", "TI"]], "InlineFormula"],
     " from the specified file"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->25167],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " by default uses the ",
 Cell[BoxData[
  RowBox[{"\"\<FileNames\>\"", " "}]], "InlineFormula"],
 "element for the ZIP format."
}], "FormatNotes",
 CellID->17420],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", "\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""}], "]"}], " "}]], "InlineFormula"],
 "extracts and imports file ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"fn\", \"TI\"]\)\>\""], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->4345],

Cell[TextData[{
 "File names can include relative or absolute directory specifications and \
the abbreviated string patterns supported by ",
 Cell[BoxData[
  ButtonBox["StringMatchQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StringMatchQ"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->23865],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", "\"\<*\>\""}], "]"}], " "}]], 
  "InlineFormula"],
 "imports an entire archive."
}], "FormatNotes",
 CellID->16883],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Import",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Import"], "[", 
    RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", "\"\<\!\(\*
StyleBox[\"dir\", \"TI\"]\)\!\(\*
StyleBox[\"/\", \"TI\"]\)\!\(\*
StyleBox[\"*\", \"TI\"]\).jpg\>\""}], "]"}], " "}]], "InlineFormula"],
 "imports all JPEG files from subdirectory ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 "."
}], "FormatNotes",
 CellID->24696],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\).zip\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\).gif\>\"", "->", "\"\<\!\(\*SubscriptBox[
StyleBox[\"expr\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\""}], ",", 
      RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\).txt\>\"", "->", "\"\<\!\(\*SubscriptBox[
StyleBox[\"expr\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}]}], "}"}], ",", "\"\<Rules\>\""}], " ", 
   "]"}]], "InlineFormula"],
 "creates a ZIP archive containing a GIF and a Text file."
}], "FormatNotes",
 CellID->30833],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<ZIP\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
          ButtonBox["\"\<GIF\>\"",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/format/GIF"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          ButtonBox["\"\<Text\>\"",
           BaseStyle->"Link",
           ButtonData->"paclet:ref/format/Text"]}], "}"}]}], "}"}]}], "}"}]}],
    "]"}]], "InlineFormula"],
 " is equivalent to the above."
}], "FormatNotes",
 CellID->10390]
}, Open  ]],

Cell[CellGroupData[{

Cell["SEE ALSO", "SeeAlsoSection",
 CellID->10679],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["\"\<BZIP2\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/BZIP2"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<Directory\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Directory"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<GZIP\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/GZIP"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  ButtonBox["\"\<TAR\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/TAR"]], "InlineFormula"]
}], "SeeAlso",
 CellID->176974978]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "MoreAboutSection",
 CellID->336977238],

Cell[TextData[ButtonBox["Compression and Archive Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CompressionAndArchiveFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Importing & Exporting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ImportingAndExporting"]], "MoreAbout"],

Cell[TextData[ButtonBox["Listing of All Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListingOfAllFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["New in 6.0: Import & Export Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ImportAndExportFormats"]], "MoreAbout"],

Cell[TextData[ButtonBox["Systems & Utility Formats",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemsAndUtilityFormats"]], "MoreAbout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["EXAMPLES", "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell["Basic Examples", "ExampleSection",
 CellID->41441511],

Cell["This creates a ZIP archive containing a GIF and a text file:", \
"ExampleText",
 CellID->1357109157],

Cell[BoxData[
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<test.zip\>\"", ",", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<a.gif\>\"", " ", "\[Rule]", "  ", 
       GraphicsBox[RasterBox[CompressedData["
1:eJzsvVdwI9ud5jkR+7azMa1WS9fUrVves6pYNEVf9N577z0JEiABggRJeO+9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         "], {{0, 0}, {200, 202}}, {0, 255},
         ColorFunction->RGBColor],
        ImageSize->Tiny,
        PlotRange->{{0, 200}, {0, 202}}]}], ",", " ", 
      RowBox[{
      "\"\<b.txt\>\"", " ", "\[Rule]", " ", 
       "\"\<earth seen from space\>\""}]}], "}"}], ",", " ", 
    "\"\<Rules\>\""}], " ", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1387541403],

Cell["\<\
Importing a ZIP archive gives the names of the files in the archive:\
\>", "ExampleText",
 CellID->1057577430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", "\"\<test.zip\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153148590],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a.gif\"\>", ",", "\<\"b.txt\"\>"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->2129203438]
}, Open  ]],

Cell[TextData[{
 "Extract and import ",
 StyleBox["\"a.gif\"", "InlineCode"],
 " from this ZIP file:"
}], "ExampleText",
 CellID->1824988095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<test.zip\>\"", ",", " ", "\"\<a.gif\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15870433],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzNmntUU2e68AdTTi6kdkVyOUnUWnD2zo1cIKHHhCKEJCgWLRjMTT5HSCCE
qBDiV0cEWrXnUzQByhyhzQWQcKmNCaholUCZ0QRC8BYDBRypU0S0ap1a67Tn
/PO92M6Znt6mnem31vcssgOLtfbvfa7v87x7v1CwI7dg0a9+9Sst+BSCz+f/
38iTr78eP/7y0aMvH//l/8Htn3z56cdXBzqaGhoaDgOpbx+4/PGjx78c4/Hd
P/U3Ha6tPVRfX1dXf/hQbW1taWFefmHt4NVHT36J+9+50Hy4oaGpqelI+4LY
7QuXuvpDtYX5+ar8pquP/knAo6vN4O4dXceOeTyeYwvXY50Lcqyzqx1gjEaV
VN5+559wzd2BhoaOjs6uzsFB3/lh/5AP/Ph8Xo8b8Dydna6uI/Y6k0qS23Tn
H7TXp4OHG/oHB8HCfb7hkeHhEfAZ9vt9X4nX4/F6O10uu0Wvysk5cvcfADy+
fODQu2D1vuEhz+DIpWDwypVgEFD8fj+gDQONfF53t8fn6qozlqpEwsEvfy7h
44ZNhf3HBn3+kZFBz6VrQMLhK8FQCGCCwQXWyIh/QRNPj8fTXl+Qn5uinvhZ
gEcXalM3N3UM+oeGL414gxOR8fHxiUgkMjERCT8VoNGlIPCO19Pj9RyrLygo
yBPy239GcN3paNqYv2Cl8/6RK0NDw+NTf5Xxiaew8alI+FI4HAoO+3p6Bj32
XFZenlzKUv/nTyXcbOo4Uu8DNvL7wVpDfu/Erf+6BeTGjQXIwicCLuHwtUA4
DFTxerosRrVKrZEy5Nd+EuAvl5sGfZ3e4UvXwqErwCYRr2ciHBwJ37o1Pn5j
gbNAGh8HrBGb1e2/BHzi89itxm1bs2TcpSM/gfDFQAMI0vPBawtmj4RDI+HR
cLjHPwKWDRYdCU5Fbj2FTE0EDT1eV3cw6Pe6OwHCZFSrNRLO8N8lPO6vber0
9AwHJ65dG58A1g4Ge0YiodDUjRvjE2D14eBQMDw1fmtqyl3f6fH22Bq7nXZj
ncVosli2qdUqEefS3yMMNHW+2+EZCYIovRQGFxBDAbc3GLoCGLduAevcGA8H
/MFgeMR1pMvu8Ls8PrfL5QAIa52xRC2XSwQ/zvhi4HDHMc+xdmBhT/vgpYnx
qXAwAqIV+Ba4YuLGjVlAmgo5rFZftz6Ty7D7nVaX2+2y/q7O0mW1GDV8vjTh
R/V4MlDb33/+vFE1cslu6rS5h0IOfygYmZqcuhH21ZkiwRCwFvBRMOg29Zx1
a0ocJq3aaLR73HVdLpdJLxHy+fwUPu9HqsnlhvOdHTv4kDtkqLPLFTs0Bqtr
ZHxmcmp2NnKEm+n1e0ORK35HN3COXWmwWA3qtQqZTFVgd3sWqpVRIEyg0xME
DPUPFpOPmt/dnJKXlGucMO9wleAZsrXdbvfIZGT0yuyNyYjNpLGC4jHk8br0
jlDYkaXsrpApNGoFTJboLfa6uhJNrpDFgogcxlL1D2yInzb0r16ZU1pgCvbY
vVaRUKB2uLzjYZfVarOFwpM9dZoydUm3O2jfquRk2MN+t1Vr6zZkrqWiUVgy
R6pWKCSSXCEJT4d5y1zfS3jc31+4Mqfd4hkOeoJBC6dkR3AkNNXjsLqsCkeP
vy/YZzA4FSbjdqfZoNWubQx5NWyFqUcsYJEJaEQ0jisVSvV6CUSKjxcIqDe/
D3G1oSE1oX3Yf8TtGB8N6hXW8OyUP2AfCjmzvKCCe/tmI/4Al6e0ak3HFRyF
1mDYts2g0GZxxEuFQgI2ChhIv8WgZEEQjZNJVXzPTni3qbBWVTcxkqs2BWcj
PQr7kRtzU95hV89ktyVD5u8Ld/dNh9wmMc/mNJjsGlkWT6+1hMrYAjGPl8le
gkITsAK91daolHHjGTLeMv93CH/pP9xZr/dfqSPlDN8Id2/TO8Kzs+N2lzcw
oniW7ezpG+1xdDvLbP5ud6NWplSLxWxupkzNYGRmKjQwj4piUHlap7/H3agU
woKtQjL8nci9eXhwqKvEf0lOPzIVsen1Vt/8/OyU2R/udRjSeiIX/Q4nWL3N
5u4LWh16q1mvlnHEmZkEKkNh2MK1KtlissE5FAwEerX6LdtKpCy8+lv7+aPm
dwdH/PbhEaFoaNytNlpM3bNzt2ddzlC3oyfgDIRCZmfAcbx3qLvRpHVVGIxa
JZfNzhDDMm7m9h5nj00re1bhD46GRoccDkddiYAGs76lxp8ahn3BYGcwKBV6
vWogMrVnfiZiME26h6wAcHGyd3R6ZrSv1wlyzmQQw/osNpunkP0L15Alc7gj
IafBsB0Y03UWVKxGo4pO48e0f0uJY1dGgsMqTyg31+4wWVTSrZLu+6Gg3BD0
B/2Bmbm52clRp63CpFQ2itkZGZmJiWwum5epUQCn8BzjM9Mz05GQO2Q29LoX
Kgkrhp9A+p9q3GyoA5W7S+UbKt0GDL6tRCPmTM2PhCR25fHIxYvHu+dmIjcu
hkJ9ZVrlSzztlqztjTI2lcERqK3KRGVofNppPj49edxmNh73uu1yuWAxnxmP
/KYaj5sPHBqfjlgKrnhNJq3Zalhr1Vs/C4QdrDq3NRiZ7yubuf3g/v37925P
R5w687YsrTNk4vEYPCFHYWJrR/2jjZnsTIPZptU6HV67jMMniWjx8axvtAsf
H9hcC0pdHaSxl+r1WoNRrPY+uN39XyohLHa4AxOOyfn7Dz97+MknD+bnb0/3
KnuBPloxj0HliM1VaTJQF0dtWt4S+fFMmcHbrRcw40lEGj0h6hs74MCB1Pa5
2YhHRMzV61UatUzsuH+v0aWAYcEzbIOpLPxg8uH8g08eAkUePLg3ezFiMlrZ
zz6zhMoQNupMVVsqQFFn8AQ4I4+xNdij4cD4+MVMGh+v+puzD6/e5Jm/BnZH
jVGUI5HLZO77t9V2+SIsQUaAOYZA6EGo1ypunAOMewuYSWejaat46bOwoKRP
q6wwa00KgxKGEEYeQRHs4/CJMaTFtAQRxPj0G3Y6NDU/lJuTZArtEMotfbMP
Z7VaIyoKxml5FIY1NOofymAvW2Ken753/+EngDMdMFlc27gMsdmmVNpMyj7n
8TIqGWWgEoQhBwUfE0uiJ4jkrL9Z6nxD7aXZ251J/HiWFTTHU7N+vUH5Dm8R
QobTmmUKq621TKlNXEY1B3rnPnm4wHgwY1Ub1RIc+xmCbLvNZrK1hrRLcDg5
GaWIKHEYJD4ugZ8r56Ptf7XT4GDTtfm5uhxRgSBXJNFoqGyTwq5EINBUtEJr
tSqVVnNm5kvUl2yhmYu3HwLGg/v3QoFuKYfL+JdnGLKtSqVY2Zv5LBoSYqNM
TikDiWHFxkM5ciGD8XVqgPaycGJuypfDL91Gx1CoHK1RbTZERUWjFsEgz0Fd
dYNqwdEH5u7dnpwHajx88OD+g8iQmiOkcHkCoYTL4CplVBQahqIII2ICjMDw
+fjFTD5HiPu6U5jwDQ5OgLYphcbPMbp83T6vRLHtf8EYEiqazJUBUWh5SxMd
o/P35oEzFgz1YP5eQKvVPrsIDQu5ppJMDscjRhDIKMQizcizBAgBM/AxpFga
Xwh3fYXwDR8r7bwyHpQzaXml3SM9dTCwc6mcw6ITyVwxB4apMHuLc3Luwf2H
CwJiN+QokalyJc9EYWAGDHM5DIkMFY3F4nDIIdMiLAMgkEgSBPH5DMnTnenL
855NhYcmhgY3MfPkOfUOK0y1e0pUKhIRB8PEDNMWMlvh6Jucu/8ZkD8/BJdP
HFS5gselRMMgpkBFh2GxIDoajeOi4JGlUUgSQkREkkg5TL5EIH3aJ9wd7Fpd
WDvlG8yPY+bK1VIOpctnNRpzBVwGjoDG4sgZtkCwd/rhZ39+cG967t78lG8u
ssPiYUSBpoCMg8lL0GSIEo0gEAQEgle9CIHERLHgqAQWM54p5BI/eoroGCzs
8Ex0lRYsZopgIpLVfmkq4jfK9TIIgcASlvbNzbVWzDx8eH+yQia0er0KhlDO
IXMo0VEgInA4NCaaQkIiUATJErTHtYiTi2EhiSxkLD4On8Rn4J9OAx81DB46
NjzSVZDCjEvKo4lCkdkrXrcz6OIKFArQxoydbDt3/97pKrPSIBPKJCwuFvQC
FOGSKOQzUYhFz6DROBQSiURzCWirn4JRWSF8TAz4ARFFZ9EIT0PqwuHmpvr6
wdr6/HxafEJBeHZ+/tbEyFCnVSqTZRrNa6pPXv/w3lhbeZZYr1YICQQpDotF
EyAKlo6NwsGoaBiJAAgOFdUZYETJc0tIGAyMpxMX07i0eIj4NL8H3jxQmLIx
LzXv0Kbk0nxLcAQkt1oh52AxqCgCY9mGfSdOfnjyzL6dawQcoZpKhlg4LAqN
xkajQJRSYRQKjQAWoyzlmtwKlEDNYMU8hxRyVYJYOjMFYhI1C4j+A6tT/y05
OTUvPyWnLi+/dFspny8Q0IlY0OQRKcU1u2uu79ld3Na2iieXwBDEIODQz+Cw
C/ddFLVoEfhCoFEwgTNlEkAcq5qMQSIJJGaBIAZiQQks/NqFJmHg4Op/S34x
KTU1NV+UY8nP46tUuXQsCRMN1skr2rdv//VX15+oLC7KXiOmwDy1ggDsBJFR
0WgUuDsSjaOAm2IRXWEhEikVSLkYJIIB0UrrRBAeYkJ4+deI1NQXUzeVlm7i
J+Uk0+KZi5ExQFsQj3D5mXP79+/539Una9qyVy1fSmGtNQspFCIWeDwaDUIK
6EnGRhEohCg9l4KJkeFFUuBpiBjLL+HGxvPjEyhrF3LvAkAkASVqO2uTaExa
XGzc4hgkEhEN+rsle8/V7Pvtb197pfr6ierlK55fyskUMyg4NBqBYqCjgRYo
RFQ0RSODUNESLJ6OZ7CIzyFiMBASE4OPjWUymSKGbEGLywdXJ734Ii2JlpxE
i4unraThY5BYmCuE0Sjeid0bfvvbPXt2Xx+7WJmWtozN43JhAgGLArkMcobC
5UIELoOwCAFJxRAdi4G5SPJzGAwLIkGYGCgF4kupsgV3Xz5w4EDSr19MEsXn
JDMtufy4xYvpO44cCY06retf27CA2LVrd3pa+svLnxdLuByY/BSxLDoKAbNR
UdHA5QhGLkWIRWBiGMIYLJ2E4UjxcSQSk8WVy6h1T/Pi4IHazS/+OjW5tDNW
GrwxDJooSOh1h0OR0P5dGza8umvXrvUbXljxwopVaSsSOSyYQgC5tnTF8mWL
gCAAIhqWMnCMZ7B0JBFajMXiMWQ5MT4lAdipQLn0aXa//+bBzZtTkwtL7fXM
1G0TU+OdxkOlPT4wU+tqXl1AvLp+/S7AWL4ifV1aIoMBkg4VvfyF5UsXfIFF
LMJgKQQ8BENkkHLkWDyWRBJy4yHQvCQkiIRfIS4c3Fy4eXVtqeWKkZ/HZ6k0
/ORkUcGRLrl1/fr1GzYAJV7bt2fDC4CRVpS2nEGFOWjUswCRhgKERYt4HC4a
I2BhsDEYEoeCZwhlXCmRJFPKMtXqBPqSpwXk5sHVq/Pya/MtV4YK8mJjkLGx
scCqsAj+zYYNG9bvenXX7hMna14pfjlt+fK0NTwGRwZ26CUr0lfono9CoTVy
4RIFQaQF9RVPfI4AYbF0Bp0Zz7E5KkxlMjoN91SLOwc3r07d2FRfGplqLy1g
LY6JwWBiyFjEqlfWv1JZWbm7prhy797syuwVq1YtT2TDLPlaCQW1LH3Fqowo
hFDDoBLQRNEW5HOx+OfwBA4RiYzB4CFl4LjTpoQTmF/Nx3ffBImxqb2zdGJ8
NuJrlwnx8fgYTGzMmvUbdr+yoXJvdXZl2+m9J09WF2cvT2NTQdDChGhs+vJl
SiqRz9MPKRAYAoVCJwI382UsrpCI/FfW2p7jTqeSyWR9NY896j+4enN+Ya1l
FgxeFr19RMXnxBD/FdKlp7+cnl5cnb3zleq9Z2dmPmzbuSpt3UsgvXBoBKco
bdk6g4q1NXgkE4eLQqLxRDyRSCdr9BoukSXgms66K5RcFrz2qznmcvPhwvbC
lckWj7fuiEuUo9jhzkVJOMrKvUez014u/032y7rTM/N/fvjh3uz0dcqXGBQU
DssrT0tvdciWmJQQjgpHI/AkMpkESieDodjKgYTSMr87i8/nwJ1fd/5vH2zK
9+XFLQa5nZMTt5gm9NTh8eqs1r65VUVFoPwV7b3+yfWLc3OTbUW6dVmJS6OJ
ZKpyVXnfUQ7XKKHCMg6MwD2HpRPIHAmFKDVwIaHCGnCwmHz+sq+PwO4OHChM
rZ840p5PS2JuystRcYZDUrJMWBU4pyvPaK2qamm5ODd5enrmw7EinXZdxjoq
EdZAmtbyUaOUjUIQWTCHGIVEYsgstYRFp3Ml8hKjtW8LnS/hCL9u1R5dbj6w
ud43cuyKl5+aVKD2CChyqZBCzDg9Nta3rry8fHvF2ZmL01Ut585VrVlXZtOl
YbO0HI245KyVA0XjEFg82J2QdBYR4kgJTA7LanI5Hdu5AqmQJfvr9H2h//CB
wk0bC1xyWlwcP1Zi4UJ8FkyQtVSVlZfpKgzO1pb5ybPHdafHimzbdWVVa7ij
DrdRyDLLGAT0QmMG4WCpnEuG+XIuNgYyNoJxkyuQSLjQf59T3GzuaD6Ql1eQ
79uRRIsnpdSXiPgsBtbg1GZqW9ZpK2xH+8amdVW6loDh7HGD4eyky+L1WzUi
KYuKJmKjiHgKxMgVglWJIIiC57sb1VIul58rSmD89zHFo+aOwQMbN+Yly0uT
4pJp0iMmLoEAcbVum3KrrqyioqL1eNHRljVlFZG+vX1lulG3xaJVy6QaGQWL
QEWhQV/GomBIeIqQQyHwha5Io4bP4jPlKQlb/3agM/BmUy1IjY0pL66kpdBT
tso5kEIma6yo0CqV5nKd1tDXWnT66LqWqqOTF4sqRq0KFizmmTROHqwhIwkE
HAGDxcTQKRSGmMFVlLjN6gQpP0nKh74xiN15s+FS06a8wo1JtNQcekoKxBI6
+i6GAi3rlFVVrcfLnBWBitOjur7Jc2OtvRGnhophqA2hXpOyJ2TmoWAuFANm
CkitNDllfKt5bQJf5UhJEXEzvzEVP+4/3HBtGJT0lKSUZLoob8eQwz3zIDQa
aGntPTpzfzRwVFk2Od2yrqJ1b18g1KgUM6Rkx2fTbGGg0TRn1sqIRAaRJLGG
ep36kqFGFgTpNfEpQp7hm6c5N988sLlrojA1NTlPrkpJGP5iatIF5vQKm1nZ
evyiVtuozer7bL63pbWl7WwrQ8GTW8R90+ZMqVbGa3RkUFEoAorljdyebOVJ
jV164Vp5fFKKgPc/zqRAndq8utN3KDU1xzLsUdi/mO/T97kNL4FJLsscsImV
bnPfZ9MVLUeP9oVsbBkaUrtvaGVrX5LIGYDvlnHFWr0/NDNTod8qkXNFEtCm
8Xnbvvgm4vOP3jq4eWO+/dCmVFVeqaV0NmB0b1FmZdoqSmytbmVihvb09MPe
srKLZ8daqvoiegJFZloq9XrFDJm/wmpxuudvu/UVkdsBk5BIY/KZK5NThGnf
Oj9//P6bmzfnbTrkKlDlqyQiaanboeRlKfyB3lZ/gIEWvtR68V6gpUJX1dZa
XaXUwgRYoCzps3MlJQ6H1R+ZdG+XWWcu9qhgIlPElEqYwNnabx9B3nn7QH5e
Xp4FMApyVHK+NeTQZPLs/tnIbEi4hCAsG71tTlSWFVXpitrKOHy+RChRmDkC
YYlEwwVdKATLe+ZsHDw9ga826UWiTUL2dx4C/OXCW4cL8/M1Ro3Kd8geUBtH
/a3mrWq3023Owi2hskyTc61LeboiXUZ59ZjtWZhBQAmpoMWhUEgkOimOyBIV
mKDF9IQEoclgEG3KY9V993DwP/ub6y2lKrlCorfbHd1mg6P1iEOtWGticzI5
Mn1Zb2tri06XrVtXVF2kyySDfhbs13QWi2uUgd2Nz4hl8okQjc439ZYV5IhS
Uj7+DgF4/G1PXd0OjSJXmrvV5FDztrc6G01KrVKssZpLtMoMXVlLRWvLzuLK
6qKidWlpZDQunkYkwvEcPInLFXJYUghKgIT20bNWuSgpZeB7CMBUA32ORqNW
u1YilSq0GWy2otFh0Gq3Kww2k2ktW1tR1tpSvVNXVF5VXrSuqIhHgVlQbExM
LI1OS0hI4CbEJrH4Ja2BPoM8Jenw9x83P+of+sPR3zX+Tp+VlSnOyFiVmJiR
yRNr9DyxLCvx+aWJGVnlVdlFuqryquLKneXl1WkYXOzieFoCnxVPY9JpNFIC
M6nAfdamVyXl/dDB/N3+0bFzp9tqKou2rFu3Zk3aqkQ2+/nnl1IZzz//PPiN
rc0oK9tetKW8vKiysnh9TQ2PGINPYMDEeCgunklaTKMxRSaHyVSSsunWDxA+
//zj98fOfXDmxL59NZU7i7esWbOGl5gIIMuXJ4LvLHNVhrJquy47W1dZqctO
X787G0NKEEL8HCGTxYLiVq5cyRTZnTZLXsr5HySAWjXwhzMfnDl5ombfiZrK
Yt2aNasSVwFJBNfErLHtGbwtuqJsXXlx9ob1r+7Zs2cVjZ/CT+AnQJBcClI6
Lkm+owREU8cXP4J4cnXg96fPnDx55sTJUyf2leuKs7PXgL4/O/vl9FWrFiy3
PPHl7J1Ve4Ghinfvfi2bjqeDLp+fsGmHKGkl2JTXClNSUjt+/FH7k6v9gHH6
5Jm2mlN/PLV///6aPbvXZ2fvemX9hvR0wGAnpqfryssNDAqRQIRYdIgeR0pS
iXJSVgJD0UTSv08AoXv1fd8fzpw+c2rfex988MdTp069sR9MSa/teW1hzFjQ
Y1V6UblOWbQmK4OBj128GIxt8SnJzHjgiSSRVJS6sfPvvy7w5KP+34+dPnny
vT/+Eehx6r03/v311994/fV/f33Pnl3ZCxbLrsoilxfvrtlXubt4FQOKi4uj
pYBx5deiLIU8Nc/3k15IuAPy4522tvdOnTpx4o2amgXE/3njjTcA4zXggVd+
pyGJqitPgrgDZty3r4gFTJSUnJJrUOdtKvxpD0A///zTC4N/eOed/2hrO3Pq
vZrK/UAHQADa1NSAMKuSxXOLis+cA+My+Hv/ibaW3JycF/MK9HpV/qHvK0zf
L4+B08+cOXHizKmx6yf3nXjv1P4Fxv739tdU/iY3SbCluBLEHIiF/Xtqqrfv
sPg9Fq8pP79w8Ge96XBnAEDOXR87c2bs3Kmv5A1gl+rKLLy4eOfOmmoAfq+t
re2oWq7RmryjXmPh4e99fPRjitzsH/z92O25yfDYdaDQyQ8+OHfmVFuLPjlX
V1S1F1ho/3st1kMmrdHqtLu8PU2HBv6BlzUeXX67uePy+MRk4Ny5Mwu2Hzt3
1JRvKK+urgZO2NfmaN9evrfV6/H7fF317975+YAF+fTy+28PNL/Vf+ni6XeO
nj56/PhxR3Vl5b79C4AqS5O11ev3D/sHm+rf/fgffxPk0c3+t99+s/n9/o6G
ws2FhYWHrFXV1SdOtFWZLJ6Qf8jVOdjR0Dzwz7xqAuTLjy/0v/XW+7cmzl/1
NR84UGtta/sPR2O999ql8wODHc3N/Tf/2Rdmnqpy5+rlCxeuXh54t6P9cOmh
+o7Ojo7+9weamwcufPzpL/Haz8K7S08e37370eWbf7rwfv/bzWDlAxcuXLh5
5+7jr//9i1CeGvvJ40d3v5JHj//y5Be69TcpT75105+O+L9KIR4e
   "], {{0, 0}, {99, 100}},
   ColorFunction->(Apply[RGBColor, 
     Part[CompressedData["
1:eJzFmNeOHkUQhRfEA5BzEG8AAgQIoX4FMDlLSFyTo+AdcM42V1whhHPO2Abb
YG/etTfnvM4JMLir5qsRp7XiknMz2jlT6VR1/9378Lvvz3vvxobruKGh4abr
jwcNP6Y7DJvSnYZDqcFwuvr7+3SrYX263fBz8Ly/y7AlLVuacTj42wwbglf/
7m9jutewvbDnPc+lSzIOFf7hVyzP+FXy35zuM+xI9xhqnrweMOwq7OFdp91p
1cqMo0X+9xt2VnGOFvnfbNhb8OT1kGFPkR99gV+zOuO3or654vv7H+I71Zf4
87/N2FvUhy63GPYV/tEHe82P+rFXHl19jvZX8Wqeur3PB6q/jxf5LVyQsT+t
XZPxe/Do7joerP4+ETx5Mddqv2B+xr6w/25txnGZvwNpyeKMg0V+zDtzq/yi
hRkHws/KFRlHgl+9KuNYzKXqRz95Kt/UaAhdtb7WFkO8V565Is/GE4aiP+jj
ejYW84W+5KP2dxt+SYsXZbQET1/RT/0Tl/qVZ658Tg+n5iZD4Z/+PW+o7YmL
/j4PjUX/WLfqH3v6qjzzwbrzOWiW9XMk7DU/8sJe/WPHXLxgaJb1V/ddeeyY
H42Pbj4nx9JLhtYiPv6ZN/XPulKe+uHb2wxFf5kfz6e10J91t3xZRkfwzDO8
zid5853WB48umh+6MJeeT81Tl++fJ6p5qvVHd6+zKb1m6Cz8MzdvGE4FP8/Q
FPF1PtCL75THjrnX+omLneqPbuiq9aMb9q8Y2gv/6KI8fslf45Mvc+37Raus
3+b0oqEldbQbiv2Rp+8z7TJfbamt1VD0Hx7/vg/W832y05BeNrRV+0GbrM+e
qJvv/t3/rtg3tX/Yd3YYivzRH334Dh5/Lc2GOdcPdfl+X88fftHP98nOor/0
Se2Ze/p26qRB9v/W6Lv6932/PZ6+X3YW80/fND526KY89vTF96s6P/99aYo5
8P2uu7DHf3eXIXj6ir6vGmr96Rdzq/HfNHRV+2NHsX8Ql77q/gFPHN+Puov5
xq/vo73B0w+e/jtV+/ffh5PRl9cNdf7EQ3fV3/ffnvCj9uSFf9WX99i/Zajr
07jK45+51PrRk7p7ewzF+uep8+Hnv67UdcpQ8Lznu3cMvYV+8Jo/+fKd8rzn
qfURj7o0Pv3p6TbMaU9+Oh/0k98fPX+v+ymjL/ZHPT/471d/9En3zw3rMwZi
DtjH4X1/64v+6/5x5nRGX+ij+T9mGAxddT4/MPSFLqof+bOPa/99/xwMe+V9
/xmIOWHO4J8wDIe95u+696fnDH2V/nV+vr8PRh2a/4XzGUOho87/pYsZI+lD
Q3/MC7z3Yzg9YuiL3zv4K5czxqKPfr/rC55+s77pFzy/O6zfRw39xfpEP+rU
9U3/mUd4/NIX9NT1Ba/+0ZP++Dmx5OkLOsLjF121PuYSe+YFnt8T+obO8MxF
X6+hqJ/5pS+qP/Gw1/p4TxzVj/qx0/ypm7gfGwaL/uF/44aMmkd3P2f2p00b
M4aK/Ye+MefKk5/mT7/IT/n16zL64zvyUB571R89+I4nPPsHfdL82b/8fD2Q
zp7JqO2pi/gfGQaK/KhL+0M8vvPzeK0/dsRlv4Enrp9j+4v5JB/sNT71w/t5
t+bRm/p1PogP7+e0ej7IhzzUP/XyXnnseao+6HHubEbJky9zr/nzN31GD3j2
b/qg8+H753AxZ/B+fh6NunR/+sQwVN0vyvz8fD8ceWl//dw+EvWpfp8ahqO/
Gp/fP7+fDaXz5zIGi/z9HD5U5Ic/9Cdf1Zcn9er6pG9+H6jtqYf+6P6j60Lt
iUdd1KH1o5/6/8wwEvk/bqh5+oZ+Gh+/fi4bSls2Z4wETzzy1Pj0D3vl9T3f
63zSF+U5X/Be8794IWM4/LAe4P3+MxJ+eOr8YE++8J8bRqtzykhhr37ph+pH
3k8aRov++f8VRiIOPHa893vkaLG+4DU+/eS99pf68KP85UsZo/EdT7VHR62P
8x866P7l99qx8MN5E/4Lw1jU7ffd2v/ThvHg/Z5R89u2ZoyFPjpffl8fi/Wj
+6Pfq8fiO/SA9/vGeJEn/FeGichD86de3vOd9p/+kAf81i0ZoxH/S8O4nI/H
wy96a394r/F3bM+YCL/K/3E1YyJ08P8j1PF37siYDB34Dv7qlYzx4P0eNyn3
+8n0jGEy/MH7vXE8bd+WMV7dIyaC/9owVZ3zJ0IP+G8M09X9YTK+g/fz/3R1
75oMPeCv/ZUxXf0fZ6o6r9b5vW2YSbt2ZkwV+f99LWMmPWuYru5PU4V+f/6R
MRlxND/sqQfez8ez8R494P38PRPPPbszZoL/r6ef/2eLJ7zfW2aLp/KO2eoe
U8cnH3REb3jVBZ3hWb/+/7Wx9JRhTOqYC/8//w9Cfuu3
      "], #]]& ),
   ColorFunctionScaling->False],
  Background->None,
  ImageSize->{99, 100},
  PlotRange->{{0, 99}, {0, 100}}]], "Output",
 CellLabel->"Out[3]=",
 CellID->867391296]
}, Open  ]],

Cell[TextData[{
 "Extract and import ",
 StyleBox["\"b.txt\"", "InlineCode"],
 " from the file:"
}], "ExampleText",
 CellID->65982564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<test.zip\>\"", ",", " ", "\"\<b.txt\>\""}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9632326],

Cell[BoxData["\<\"earth from space\"\>"], "Output",
 CellLabel->"Out[4]=",
 CellID->1693854471]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZIP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 51, 41.2802550}", "context" -> "", 
    "keywords" -> {"compression", "archive", "file system"}, "index" -> True, 
    "label" -> "Mathematica Import/Export Format", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Registered MIME type: application/zip Popular data compression and \
archival format. Used to reduce storage space and transfer times. Binary \
format. Can contain multiple files. Supports a variety of compression \
methods. Published by Phil Katz in 1989.", "synonyms" -> {}, "title" -> "ZIP",
     "type" -> "Format", "uri" -> "ref/format/ZIP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21521, 755, 91, 2, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 145694, 2862}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2256, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2879, 78, 101, 4, 70, "ObjectNameAlt",
 CellID->3760],
Cell[2983, 84, 347, 7, 70, "FormatUsage",
 CellID->9984],
Cell[3333, 93, 323, 12, 70, "FormatNotes",
 CellID->8729],
Cell[3659, 107, 419, 13, 70, "FormatNotes",
 CellID->1126358294]
}, Open  ]],
Cell[CellGroupData[{
Cell[4115, 125, 63, 1, 70, "ImportExportSection",
 CellID->2534],
Cell[4181, 128, 306, 9, 70, "FormatNotes",
 CellID->635498953],
Cell[4490, 139, 375, 11, 70, "FormatNotes",
 CellID->6050],
Cell[4868, 152, 683, 22, 70, "FormatNotes",
 CellID->28082],
Cell[5554, 176, 854, 27, 70, "FormatNotes",
 CellID->16806],
Cell[6411, 205, 38, 1, 70, "WeakDivider",
 CellID->1936],
Cell[6452, 208, 601, 19, 70, "FormatNotes",
 CellID->25584],
Cell[7056, 229, 459, 15, 70, "FormatNotes",
 CellID->10790],
Cell[7518, 246, 39, 1, 70, "WeakDivider",
 CellID->21617],
Cell[7560, 249, 341, 11, 70, "FormatNotes",
 CellID->29182],
Cell[7904, 262, 574, 20, 70, "FormatNotes",
 CellID->19066],
Cell[8481, 284, 582, 21, 70, "FormatNotes",
 CellID->23116],
Cell[9066, 307, 691, 24, 70, "FormatNotes",
 CellID->6388],
Cell[9760, 333, 38, 1, 70, "WeakDivider",
 CellID->9425],
Cell[9801, 336, 517, 18, 70, "FormatNotes",
 CellID->13101],
Cell[10321, 356, 1075, 40, 70, "FormatNotes",
 CellID->5610],
Cell[11399, 398, 666, 22, 70, "FormatNotes",
 CellID->6450],
Cell[12068, 422, 816, 28, 70, "FormatNotes",
 CellID->19982],
Cell[12887, 452, 39, 1, 70, "WeakDivider",
 CellID->28621],
Cell[12929, 455, 360, 14, 70, "FormatNotes",
 CellID->5193],
Cell[13292, 471, 343, 12, 70, "FormatNotes",
 CellID->27038]
}, Closed]],
Cell[CellGroupData[{
Cell[13672, 488, 51, 1, 70, "ElementsSection",
 CellID->16754],
Cell[13726, 491, 191, 8, 70, "FormatNotes",
 CellID->4593],
Cell[13920, 501, 668, 13, 70, "2ColumnTableMod",
 CellID->14895],
Cell[14591, 516, 39, 1, 70, "WeakDivider",
 CellID->20280],
Cell[14633, 519, 129, 4, 70, "FormatNotes",
 CellID->5638],
Cell[14765, 525, 1150, 27, 70, "2ColumnTableMod",
 CellID->25167],
Cell[15918, 554, 294, 10, 70, "FormatNotes",
 CellID->17420],
Cell[16215, 566, 442, 15, 70, "FormatNotes",
 CellID->4345],
Cell[16660, 583, 307, 9, 70, "FormatNotes",
 CellID->23865],
Cell[16970, 594, 330, 12, 70, "FormatNotes",
 CellID->16883],
Cell[17303, 608, 508, 17, 70, "FormatNotes",
 CellID->24696],
Cell[17814, 627, 804, 23, 70, "FormatNotes",
 CellID->30833],
Cell[18621, 652, 1133, 37, 70, "FormatNotes",
 CellID->10390]
}, Open  ]],
Cell[CellGroupData[{
Cell[19791, 694, 50, 1, 70, "SeeAlsoSection",
 CellID->10679],
Cell[19844, 697, 815, 27, 70, "SeeAlso",
 CellID->176974978]
}, Open  ]],
Cell[CellGroupData[{
Cell[20696, 729, 58, 1, 70, "MoreAboutSection",
 CellID->336977238],
Cell[20757, 732, 151, 2, 70, "MoreAbout"],
Cell[20911, 736, 134, 2, 70, "MoreAbout"],
Cell[21048, 740, 133, 2, 70, "MoreAbout"],
Cell[21184, 744, 156, 2, 70, "MoreAbout"],
Cell[21343, 748, 141, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21521, 755, 91, 2, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[21637, 761, 59, 1, 70, "ExampleSection",
 CellID->41441511],
Cell[21699, 764, 106, 2, 70, "ExampleText",
 CellID->1357109157],
Cell[21808, 768, 108956, 1794, 70, "Input",
 CellID->1387541403],
Cell[130767, 2564, 120, 3, 70, "ExampleText",
 CellID->1057577430],
Cell[CellGroupData[{
Cell[130912, 2571, 117, 3, 70, "Input",
 CellID->153148590],
Cell[131032, 2576, 141, 4, 70, "Output",
 CellID->2129203438]
}, Open  ]],
Cell[131188, 2583, 141, 5, 70, "ExampleText",
 CellID->1824988095],
Cell[CellGroupData[{
Cell[131354, 2592, 156, 4, 70, "Input",
 CellID->15870433],
Cell[131513, 2598, 12508, 211, 70, "Output",
 CellID->867391296]
}, Open  ]],
Cell[144036, 2812, 134, 5, 70, "ExampleText",
 CellID->65982564],
Cell[CellGroupData[{
Cell[144195, 2821, 155, 4, 70, "Input",
 CellID->9632326],
Cell[144353, 2827, 95, 2, 70, "Output",
 CellID->1693854471]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[144487, 2834, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

