(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8551,        270]
NotebookOptionsPosition[      5175,        173]
NotebookOutlinePosition[      7607,        240]
CellTagsIndexPosition[      7491,        234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Animate Selected Graphics" :> 
         Documentation`HelpLookup[
          "paclet:ref/menuitem/AnimateSelectedGraphics"], "\"GraphicsAlign\"" :> 
         Documentation`HelpLookup["paclet:ref/frontendobject/GraphicsAlign"], 
         "Make Standard Size" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/MakeStandardSize"]}, #,
         2]& , Evaluator -> Automatic], {
      1->"\<\"Animate Selected Graphics\"\>", 
      2->"\<\"\\\"GraphicsAlign\\\"\"\>", 
      3->"\<\"Make Standard Size\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Graphics ",
 StyleBox["\[FilledRightTriangle] Rendering \[FilledRightTriangle]", 
  "MenuPointer"],
 " Align Selected Graphics..."
}], "ObjectName",
 CellID->482985063],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Align Selected Graphics", "MenuName"],
     "\[LineSeparator]makes selected graphics cells line up with the first \
graphic in the selection."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->20798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Specify which edges of the graphics (left, right, top, or bottom) you want \
to align in the ",
 StyleBox["Align Selected Graphics", "DialogElementName"],
 " dialog box. The specified edges are aligned with those of the first \
selected graphics cell."
}], "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->28009],

Cell["\<\
When left and right are specified, all graphics are set to the same width. \
When top and bottom are specified, all graphics are set to the same height. \
When all four edges are specified, all graphics are set to the same size.\
\>", "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->27157],

Cell[TextData[{
 StyleBox["Align Selected Graphics", "MenuName"],
 " is useful for aligning animated graphics. "
}], "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->20472],

Cell[TextData[{
 StyleBox["Align Selected Graphics", "MenuName"],
 " sets the options ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ImageMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageMargins"]], "InlineFormula"],
 " on the selected cell objects."
}], "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->23622]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18190],

Cell[TextData[{
 StyleBox[ButtonBox["Animate Selected Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AnimateSelectedGraphics"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<GraphicsAlign\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/GraphicsAlign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Make Standard Size",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/MakeStandardSize"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->140892801]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics > Rendering > Align Selected Graphics... - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 53, 54.8149234}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Align Selected Graphics makes selected graphics cells line up with the \
first graphic in the selection.", "synonyms" -> {}, "title" -> 
    "Graphics > Rendering > Align Selected Graphics...", "type" -> 
    "Menu Item", "uri" -> "ref/menuitem/AlignSelectedGraphics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GraphicsAlign"->{
  Cell[1736, 56, 439, 12, 70, "Usage",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->20798],
  Cell[2690, 90, 356, 8, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->28009],
  Cell[3049, 100, 326, 6, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->27157],
  Cell[3378, 108, 198, 5, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->20472],
  Cell[3579, 115, 466, 15, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->23622]},
 "alignGraphicsSettingsID"->{
  Cell[1736, 56, 439, 12, 70, "Usage",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->20798],
  Cell[2690, 90, 356, 8, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->28009],
  Cell[3049, 100, 326, 6, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->27157],
  Cell[3378, 108, 198, 5, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->20472],
  Cell[3579, 115, 466, 15, 70, "Notes",
   CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
   CellID->23622]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GraphicsAlign", 6266, 199},
 {"alignGraphicsSettingsID", 6882, 215}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 924, 21, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1547, 48, 186, 6, 70, "ObjectName",
 CellID->482985063],
Cell[1736, 56, 439, 12, 70, "Usage",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->20798]
}, Open  ]],
Cell[CellGroupData[{
Cell[2212, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2690, 90, 356, 8, 70, "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->28009],
Cell[3049, 100, 326, 6, 70, "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->27157],
Cell[3378, 108, 198, 5, 70, "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->20472],
Cell[3579, 115, 466, 15, 70, "Notes",
 CellTags->{"GraphicsAlign", "alignGraphicsSettingsID"},
 CellID->23622]
}, Closed]],
Cell[CellGroupData[{
Cell[4082, 135, 311, 9, 70, "SeeAlsoSection",
 CellID->18190],
Cell[4396, 146, 737, 22, 70, "SeeAlso",
 CellID->140892801]
}, Open  ]],
Cell[5148, 171, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

