(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10080,        345]
NotebookOptionsPosition[      7370,        254]
NotebookOutlinePosition[      9001,        305]
CellTagsIndexPosition[      8927,        300]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"\"Balance\"" :> 
          Documentation`HelpLookup["paclet:ref/frontendobject/Balance"], 
          "Complete Selection" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/CompleteSelection"], 
          "Extend Selection" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/ExtendSelection"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"\\\"Balance\\\"\"\>", 
       2->"\<\"Complete Selection\"\>", 
       3->"\<\"Extend Selection\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Edit Menu" :> 
          Documentation`HelpLookup["paclet:guide/EditMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Edit Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Edit ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Check Balance"
}], "ObjectName",
 CellID->378826134],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Check Balance", "MenuName"],
     "\[LineSeparator]expands the selection to cover the nearest pair of \
matched bracketing characters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"CheckBalance",
 CellID->27870]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["Check Balance", "MenuName"],
 " selects nested expressions (for example, parenthesized) outward from the \
insertion point."
}], "Notes",
 CellID->92483910],

Cell[TextData[{
 "To select a nested expression, select anywhere within the expression by \
clicking. Choose ",
 StyleBox["Check Balance", "MenuName"],
 ", and click to expand the selection out to the next set of enclosed \
parentheses, brackets, or braces."
}], "Notes",
 CellTags->"CheckBalance",
 CellID->9601],

Cell[TextData[{
 "Each time you choose ",
 StyleBox["Check Balance", "MenuName"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expands the selection in both directions until it finds pairs of matching \
parentheses, brackets, or braces. Repeating the command expands the selection \
one level at a time."
}], "Notes",
 CellTags->"CheckBalance",
 CellID->21132],

Cell[TextData[{
 "You can use the ",
 StyleBox["Check Balance", "MenuName"],
 " command to check the structure of mathematical expressions. For example, \
if you have unbalanced parentheses or parentheses incorrectly balanced with \
brackets or braces, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " beeps. Choose ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Why the Beep?",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/WhyTheBeep"], "MenuName"],
 " to identify the mistake. If you position the insertion point inside a \
bracketed expression and choose ",
 StyleBox["Check Balance", "MenuName"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " should select the whole expression. If not, you have a missing bracket \
somewhere."
}], "Notes",
 CellTags->"CheckBalance",
 CellID->24472],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " cannot balance a selection that spans more than one cell."
}], "Notes",
 CellTags->"CheckBalance",
 CellID->27152],

Cell[TextData[{
 "Keyboard shortcuts: ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["B", "KeyEvent"],
 " (Windows); ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Cmd", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["B", "KeyEvent"],
 " (Macintosh); ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["B", "KeyEvent"],
 " (X)."
}], "Notes",
 AspectRatioFixed->False,
 CellTags->"CheckBalance",
 CellID->25087]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14423],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<Balance\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/Balance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Complete Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CompleteSelection"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Extend Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ExtendSelection"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->177433551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Edit Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EditMenu"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Edit > Check Balance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 3.4557696}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Check Balance expands the selection to cover the nearest pair of matched \
bracketing characters. ", "synonyms" -> {}, "title" -> "Edit > Check Balance",
     "type" -> "Menu Item", "uri" -> "ref/menuitem/CheckBalance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "CheckBalance"->{
  Cell[2198, 70, 403, 12, 70, "Usage",
   CellTags->"CheckBalance",
   CellID->27870],
  Cell[3302, 111, 313, 8, 70, "Notes",
   CellTags->"CheckBalance",
   CellID->9601],
  Cell[3618, 121, 374, 11, 70, "Notes",
   CellTags->"CheckBalance",
   CellID->21132],
  Cell[3995, 134, 956, 26, 70, "Notes",
   CellTags->"CheckBalance",
   CellID->24472],
  Cell[4954, 162, 182, 6, 70, "Notes",
   CellTags->"CheckBalance",
   CellID->27152],
  Cell[5139, 170, 661, 23, 70, "Notes",
   CellTags->"CheckBalance",
   CellID->25087]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"CheckBalance", 8379, 278}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1439, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2062, 63, 133, 5, 70, "ObjectName",
 CellID->378826134],
Cell[2198, 70, 403, 12, 70, "Usage",
 CellTags->"CheckBalance",
 CellID->27870]
}, Open  ]],
Cell[CellGroupData[{
Cell[2638, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3116, 104, 183, 5, 70, "Notes",
 CellID->92483910],
Cell[3302, 111, 313, 8, 70, "Notes",
 CellTags->"CheckBalance",
 CellID->9601],
Cell[3618, 121, 374, 11, 70, "Notes",
 CellTags->"CheckBalance",
 CellID->21132],
Cell[3995, 134, 956, 26, 70, "Notes",
 CellTags->"CheckBalance",
 CellID->24472],
Cell[4954, 162, 182, 6, 70, "Notes",
 CellTags->"CheckBalance",
 CellID->27152],
Cell[5139, 170, 661, 23, 70, "Notes",
 CellTags->"CheckBalance",
 CellID->25087]
}, Closed]],
Cell[CellGroupData[{
Cell[5837, 198, 311, 9, 70, "SeeAlsoSection",
 CellID->14423],
Cell[6151, 209, 709, 22, 70, "SeeAlso",
 CellID->177433551]
}, Open  ]],
Cell[CellGroupData[{
Cell[6897, 236, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[7219, 247, 109, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[7343, 252, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

