(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14214,        445]
NotebookOptionsPosition[      9949,        319]
NotebookOutlinePosition[     12650,        394]
CellTagsIndexPosition[     12533,        388]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialogs" :> 
          Documentation`HelpLookup["paclet:tutorial/Dialogs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialogs\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog" :> Documentation`HelpLookup["paclet:ref/Dialog"], 
          "\"EvaluatorInterrupt\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/EvaluatorInterrupt"], "Halt" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/Halt"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialog\"\>", 
       2->"\<\"\\\"EvaluatorInterrupt\\\"\"\>", 
       3->"\<\"Halt\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Evaluation Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Evaluation ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Interrupt Evaluation..."
}], "ObjectName",
 CellID->880900886],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Interrupt Evaluation", "MenuName"],
     "\[LineSeparator] interrupts the current operation being performed by \
the kernel."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->18516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A dialog box appears when you choose ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox["Interrupt Evaluation", "MenuName"],
 " during an evaluation. You can use this dialog box to abort an evaluation \
or to examine its progress. If you click ",
 StyleBox["Continue", "DialogElementName"],
 StyleBox[" Evaluation", "DialogElementName"],
 ", your evaluation completes normally."
}], "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->18298],

Cell[TextData[{
 "Keyboard shortcuts: ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " (Windows); ",
 StyleBox["Cmd", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " (Macintosh); ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox[",", "KeyEvent"],
 " (X)."
}], "Notes",
 AspectRatioFixed->False,
 CellTags->"EvaluatorInterrupt",
 CellID->39],

Cell[TextData[{
 "The following options in the ",
 StyleBox["Interrupt Evaluation", "DialogElementName"],
 " dialog may be chosen:"
}], "Notes",
 CellID->351558238],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Continue Evaluation", "DialogElementName"]], "TableText"], Cell[
    "resume evaluation", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Abort Command Being Evaluated", "DialogElementName"]], "TableText"], 
    Cell["abort the calculation", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Enter Subsession", "DialogElementName"]], "TableText"], Cell[
    "start kernel subsession within the interrupted calculation ", 
     "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->246894888],

Cell["\<\
Some calculations may not be immediately interruptible, in which case you do \
not get the dialog box until the calculation is able to stop. Sometimes when \
using a remote kernel you may not be able to interrupt short calculations at \
all, because they are finished before the interrupt request can be \
transmitted over the network.\
\>", "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->15020],

Cell["\<\
When you have more than one kernel running at the same time, for example, a \
local kernel and a remote kernel, this command applies only to the current \
kernel. You can have several interrupt dialog boxes visible at the same time, \
each labeled with the name of the corresponding kernel.\
\>", "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->6030],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is communicating with another program via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 ", the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " ",
 StyleBox["Control", "DialogElementName"],
 " options allow you to interrupt, abort, or kill the linked program."
}], "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->17442],

Cell[TextData[{
 "If ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Abort",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AbortEvaluation"], "MenuName"],
 " does not work, that is, if the calculation keeps running for more than a \
few seconds, you can choose ",
 StyleBox[ButtonBox["Evaluation",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EvaluationMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Quit Kernel",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/QuitKernel"], "MenuName"],
 ". If you do this, you will have to restart a kernel before you can evaluate \
anything else."
}], "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->21735]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10777],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<EvaluatorInterrupt\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/EvaluatorInterrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Halt",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Halt"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->11080952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32389],

Cell[TextData[ButtonBox["Dialogs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Dialogs"]], "Tutorials",
 CellID->32138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationMenu"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Evaluation > Interrupt Evaluation... - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 59.0353174}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Interrupt Evaluation interrupts the current operation being performed by \
the kernel.", "synonyms" -> {}, "title" -> 
    "Evaluation > Interrupt Evaluation...", "type" -> "Menu Item", "uri" -> 
    "ref/menuitem/InterruptEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "EvaluatorInterrupt"->{
  Cell[2712, 84, 421, 12, 70, "Usage",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->18516],
  Cell[3648, 118, 617, 14, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->18298],
  Cell[4268, 134, 455, 17, 70, "Notes",
   CellTags->"EvaluatorInterrupt",
   CellID->39],
  Cell[5739, 179, 432, 8, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->15020],
  Cell[6174, 189, 386, 7, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->6030],
  Cell[6563, 198, 428, 15, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->17442],
  Cell[6994, 215, 896, 22, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->21735]},
 "kernelInterruptID"->{
  Cell[2712, 84, 421, 12, 70, "Usage",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->18516],
  Cell[3648, 118, 617, 14, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->18298],
  Cell[5739, 179, 432, 8, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->15020],
  Cell[6174, 189, 386, 7, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->6030],
  Cell[6563, 198, 428, 15, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->17442],
  Cell[6994, 215, 896, 22, 70, "Notes",
   CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
   CellID->21735]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"EvaluatorInterrupt", 10997, 344},
 {"kernelInterruptID", 11811, 366}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1937, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2560, 77, 149, 5, 70, "ObjectName",
 CellID->880900886],
Cell[2712, 84, 421, 12, 70, "Usage",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->18516]
}, Open  ]],
Cell[CellGroupData[{
Cell[3170, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3648, 118, 617, 14, 70, "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->18298],
Cell[4268, 134, 455, 17, 70, "Notes",
 CellTags->"EvaluatorInterrupt",
 CellID->39],
Cell[4726, 153, 164, 5, 70, "Notes",
 CellID->351558238],
Cell[4893, 160, 843, 17, 70, "2ColumnTableMod",
 CellID->246894888],
Cell[5739, 179, 432, 8, 70, "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->15020],
Cell[6174, 189, 386, 7, 70, "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->6030],
Cell[6563, 198, 428, 15, 70, "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->17442],
Cell[6994, 215, 896, 22, 70, "Notes",
 CellTags->{"EvaluatorInterrupt", "kernelInterruptID"},
 CellID->21735]
}, Closed]],
Cell[CellGroupData[{
Cell[7927, 242, 311, 9, 70, "SeeAlsoSection",
 CellID->10777],
Cell[8241, 253, 707, 24, 70, "SeeAlso",
 CellID->11080952]
}, Open  ]],
Cell[CellGroupData[{
Cell[8985, 282, 314, 9, 70, "TutorialsSection",
 CellID->32389],
Cell[9302, 293, 125, 3, 70, "Tutorials",
 CellID->32138]
}, Open  ]],
Cell[CellGroupData[{
Cell[9464, 301, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[9786, 312, 121, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[9922, 317, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

