(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6380,        221]
NotebookOptionsPosition[      4122,        148]
NotebookOutlinePosition[      5643,        194]
CellTagsIndexPosition[      5561,        189]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"\"GraphicsOriginalSize\"" :> 
         Documentation`HelpLookup[
          "paclet:ref/frontendobject/GraphicsOriginalSize"], 
         "Rerender Graphics" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/RerenderGraphics"]}, #,
         2]& , Evaluator -> Automatic], {
      1->"\<\"\\\"GraphicsOriginalSize\\\"\"\>", 
      2->"\<\"Rerender Graphics\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Graphics ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Rendering \[FilledRightTriangle] Make Standard Size"
}], "ObjectName",
 CellID->409435393],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Make Standard Size", "MenuName"],
     "\[LineSeparator]restores selected graphics to the default size."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"GraphicsOriginalSize",
 CellID->4720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
For PICT, QuickTime, and bitmap graphics, the graphic itself defines its \
normal size (Macintosh only).\
\>", "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->9079],

Cell[TextData[{
 "For PostScript graphics, the standard size is determined by the aspect \
ratio defined within the graphic or by the ",
 StyleBox["BoundingBox", "InlineCode"],
 " PostScript comment, if present."
}], "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->32091],

Cell[TextData[{
 StyleBox["Make Standard Size", "MenuName"],
 " sets the option ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " on the selected cell objects."
}], "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->3766]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31159],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<GraphicsOriginalSize\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/GraphicsOriginalSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Rerender Graphics",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/RerenderGraphics"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->17518]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Graphics > Rendering > Make Standard Size - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 59.6134572}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Make Standard Size restores selected graphics to the default size.", 
    "synonyms" -> {}, "title" -> "Graphics > Rendering > Make Standard Size", 
    "type" -> "Menu Item", "uri" -> "ref/menuitem/MakeStandardSize"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "GraphicsOriginalSize"->{
  Cell[1583, 53, 378, 11, 70, "Usage",
   CellTags->"GraphicsOriginalSize",
   CellID->4720],
  Cell[2476, 86, 179, 5, 70, "Notes",
   CellTags->"GraphicsOriginalSize",
   CellID->9079],
  Cell[2658, 93, 276, 7, 70, "Notes",
   CellTags->"GraphicsOriginalSize",
   CellID->32091],
  Cell[2937, 102, 300, 10, 70, "Notes",
   CellTags->"GraphicsOriginalSize",
   CellID->3766]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"GraphicsOriginalSize", 5161, 173}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 782, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1405, 46, 175, 5, 70, "ObjectName",
 CellID->409435393],
Cell[1583, 53, 378, 11, 70, "Usage",
 CellTags->"GraphicsOriginalSize",
 CellID->4720]
}, Open  ]],
Cell[CellGroupData[{
Cell[1998, 69, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2476, 86, 179, 5, 70, "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->9079],
Cell[2658, 93, 276, 7, 70, "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->32091],
Cell[2937, 102, 300, 10, 70, "Notes",
 CellTags->"GraphicsOriginalSize",
 CellID->3766]
}, Closed]],
Cell[CellGroupData[{
Cell[3274, 117, 311, 9, 70, "SeeAlsoSection",
 CellID->31159],
Cell[3588, 128, 492, 15, 70, "SeeAlso",
 CellID->17518]
}, Open  ]],
Cell[4095, 146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

