(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11087,        372]
NotebookOptionsPosition[      8391,        283]
NotebookOutlinePosition[     10039,        334]
CellTagsIndexPosition[      9960,        329]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complete Selection " :> 
          Documentation`HelpLookup["paclet:ref/menuitem/CompleteSelection"], 
          " " :> Documentation`HelpLookup[
           "paclet:ref/menuitem/CompleteSelection"], "\"TemplateSelection\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/TemplateSelection"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Complete Selection \"\>", 
       2->"\<\" \"\>", 
       3->"\<\"\\\"TemplateSelection\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Edit Menu" :> 
          Documentation`HelpLookup["paclet:guide/EditMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Edit Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Edit ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Make Template"
}], "ObjectName",
 CellID->128745424],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Make Template", "MenuName"],
     "\[LineSeparator]inserts a template based on a selected function name. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"TemplateSelection",
 CellID->7952]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This command reads your current selection, which should be a function name \
or an insertion point after a function name, and adds a template for the \
arguments it can take. For example, if your selection is ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ", you get ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plot"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ", which shows the simplest form of the ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " function. "
}], "Notes",
 CellTags->"TemplateSelection",
 CellID->9846],

Cell[TextData[{
 "You can only get function templates when you are connected to a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. To define a function template for a user-defined function, make \
the template the first statement in the usage message for the function. For \
example, to define the template ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 " for the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", you could use the following command: ",
 StyleBox["f::usage=\"f[a,b] is an example of a function\"", "InlineCode"],
 "."
}], "Notes",
 CellTags->"TemplateSelection",
 CellID->27137],

Cell[TextData[{
 "The templates you get for built-in functions are usually only one of \
several possible argument forms. Use the kernel command ",
 StyleBox["?", "MR",
  FontFamily->"Courier"],
 " to get more information, or refer to the function's complete description \
in ",
 StyleBox[ButtonBox["Help",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/HelpMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Documentation Center",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/DocumentationCenter"], "MenuName"],
 "."
}], "Notes",
 CellTags->"TemplateSelection",
 CellID->5915],

Cell[TextData[{
 "When you choose ",
 StyleBox["Make Template", "MenuName"],
 " after typing a partial word, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " looks to the left of the insertion point to find a suitable function or \
variable name. When this name is not a currently defined function, ",
 StyleBox["Make Template", "MenuName"],
 StyleBox[" ",
  FontWeight->"Bold"],
 "applies ",
 StyleBox[ButtonBox["Edit",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/EditMenu"], "MenuName"],
 StyleBox[" \[FilledRightTriangle] ", "MenuNameDelimiter"],
 StyleBox[ButtonBox["Complete Selection",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CompleteSelection"], "MenuName"],
 " before attempting to make a template."
}], "Notes",
 CellTags->"TemplateSelection",
 CellID->22988],

Cell[TextData[{
 "Keyboard shortcuts: ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " (Windows); ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Cmd", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " (Macintosh); ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["K", "KeyEvent"],
 " (X)."
}], "Notes",
 AspectRatioFixed->False,
 CellTags->"TemplateSelection",
 CellID->24616]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3915],

Cell[TextData[{
 StyleBox[ButtonBox["Complete Selection ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CompleteSelection"], "MenuName",
  FontFamily->"Verdana"],
 "\[EmptyVerySmallSquare]",
 StyleBox[ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/CompleteSelection"], "MenuName",
  FontFamily->"Verdana"],
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<TemplateSelection\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/TemplateSelection"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Edit Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EditMenu"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Edit > Make Template - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 54, 59.7540858}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Make Template inserts a template based on a selected function name. ", 
    "synonyms" -> {}, "title" -> "Edit > Make Template", "type" -> 
    "Menu Item", "uri" -> "ref/menuitem/MakeTemplate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TemplateSelection"->{
  Cell[2203, 70, 377, 11, 70, "Usage",
   CellTags->"TemplateSelection",
   CellID->7952],
  Cell[3095, 103, 1008, 33, 70, "Notes",
   CellTags->"TemplateSelection",
   CellID->9846],
  Cell[4106, 138, 741, 21, 70, "Notes",
   CellTags->"TemplateSelection",
   CellID->27137],
  Cell[4850, 161, 641, 17, 70, "Notes",
   CellTags->"TemplateSelection",
   CellID->5915],
  Cell[5494, 180, 795, 22, 70, "Notes",
   CellTags->"TemplateSelection",
   CellID->22988],
  Cell[6292, 204, 666, 23, 70, "Notes",
   CellTags->"TemplateSelection",
   CellID->24616]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TemplateSelection", 9381, 307}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1444, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2067, 63, 133, 5, 70, "ObjectName",
 CellID->128745424],
Cell[2203, 70, 377, 11, 70, "Usage",
 CellTags->"TemplateSelection",
 CellID->7952]
}, Open  ]],
Cell[CellGroupData[{
Cell[2617, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3095, 103, 1008, 33, 70, "Notes",
 CellTags->"TemplateSelection",
 CellID->9846],
Cell[4106, 138, 741, 21, 70, "Notes",
 CellTags->"TemplateSelection",
 CellID->27137],
Cell[4850, 161, 641, 17, 70, "Notes",
 CellTags->"TemplateSelection",
 CellID->5915],
Cell[5494, 180, 795, 22, 70, "Notes",
 CellTags->"TemplateSelection",
 CellID->22988],
Cell[6292, 204, 666, 23, 70, "Notes",
 CellTags->"TemplateSelection",
 CellID->24616]
}, Closed]],
Cell[CellGroupData[{
Cell[6995, 232, 310, 9, 70, "SeeAlsoSection",
 CellID->3915],
Cell[7308, 243, 573, 17, 70, "SeeAlso",
 CellID->11056]
}, Open  ]],
Cell[CellGroupData[{
Cell[7918, 265, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[8240, 276, 109, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[8364, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

