(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7507,        242]
NotebookOptionsPosition[      5508,        178]
NotebookOutlinePosition[      6793,        216]
CellTagsIndexPosition[      6713,        211]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Print" :> Documentation`HelpLookup["paclet:ref/menuitem/Print"],
          "\"PrintOptionsDialog\"" :> 
         Documentation`HelpLookup[
          "paclet:ref/frontendobject/PrintOptionsDialog"], 
         "Printing Settings" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/PrintingSettings"]}, #,
         2]& , Evaluator -> Automatic], {1->"\<\"Print\"\>", 
      2->"\<\"\\\"PrintOptionsDialog\\\"\"\>", 
      3->"\<\"Printing Settings\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "File ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Printing Settings ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Printing Options..."
}], "ObjectName",
 CellID->185794521],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Printing Options", "MenuName"],
     "\[LineSeparator]sets options for printing a notebook. ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " saves these settings with the notebook."
    }]]}
  }]], "Usage",
 AspectRatioFixed->False,
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"PrintOptionsDialog",
 CellID->22488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings may be specified via the ",
 StyleBox["Printing Options", "DialogElementName"],
 " dialog: "
}], "Notes",
 CellID->514687812],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Print cell brackets", "DialogElementName"]], "TableText"], Cell[
    "print cell brackets", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Print registration marks", "DialogElementName"]], "TableText"], Cell[
    "indicate printed page corners with trim marks", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Print multiple pages for wide cells", "DialogElementName"]], 
     "TableText"], Cell[
    "print the necessary pages to show wide cells", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[StyleBox[
    "Margins in Inches", "DialogElementName"]], "TableText"], Cell[
    "determine white space on page after printing ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->41602715],

Cell[TextData[{
 "Trim marks are useful for visualizing how a notebook would look when \
printed on paper of a particular size. You can simulate a smaller page size \
by changing the value of the option ",
 Cell[BoxData["\"\<PageSize\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->11133980],

Cell["\<\
Text that is set to word wrap will wrap to the printing margin width, not the \
window width. \
\>", "Notes",
 CellID->1947721]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6766],

Cell[TextData[{
 StyleBox[ButtonBox["Print",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/Print"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<PrintOptionsDialog\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/PrintOptionsDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Printing Settings",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PrintingSettings"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->491757277]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"File > Printing Settings > Printing Options... - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 55, 23.5359446}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Printing Options sets options for printing a notebook. Mathematica saves \
these settings with the notebook.", "synonyms" -> {}, "title" -> 
    "File > Printing Settings > Printing Options...", "type" -> "Menu Item", 
    "uri" -> "ref/menuitem/PrintingOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrintOptionsDialog"->{
  Cell[1713, 56, 498, 15, 70, "Usage",
   CellTags->"PrintOptionsDialog",
   CellID->22488]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrintOptionsDialog", 6596, 204}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 872, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1495, 47, 215, 7, 70, "ObjectName",
 CellID->185794521],
Cell[1713, 56, 498, 15, 70, "Usage",
 CellTags->"PrintOptionsDialog",
 CellID->22488]
}, Open  ]],
Cell[CellGroupData[{
Cell[2248, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2726, 93, 166, 5, 70, "Notes",
 CellID->514687812],
Cell[2895, 100, 1075, 20, 70, "2ColumnTableMod",
 CellID->41602715],
Cell[3973, 122, 295, 7, 70, "Notes",
 CellID->11133980],
Cell[4271, 131, 137, 4, 70, "Notes",
 CellID->1947721]
}, Closed]],
Cell[CellGroupData[{
Cell[4445, 140, 310, 9, 70, "SeeAlsoSection",
 CellID->6766],
Cell[4758, 151, 708, 22, 70, "SeeAlso",
 CellID->491757277]
}, Open  ]],
Cell[5481, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

