(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7876,        268]
NotebookOptionsPosition[      5647,        194]
NotebookOutlinePosition[      7051,        238]
CellTagsIndexPosition[      6975,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Page Break" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/PageBreak"], 
          "\"ShowPageBreaks\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/ShowPageBreaks"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Page Break\"\>", 
       2->"\<\"\\\"ShowPageBreaks\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Page Layout & Printing Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PageLayoutAndPrintingControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Notebook Formatting & Styling\"\>", 
       2->"\<\"Page Layout & Printing Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "File ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Printing Settings ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Show Page Breaks"
}], "ObjectName",
 CellID->292654606],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Show Page Breaks", "MenuName"],
     "\[LineSeparator]calculates and displays page breaks on screen."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"ShowPageBreaks",
 CellID->13310]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "This command toggles the option ",
 Cell[BoxData[
  ButtonBox["ShowPageBreaks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ShowPageBreaks"]], "InlineFormula"],
 " between ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " on the selected notebook."
}], "Notes",
 TextJustification->0,
 CellTags->"ShowPageBreaks",
 CellID->27578],

Cell["\<\
Page breaks that fall between cells are shown with a dashed line across the \
entire width of the window. Page breaks that fall inside a cell are shown by \
a dashed line over the width of the cell bracket.\
\>", "Notes",
 TextJustification->0,
 CellTags->"ShowPageBreaks",
 CellID->3671]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24247],

Cell[TextData[{
 StyleBox[ButtonBox["Page Break",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/PageBreak"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<ShowPageBreaks\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/ShowPageBreaks"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->287428471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout"],

Cell[TextData[ButtonBox["Page Layout & Printing Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PageLayoutAndPrintingControl"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"File > Printing Settings > Show Page Breaks - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 55, 46.3802794}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Show Page Breaks calculates and displays page breaks on screen.", 
    "synonyms" -> {}, "title" -> 
    "File > Printing Settings > Show Page Breaks", "type" -> "Menu Item", 
    "uri" -> "ref/menuitem/ShowPageBreaks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "ShowPageBreaks"->{
  Cell[2395, 74, 370, 11, 70, "Usage",
   CellTags->"ShowPageBreaks",
   CellID->13310],
  Cell[3280, 107, 542, 20, 70, "Notes",
   CellTags->"ShowPageBreaks",
   CellID->27578],
  Cell[3825, 129, 298, 7, 70, "Notes",
   CellTags->"ShowPageBreaks",
   CellID->3671]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"ShowPageBreaks", 6684, 220}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1557, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2180, 65, 212, 7, 70, "ObjectName",
 CellID->292654606],
Cell[2395, 74, 370, 11, 70, "Usage",
 CellTags->"ShowPageBreaks",
 CellID->13310]
}, Open  ]],
Cell[CellGroupData[{
Cell[2802, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3280, 107, 542, 20, 70, "Notes",
 CellTags->"ShowPageBreaks",
 CellID->27578],
Cell[3825, 129, 298, 7, 70, "Notes",
 CellTags->"ShowPageBreaks",
 CellID->3671]
}, Closed]],
Cell[CellGroupData[{
Cell[4160, 141, 311, 9, 70, "SeeAlsoSection",
 CellID->24247],
Cell[4474, 152, 470, 15, 70, "SeeAlso",
 CellID->287428471]
}, Open  ]],
Cell[CellGroupData[{
Cell[4981, 172, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[5303, 183, 149, 2, 70, "MoreAbout"],
Cell[5455, 187, 150, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[5620, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

