(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9411,        312]
NotebookOptionsPosition[      6813,        226]
NotebookOutlinePosition[      8298,        273]
CellTagsIndexPosition[      8222,        268]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Edit Stylesheet" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/EditStylesheet"], 
          "Option Inspector " :> 
          Documentation`HelpLookup["paclet:ref/menuitem/OptionInspector"], 
          "\"StyleOther\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/StyleOther"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Edit Stylesheet\"\>", 
       2->"\<\"Option Inspector \"\>", 
       3->"\<\"\\\"StyleOther\\\"\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Format Menu" :> 
          Documentation`HelpLookup["paclet:guide/FormatMenu"], "Menu Items" :> 
          Documentation`HelpLookup["paclet:guide/MenuItems"], 
          "Notebook Basics" :> 
          Documentation`HelpLookup["paclet:guide/NotebookBasics"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 
       2->"\<\"Format Menu\"\>", 3->"\<\"Menu Items\"\>", 
       4->"\<\"Notebook Basics\"\>", 
       5->"\<\"Notebook Formatting & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Format ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Style"
}], "ObjectName",
 CellID->429893206],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Style", "MenuName"],
     "\[LineSeparator]assigns a style to selected cells or text."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"MenuListStyles",
 CellID->898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "To assign a style to one or more cells, select the cells and then choose \
the desired style name from the ",
 StyleBox["Style", "MenuName"],
 " submenu."
}], "Notes",
 CellTags->"MenuListStyles",
 CellID->19792],

Cell[TextData[{
 "The cell styles listed in the ",
 StyleBox["Style", "MenuName"],
 " submenu are defined in the stylesheet assigned to your current notebook.",
 StyleBox[" Mathematica",
  FontSlant->"Italic"],
 " assigns a default stylesheet called Default to new notebooks. "
}], "Notes",
 CellTags->"MenuListStyles",
 CellID->15221],

Cell["\<\
Styles can also be assigned to individual words or characters.\
\>", "Notes",
 CellTags->"MenuListStyles",
 CellID->18697],

Cell[TextData[{
 "The ",
 StyleBox["Other", "DialogElementName"],
 " dialog box lets you type in a style name to be assigned to the selected \
cell or text. Not all styles defined in a stylesheet need to be listed in the \
",
 StyleBox["Style", "MenuName"],
 " menu. You can also assign cell options by typing the option setting in \
this dialog box. "
}], "Notes",
 CellTags->"MenuListStyles",
 CellID->813]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4816],

Cell[TextData[{
 StyleBox[ButtonBox["Edit Stylesheet",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/EditStylesheet"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Option Inspector ",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/OptionInspector"], "MenuName",
  FontFamily->"Verdana"],
 "\[EmptyVerySmallSquare] ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<StyleOther\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/StyleOther"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->419758193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout"],

Cell[TextData[ButtonBox["Format Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormatMenu"]], "MoreAbout"],

Cell[TextData[ButtonBox["Menu Items",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MenuItems"]], "MoreAbout"],

Cell[TextData[ButtonBox["Notebook Basics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookBasics"]], "MoreAbout"],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Format > Style - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 55, 55.0680018}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Style assigns a style to selected cells or text.", 
    "synonyms" -> {}, "title" -> "Format > Style", "type" -> "Menu Item", 
    "uri" -> "ref/menuitem/Style"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "MenuListStyles"->{
  Cell[2789, 81, 353, 11, 70, "Usage",
   CellTags->"MenuListStyles",
   CellID->898],
  Cell[3657, 114, 230, 7, 70, "Notes",
   CellTags->"MenuListStyles",
   CellID->19792],
  Cell[3890, 123, 335, 9, 70, "Notes",
   CellTags->"MenuListStyles",
   CellID->15221],
  Cell[4228, 134, 132, 4, 70, "Notes",
   CellTags->"MenuListStyles",
   CellID->18697],
  Cell[4363, 140, 408, 11, 70, "Notes",
   CellTags->"MenuListStyles",
   CellID->813]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"MenuListStyles", 7756, 249}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2036, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2659, 74, 127, 5, 70, "ObjectName",
 CellID->429893206],
Cell[2789, 81, 353, 11, 70, "Usage",
 CellTags->"MenuListStyles",
 CellID->898]
}, Open  ]],
Cell[CellGroupData[{
Cell[3179, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3657, 114, 230, 7, 70, "Notes",
 CellTags->"MenuListStyles",
 CellID->19792],
Cell[3890, 123, 335, 9, 70, "Notes",
 CellTags->"MenuListStyles",
 CellID->15221],
Cell[4228, 134, 132, 4, 70, "Notes",
 CellTags->"MenuListStyles",
 CellID->18697],
Cell[4363, 140, 408, 11, 70, "Notes",
 CellTags->"MenuListStyles",
 CellID->813]
}, Closed]],
Cell[CellGroupData[{
Cell[4808, 156, 310, 9, 70, "SeeAlsoSection",
 CellID->4816],
Cell[5121, 167, 655, 20, 70, "SeeAlso",
 CellID->419758193]
}, Open  ]],
Cell[CellGroupData[{
Cell[5813, 192, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[6135, 203, 130, 2, 70, "MoreAbout"],
Cell[6268, 207, 113, 2, 70, "MoreAbout"],
Cell[6384, 211, 111, 2, 70, "MoreAbout"],
Cell[6498, 215, 121, 2, 70, "MoreAbout"],
Cell[6622, 219, 149, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[6786, 224, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

