(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6956,        236]
NotebookOptionsPosition[      4931,        170]
NotebookOutlinePosition[      6256,        210]
CellTagsIndexPosition[      6179,        205]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stack Windows" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/StackWindows"], 
          "\"TileWindowsWide\"" :> 
          Documentation`HelpLookup[
           "paclet:ref/frontendobject/TileWindowsWide"], "Tile Windows Tall" :> 
          Documentation`HelpLookup["paclet:ref/menuitem/TileWindowsTall"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Stack Windows\"\>", 
       2->"\<\"\\\"TileWindowsWide\\\"\"\>", 
       3->"\<\"Tile Windows Tall\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Menu" :> 
          Documentation`HelpLookup["paclet:guide/WindowMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Window Menu\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Window ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Tile Windows Wide"
}], "ObjectName",
 CellID->20758379],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Tile Windows Wide", "MenuName"],
     "\[LineSeparator]arranges all windows to fit in the screen one above the \
other (Windows and Macintosh only)."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"TileWindowsWide",
 CellID->4000]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
With a large number of windows, there is some overlapping since windows \
cannot be made smaller than a certain minimum size.\
\>", "Notes",
 CellTags->"TileWindowsWide",
 CellID->22332]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20895],

Cell[TextData[{
 StyleBox[ButtonBox["Stack Windows",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/StackWindows"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["\"\<TileWindowsWide\>\"",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/frontendobject/TileWindowsWide"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 StyleBox[ButtonBox["Tile Windows Tall",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/TileWindowsTall"], "MenuName",
  FontFamily->"Verdana"]
}], "SeeAlso",
 CellID->265006366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->305956821],

Cell[TextData[ButtonBox["Window Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowMenu"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Window > Tile Windows Wide - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 2.7869494}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Tile Windows Wide arranges all windows to fit in the screen one above \
the other (Windows and Macintosh only).", "synonyms" -> {}, "title" -> 
    "Window > Tile Windows Wide", "type" -> "Menu Item", "uri" -> 
    "ref/menuitem/TileWindowsWide"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "TileWindowsWide"->{
  Cell[2221, 70, 418, 12, 70, "Usage",
   CellTags->"TileWindowsWide",
   CellID->4000],
  Cell[3154, 104, 196, 5, 70, "Notes",
   CellTags->"TileWindowsWide",
   CellID->22332]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"TileWindowsWide", 5976, 195}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1457, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2080, 63, 138, 5, 70, "ObjectName",
 CellID->20758379],
Cell[2221, 70, 418, 12, 70, "Usage",
 CellTags->"TileWindowsWide",
 CellID->4000]
}, Open  ]],
Cell[CellGroupData[{
Cell[2676, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3154, 104, 196, 5, 70, "Notes",
 CellTags->"TileWindowsWide",
 CellID->22332]
}, Closed]],
Cell[CellGroupData[{
Cell[3387, 114, 311, 9, 70, "SeeAlsoSection",
 CellID->20895],
Cell[3701, 125, 716, 22, 70, "SeeAlso",
 CellID->265006366]
}, Open  ]],
Cell[CellGroupData[{
Cell[4454, 152, 319, 9, 70, "MoreAboutSection",
 CellID->305956821],
Cell[4776, 163, 113, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[4904, 168, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

