(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5547,        197]
NotebookOptionsPosition[      3472,        129]
NotebookOutlinePosition[      4913,        173]
CellTagsIndexPosition[      4837,        168]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MENU ITEM", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Wrap at Window Width" :> 
         Documentation`HelpLookup[
          "paclet:ref/menuitem/WrapAtWindowWidth"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Wrap at Window Width\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Format ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Word Wrapping ",
 StyleBox["\[FilledRightTriangle]", "MenuPointer"],
 " Wrap at Paper Width"
}], "ObjectName",
 CellID->680112329],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     StyleBox["Wrap at Paper Width", "MenuName"],
     "\[LineSeparator]wraps lines at the width of the paper currently \
specified by the print settings."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellTags->"PageWidthPaper",
 CellID->10341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["Wrap at Paper Width", "MenuName"],
 " sets the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"], "->", "PaperWidth"}]], 
  "InlineFormula"],
 " on the selected cell object(s)."
}], "Notes",
 CellTags->"PageWidthPaper",
 CellID->30634],

Cell["\<\
This setting is normally used in the Printout printing environment to make \
text fit the printed page.\
\>", "Notes",
 CellTags->"PageWidthPaper",
 CellID->17049]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->869],

Cell[TextData[StyleBox[ButtonBox["Wrap at Window Width",
 BaseStyle->"Link",
 ButtonData->"paclet:ref/menuitem/WrapAtWindowWidth"], "MenuName",
 FontFamily->"Verdana"]], "SeeAlso",
 CellID->264610771]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Format > Word Wrapping > Wrap at Paper Width - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 11.2090400}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Menu Item", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Wrap at Paper Width wraps lines at the width of the paper currently \
specified by the print settings.", "synonyms" -> {}, "title" -> 
    "Format > Word Wrapping > Wrap at Paper Width", "type" -> "Menu Item", 
    "uri" -> "ref/menuitem/WrapAtPaperWidth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PageWidthPaper"->{
  Cell[1444, 51, 409, 12, 70, "Usage",
   CellTags->"PageWidthPaper",
   CellID->10341],
  Cell[2368, 85, 337, 12, 70, "Notes",
   CellTags->"PageWidthPaper",
   CellID->30634],
  Cell[2708, 99, 173, 5, 70, "Notes",
   CellTags->"PageWidthPaper",
   CellID->17049]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PageWidthPaper", 4547, 155}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 605, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1228, 42, 213, 7, 70, "ObjectName",
 CellID->680112329],
Cell[1444, 51, 409, 12, 70, "Usage",
 CellTags->"PageWidthPaper",
 CellID->10341]
}, Open  ]],
Cell[CellGroupData[{
Cell[1890, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2368, 85, 337, 12, 70, "Notes",
 CellTags->"PageWidthPaper",
 CellID->30634],
Cell[2708, 99, 173, 5, 70, "Notes",
 CellTags->"PageWidthPaper",
 CellID->17049]
}, Closed]],
Cell[CellGroupData[{
Cell[2918, 109, 309, 9, 70, "SeeAlsoSection",
 CellID->869],
Cell[3230, 120, 200, 4, 70, "SeeAlso",
 CellID->264610771]
}, Open  ]],
Cell[3445, 127, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

