(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15059,        463]
NotebookOptionsPosition[      6347,        234]
NotebookOutlinePosition[     13206,        406]
CellTagsIndexPosition[     12927,        396]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
AccountingForm::expint
EngineeringForm::expint
NumberForm::expint
PaddedForm::expint
ScientificForm::expint\
\>", "ObjectName",
 CellID->14510],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"expint\"\>"}], ":", 
  " ", "\<\"Result `1` obtained by applying the value of the ExponentFunction \
option to `2` should be an integer or Null.\"\>"}]], "Message", "MSG",
 CellID->118773838],

Cell[TextData[{
 "Generated when the value of the ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " option does not give the expected result."
}], "Notes",
 CellID->32012],

Cell[TextData[{
 "When formatting an inexact number, the value of the ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " option is applied to the exponent that would be used to format the number \
in scientific notation."
}], "Notes",
 CellID->7845],

Cell[TextData[{
 "The value of the ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " option should be a function that takes an integer argument and that \
returns an integer or ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ".",
 " ",
 "A return value of ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " causes no exponent to be displayed."
}], "Notes",
 CellID->31308]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128445396],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->118460113],

Cell[TextData[{
 "This input generates a warning message because ",
 StyleBox["Null[", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " evaluates to itself, rather than to an integer or to ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->131709226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"0.000000001234", ",", 
   RowBox[{"ExponentFunction", "->", "Null"}]}], "]"}]], "Input",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellLabel->"In[1]:=",
 CellID->1405],

Cell[BoxData[
 RowBox[{
  RowBox[{"NumberForm", "::", "\<\"expint\"\>"}], ":", 
  " ", "\<\"Result \\!\\(Null[\\\"-9\\\"]\\) obtained by applying the value \
of the ExponentFunction option to \\!\\(\\\"-9\\\"\\) should be an integer or \
Null.\"\>"}]], "Message", "MSG",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->507076781],

Cell[BoxData[
 TagBox[
  InterpretationBox[
   RowBox[{"\<\"1.234\"\>", "\[Times]", 
    SuperscriptBox["10", "\<\"-9\"\>"]}],
   1.234*^-9,
   AutoDelete->True],
  NumberForm[#, ExponentFunction -> Null]& ]], "Output",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellLabel->"Out[1]//NumberForm=",
 CellID->150034251]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of the ",
 Cell[BoxData[
  ButtonBox["ExponentFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentFunction"]], "InlineFormula"],
 " option.",
 " ",
 "The pure function ",
 StyleBox["Null&", "MR"],
 " applied to any argument will return ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", which causes numbers to be displayed without exponents."
}], "ExampleText",
 CellID->6455312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{"0.000000001234", ",", " ", 
   RowBox[{"ExponentFunction", " ", "->", 
    RowBox[{"(", 
     RowBox[{"Null", " ", "&"}], ")"}]}]}], "]"}]], "Input",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellLabel->"In[2]:=",
 CellID->20145],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"0.000000001234\"\>",
   1.234*^-9,
   AutoDelete->True],
  NumberForm[#, ExponentFunction -> (Null& )]& ]], "Output",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellLabel->"Out[2]//NumberForm=",
 CellID->598887576]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AccountingForm::expint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 18.5686034}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "AccountingForm::expint EngineeringForm::expint NumberForm::expint \
PaddedForm::expint ScientificForm::expint", "synonyms" -> {}, "title" -> 
    "AccountingForm::expint", "type" -> "Message", "uri" -> 
    "ref/message/expint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2870, 110, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->128445396]},
 "AccountingForm::expint"->{
  Cell[3805, 148, 323, 8, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->1405],
  Cell[4131, 158, 433, 9, 70, "Message",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->507076781],
  Cell[4567, 169, 417, 12, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->150034251],
  Cell[5530, 205, 385, 10, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->20145],
  Cell[5918, 217, 363, 10, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->598887576]},
 "EngineeringForm::expint"->{
  Cell[3805, 148, 323, 8, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->1405],
  Cell[4131, 158, 433, 9, 70, "Message",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->507076781],
  Cell[4567, 169, 417, 12, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->150034251],
  Cell[5530, 205, 385, 10, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->20145],
  Cell[5918, 217, 363, 10, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->598887576]},
 "NumberForm::expint"->{
  Cell[3805, 148, 323, 8, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->1405],
  Cell[4131, 158, 433, 9, 70, "Message",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->507076781],
  Cell[4567, 169, 417, 12, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->150034251],
  Cell[5530, 205, 385, 10, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->20145],
  Cell[5918, 217, 363, 10, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->598887576]},
 "PaddedForm::expint"->{
  Cell[3805, 148, 323, 8, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->1405],
  Cell[4131, 158, 433, 9, 70, "Message",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->507076781],
  Cell[4567, 169, 417, 12, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->150034251],
  Cell[5530, 205, 385, 10, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->20145],
  Cell[5918, 217, 363, 10, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->598887576]},
 "ScientificForm::expint"->{
  Cell[3805, 148, 323, 8, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->1405],
  Cell[4131, 158, 433, 9, 70, "Message",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->507076781],
  Cell[4567, 169, 417, 12, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->150034251],
  Cell[5530, 205, 385, 10, 70, "Input",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->20145],
  Cell[5918, 217, 363, 10, 70, "Output",
   CellTags->{
    "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint",
      "PaddedForm::expint", "ScientificForm::expint"},
   CellID->598887576]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7376, 259},
 {"AccountingForm::expint", 7525, 263},
 {"EngineeringForm::expint", 8609, 289},
 {"NumberForm::expint", 9688, 315},
 {"PaddedForm::expint", 10767, 341},
 {"ScientificForm::expint", 11850, 367}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 153, 7, 70, "ObjectName",
 CellID->14510],
Cell[CellGroupData[{
Cell[881, 38, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1359, 55, 268, 6, 70, "Message",
 CellID->118773838],
Cell[1630, 63, 262, 8, 70, "Notes",
 CellID->32012],
Cell[1895, 73, 339, 9, 70, "Notes",
 CellID->7845],
Cell[2237, 84, 596, 21, 70, "Notes",
 CellID->31308]
}, Closed]],
Cell[CellGroupData[{
Cell[2870, 110, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->128445396],
Cell[CellGroupData[{
Cell[3255, 124, 148, 5, 70, "ExampleSection",
 CellID->118460113],
Cell[3406, 131, 374, 13, 70, "ExampleText",
 CellID->131709226],
Cell[CellGroupData[{
Cell[3805, 148, 323, 8, 70, "Input",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->1405],
Cell[4131, 158, 433, 9, 70, "Message",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->507076781],
Cell[4567, 169, 417, 12, 70, "Output",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->150034251]
}, Open  ]],
Cell[4999, 184, 506, 17, 70, "ExampleText",
 CellID->6455312],
Cell[CellGroupData[{
Cell[5530, 205, 385, 10, 70, "Input",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->20145],
Cell[5918, 217, 363, 10, 70, "Output",
 CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
   "PaddedForm::expint", "ScientificForm::expint"},
 CellID->598887576]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6320, 232, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

