(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15003,        474]
NotebookOptionsPosition[      6626,        245]
NotebookOutlinePosition[     13199,        417]
CellTagsIndexPosition[     12930,        407]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
AccountingForm::iprf
EngineeringForm::iprf
NumberForm::iprf
PaddedForm::iprf
ScientificForm::iprf\
\>", "ObjectName",
 CellID->32579],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"iprf\"\>"}], ":", 
  " ", "\<\"Formatting specification `1` should be a positive integer or a \
pair of positive integers.\"\>"}]], "Message", "MSG",
 CellID->171457527],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EngineeringForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EngineeringForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NumberForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 " does not have the expected form."
}], "Notes",
 CellID->9349],

Cell["\<\
The formatting specification is the second argument in these functions. \
\>", "Notes",
 CellID->20031],

Cell["\<\
The formatting specification is expected to be a positive integer indicating \
the number of digits to display, or a pair of positive integers indicating \
the total number of digits and the number of digits to the right of the \
decimal point.\
\>", "Notes",
 CellID->10434]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284174187],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->122674450],

Cell[TextData[{
 "This input generates an error because ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " is not a valid format specification in ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->737978798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"ColumnForm", "[", 
    RowBox[{"{", 
     RowBox[{"17.4", ",", " ", "22.9", ",", " ", "0.031", ",", " ", "207.0"}],
      "}"}], "]"}], ",", " ", "All"}], "]"}]], "Input",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellLabel->"In[1]:=",
 CellID->19328],

Cell[BoxData[
 RowBox[{
  RowBox[{"PaddedForm", "::", "\<\"iprf\"\>"}], ":", 
  " ", "\<\"Formatting specification \\!\\(All\\) should be a positive \
integer or a pair of positive integers.\"\>"}]], "Message", "MSG",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->527509787],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {"\<\" 17.4\"\>"},
     {"\<\" 22.9\"\>"},
     {"\<\" 0.031\"\>"},
     {"\<\" 207.\"\>"}
    },
    BaselinePosition->{Baseline, {1, 1}},
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   ColumnForm[{17.4, 22.9, 0.031, 207.}],
   Editable->False],
  PaddedForm[#, All]& ]], "Output",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellLabel->"Out[1]//PaddedForm=",
 CellID->630152172]
}, Open  ]],

Cell[TextData[{
 "This shows a correct use of a formatting specification in ",
 Cell[BoxData[
  ButtonBox["PaddedForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaddedForm"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->363636645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"ColumnForm", "[", 
    RowBox[{"{", 
     RowBox[{"17.4", ",", " ", "22.9", ",", " ", "0.031", ",", " ", "207.0"}],
      "}"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"9", ",", " ", "6"}], "}"}]}], "]"}]], "Input",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellLabel->"In[2]:=",
 CellID->4322],

Cell[BoxData[
 TagBox[
  InterpretationBox[GridBox[{
     {"\<\"  17.400000\"\>"},
     {"\<\"  22.900000\"\>"},
     {"\<\"   0.031000\"\>"},
     {"\<\" 207.000000\"\>"}
    },
    BaselinePosition->{Baseline, {1, 1}},
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}}],
   ColumnForm[{17.4, 22.9, 0.031, 207.}],
   Editable->False],
  PaddedForm[#, {9, 6}]& ]], "Output",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellLabel->"Out[2]//PaddedForm=",
 CellID->18930022]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AccountingForm::iprf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 18.7092320}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "AccountingForm::iprf EngineeringForm::iprf NumberForm::iprf \
PaddedForm::iprf ScientificForm::iprf", "synonyms" -> {}, "title" -> 
    "AccountingForm::iprf", "type" -> "Message", "uri" -> 
    "ref/message/iprf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2834, 109, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->284174187]},
 "AccountingForm::iprf"->{
  Cell[3774, 147, 409, 11, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->19328],
  Cell[4186, 160, 370, 8, 70, "Message",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->527509787],
  Cell[4559, 170, 614, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->630152172],
  Cell[5458, 204, 460, 13, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->4322],
  Cell[5921, 219, 639, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->18930022]},
 "EngineeringForm::iprf"->{
  Cell[3774, 147, 409, 11, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->19328],
  Cell[4186, 160, 370, 8, 70, "Message",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->527509787],
  Cell[4559, 170, 614, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->630152172],
  Cell[5458, 204, 460, 13, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->4322],
  Cell[5921, 219, 639, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->18930022]},
 "NumberForm::iprf"->{
  Cell[3774, 147, 409, 11, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->19328],
  Cell[4186, 160, 370, 8, 70, "Message",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->527509787],
  Cell[4559, 170, 614, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->630152172],
  Cell[5458, 204, 460, 13, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->4322],
  Cell[5921, 219, 639, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->18930022]},
 "PaddedForm::iprf"->{
  Cell[3774, 147, 409, 11, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->19328],
  Cell[4186, 160, 370, 8, 70, "Message",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->527509787],
  Cell[4559, 170, 614, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->630152172],
  Cell[5458, 204, 460, 13, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->4322],
  Cell[5921, 219, 639, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->18930022]},
 "ScientificForm::iprf"->{
  Cell[3774, 147, 409, 11, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->19328],
  Cell[4186, 160, 370, 8, 70, "Message",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->527509787],
  Cell[4559, 170, 614, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->630152172],
  Cell[5458, 204, 460, 13, 70, "Input",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->4322],
  Cell[5921, 219, 639, 19, 70, "Output",
   CellTags->{
    "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
     "PaddedForm::iprf", "ScientificForm::iprf"},
   CellID->18930022]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7639, 270},
 {"AccountingForm::iprf", 7786, 274},
 {"EngineeringForm::iprf", 8818, 300},
 {"NumberForm::iprf", 9845, 326},
 {"PaddedForm::iprf", 10872, 352},
 {"ScientificForm::iprf", 11903, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 143, 7, 70, "ObjectName",
 CellID->32579],
Cell[CellGroupData[{
Cell[871, 38, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1349, 55, 246, 6, 70, "Message",
 CellID->171457527],
Cell[1598, 63, 795, 28, 70, "Notes",
 CellID->9349],
Cell[2396, 93, 113, 3, 70, "Notes",
 CellID->20031],
Cell[2512, 98, 285, 6, 70, "Notes",
 CellID->10434]
}, Closed]],
Cell[CellGroupData[{
Cell[2834, 109, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->284174187],
Cell[CellGroupData[{
Cell[3219, 123, 148, 5, 70, "ExampleSection",
 CellID->122674450],
Cell[3370, 130, 379, 13, 70, "ExampleText",
 CellID->737978798],
Cell[CellGroupData[{
Cell[3774, 147, 409, 11, 70, "Input",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->19328],
Cell[4186, 160, 370, 8, 70, "Message",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->527509787],
Cell[4559, 170, 614, 19, 70, "Output",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->630152172]
}, Open  ]],
Cell[5188, 192, 245, 8, 70, "ExampleText",
 CellID->363636645],
Cell[CellGroupData[{
Cell[5458, 204, 460, 13, 70, "Input",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->4322],
Cell[5921, 219, 639, 19, 70, "Output",
 CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
   "PaddedForm::iprf", "ScientificForm::iprf"},
 CellID->18930022]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6599, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

