(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6956,        247]
NotebookOptionsPosition[      3943,        155]
NotebookOutlinePosition[      5927,        212]
CellTagsIndexPosition[      5774,        205]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Accuracy::mnprec
Precision::mnprec\
\>", "ObjectName",
 CellID->11449],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"mnprec\"\>"}], ":", 
  " ", "\<\"Value `1` would be inconsistent with $MinPrecision; bounding by \
$MinPrecision instead.\"\>"}]], "Message", "MSG",
 CellID->391063777],

Cell[TextData[{
 "Generated by ",
 StyleBox["Accuracy[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox["]", "MR"],
 " or ",
 StyleBox["Precision[", "MR"],
 StyleBox["expr", "TI"],
 StyleBox["]", "MR"],
 " when the precision of ",
 StyleBox["expr", "TI"],
 " is less than the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->431],

Cell["\<\
Since precision and accuracy are related, setting the accuracy of a number \
also sets the precision.\
\>", "Notes",
 CellID->21023]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65444690],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->44202559],

Cell[TextData[{
 "This error can occur as a result of direct manipulation of the value of ",
 Cell[BoxData[
  ButtonBox["$MinPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinPrecision"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->132381303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MinPrecision", ",", "x"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{"N", "[", 
      RowBox[{"Pi", ",", "20"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"$MinPrecision", "=", "30"}], ";", "\n", "\t", 
    RowBox[{"Precision", "[", "x", "]"}]}]}], "\n", "]"}]], "Input",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellLabel->"In[1]:=",
 CellID->12252],

Cell[BoxData[
 RowBox[{
  RowBox[{"Precision", "::", "\<\"mnprec\"\>"}], ":", 
  " ", "\<\"Value \\!\\(20.`\\) would be inconsistent with $MinPrecision; \
bounding by $MinPrecision instead.\"\>"}]], "Message", "MSG",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellID->9294140],

Cell[BoxData["30.`"], "Output",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellLabel->"Out[1]=",
 CellID->102904878]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Accuracy::mnprec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 18.8498606}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Accuracy::mnprec Precision::mnprec", "synonyms" -> {}, 
    "title" -> "Accuracy::mnprec", "type" -> "Message", "uri" -> 
    "ref/message/mnprec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2159, 89, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->65444690]},
 "Accuracy::mnprec"->{
  Cell[2983, 122, 472, 13, 70, "Input",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->12252],
  Cell[3458, 137, 288, 6, 70, "Message",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->9294140],
  Cell[3749, 145, 128, 3, 70, "Output",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->102904878]},
 "Precision::mnprec"->{
  Cell[2983, 122, 472, 13, 70, "Input",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->12252],
  Cell[3458, 137, 288, 6, 70, "Message",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->9294140],
  Cell[3749, 145, 128, 3, 70, "Output",
   CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
   CellID->102904878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4880, 178},
 {"Accuracy::mnprec", 5021, 182},
 {"Precision::mnprec", 5398, 192}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 80, 4, 70, "ObjectName",
 CellID->11449],
Cell[CellGroupData[{
Cell[808, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1286, 52, 245, 6, 70, "Message",
 CellID->391063777],
Cell[1534, 60, 443, 18, 70, "Notes",
 CellID->431],
Cell[1980, 80, 142, 4, 70, "Notes",
 CellID->21023]
}, Closed]],
Cell[CellGroupData[{
Cell[2159, 89, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->65444690],
Cell[CellGroupData[{
Cell[2543, 103, 147, 5, 70, "ExampleSection",
 CellID->44202559],
Cell[2693, 110, 265, 8, 70, "ExampleText",
 CellID->132381303],
Cell[CellGroupData[{
Cell[2983, 122, 472, 13, 70, "Input",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellID->12252],
Cell[3458, 137, 288, 6, 70, "Message",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellID->9294140],
Cell[3749, 145, 128, 3, 70, "Output",
 CellTags->{"Accuracy::mnprec", "Precision::mnprec"},
 CellID->102904878]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3916, 153, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

