(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26909,        815]
NotebookOptionsPosition[     12494,        452]
NotebookOutlinePosition[     22876,        700]
CellTagsIndexPosition[     22691,        692]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Break::nofunc
Continue::nofunc
Return::nofunc\
\>", "ObjectName",
 CellID->11368],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"nofunc\"\>"}], ":", 
  " ", "\<\"Function `1` not found enclosing `2`.\"\>"}]], "Message", "MSG",
 CellID->29466912],

Cell[TextData[{
 "Generated when the optional second argument in ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " does not match an enclosing function call."
}], "Notes",
 CellID->25048],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Continue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Continue"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " is a label that specifies the enclosing function or loop that will be \
affected. If this label is omitted, the affected function or loop is",
 " ",
 "determined using built-in heuristics."
}], "Notes",
 CellID->18500]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->874610949],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27943541],

Cell[TextData[{
 "This message is generated if ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " is used with two arguments and there are no enclosing functions."
}], "ExampleText",
 CellID->323332982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[1]:=",
 CellID->24574],

Cell[BoxData[
 RowBox[{
  RowBox[{"Return", "::", "\<\"nofunc\"\>"}], ":", 
  " ", "\<\"Function \\!\\(2\\) not found enclosing \\!\\(Return[\\(\\(1, \
2\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->546624902],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Return", "[", 
   RowBox[{"1", ",", "2"}], "]"}], "]"}]], "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"Out[1]=",
 CellID->828701555]
}, Open  ]],

Cell[TextData[{
 "This shows a typical use of ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " with two arguments. The second argument is used here to specify that the",
 " ",
 "return should be from the enclosing ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->39189118],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "k", "}"}], ",", "\n", "\t\t", 
    RowBox[{
     RowBox[{"k", "=", "1"}], ";", "\n", "\t\t", 
     RowBox[{"Do", "[", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<k = \>\"", ",", " ", "k"}], "]"}], ";", "\n", "\t\t\t", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"++", "k"}], ">", "n"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"k", ",", "Module"}], "]"}]}], "]"}]}], ",", "\n", 
       "\t\t\t", 
       RowBox[{"{", "1000", "}"}]}], "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
     "1000"}]}], "\n", "\t\t", "]"}]}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[2]:=",
 CellID->21469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[3]:=",
 CellID->15252],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["k = ", 1],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[3]:=",
 CellID->166026171],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["k = ", 2],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[3]:=",
 CellID->569011432],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["k = ", 3],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[3]:=",
 CellID->303674092]
}, Open  ]],

Cell[BoxData["4"], "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"Out[3]=",
 CellID->355296516]
}, Open  ]],

Cell[TextData[{
 "Without the second argument in ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ", the default is to return from the enclosing ",
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " loop, so the return value of the function will be different."
}], "ExampleText",
 CellID->205349443],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "k", "}"}], ",", "\n", "\t\t", 
    RowBox[{
     RowBox[{"k", "=", "1"}], ";", "\n", "\t\t", 
     RowBox[{"Do", "[", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<k = \>\"", ",", " ", "k"}], "]"}], ";", "\n", "\t\t\t", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"++", "k"}], ">", "n"}], ",", 
          RowBox[{"Return", "[", "k", "]"}]}], "]"}]}], ",", "\n", "\t\t\t", 
       RowBox[{"{", "1000", "}"}]}], "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
     "1000"}]}], "\n", "\t\t", "]"}]}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[4]:=",
 CellID->12095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[5]:=",
 CellID->4566],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["k = ", 1],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[5]:=",
 CellID->380173037],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["k = ", 2],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[5]:=",
 CellID->66843005],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["k = ", 3],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[5]:=",
 CellID->37857726]
}, Open  ]],

Cell[BoxData["1000"], "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"Out[5]=",
 CellID->895082020]
}, Open  ]],

Cell[TextData[{
 "This shows an incorrect use of the second argument in ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ".",
 " ",
 "The function ",
 StyleBox["f", "MR"],
 " does not enclose the ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " expression and so cannot be used as a return destination."
}], "ExampleText",
 CellID->415094535],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "n_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", "k", "}"}], ",", "\n", "\t\t", 
    RowBox[{
     RowBox[{"k", "=", "1"}], ";", "\n", "\t\t", 
     RowBox[{"Do", "[", "\n", "\t\t\t", 
      RowBox[{
       RowBox[{
        RowBox[{"Print", "[", 
         RowBox[{"\"\<k = \>\"", ",", " ", "k"}], "]"}], ";", "\n", "\t\t\t", 
        
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"++", "k"}], ">", "n"}], ",", 
          RowBox[{"Return", "[", 
           RowBox[{"k", ",", "f"}], "]"}]}], "]"}]}], ",", "\n", "\t\t\t", 
       RowBox[{"{", "1000", "}"}]}], "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
     "1000"}]}], "\n", "\t\t", "]"}]}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[6]:=",
 CellID->19494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "3", "]"}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[7]:=",
 CellID->12184],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "1"}],
  SequenceForm["k = ", 1],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[7]:=",
 CellID->125188813],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "2"}],
  SequenceForm["k = ", 2],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[7]:=",
 CellID->777157275],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"k = \"\>", "\[InvisibleSpace]", "3"}],
  SequenceForm["k = ", 3],
  Editable->False]], "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"During evaluation of In[7]:=",
 CellID->604822]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Return", "::", "\<\"nofunc\"\>"}], ":", 
  " ", "\<\"Function \\!\\(f\\) not found enclosing \\!\\(Return[\\(\\(4, \
f\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->134915246],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Return", "[", 
   RowBox[{"4", ",", "f"}], "]"}], "]"}]], "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"Out[7]=",
 CellID->189076185]
}, Open  ]],

Cell[TextData[{
 "Clear the definition of ",
 StyleBox["f", "MR"],
 "."
}], "ExampleText",
 CellID->28330086],

Cell[BoxData[
 RowBox[{"Clear", "[", "f", "]"}]], "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellLabel->"In[8]:=",
 CellID->1634]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Break::nofunc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 56, 58.2727448}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Break::nofunc Continue::nofunc Return::nofunc", 
    "synonyms" -> {}, "title" -> "Break::nofunc", "type" -> "Message", "uri" -> 
    "ref/message/nofunc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2669, 106, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->874610949]},
 "Break::nofunc"->{
  Cell[3501, 139, 189, 5, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->24574],
  Cell[3693, 146, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->546624902],
  Cell[3975, 154, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->828701555],
  Cell[4665, 180, 877, 25, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->21469],
  Cell[5567, 209, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->15252],
  Cell[5753, 217, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->166026171],
  Cell[6032, 226, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->569011432],
  Cell[6311, 235, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->303674092],
  Cell[6602, 245, 139, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->355296516],
  Cell[7187, 266, 832, 23, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12095],
  Cell[8044, 293, 160, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->4566],
  Cell[8229, 301, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->380173037],
  Cell[8508, 310, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->66843005],
  Cell[8786, 319, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->37857726],
  Cell[9076, 329, 142, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->895082020],
  Cell[9720, 354, 864, 24, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->19494],
  Cell[10609, 382, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12184],
  Cell[10795, 390, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->125188813],
  Cell[11074, 399, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->777157275],
  Cell[11353, 408, 273, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->604822],
  Cell[11641, 418, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->134915246],
  Cell[11923, 426, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->189076185],
  Cell[12276, 442, 164, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->1634]},
 "Continue::nofunc"->{
  Cell[3501, 139, 189, 5, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->24574],
  Cell[3693, 146, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->546624902],
  Cell[3975, 154, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->828701555],
  Cell[4665, 180, 877, 25, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->21469],
  Cell[5567, 209, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->15252],
  Cell[5753, 217, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->166026171],
  Cell[6032, 226, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->569011432],
  Cell[6311, 235, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->303674092],
  Cell[6602, 245, 139, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->355296516],
  Cell[7187, 266, 832, 23, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12095],
  Cell[8044, 293, 160, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->4566],
  Cell[8229, 301, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->380173037],
  Cell[8508, 310, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->66843005],
  Cell[8786, 319, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->37857726],
  Cell[9076, 329, 142, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->895082020],
  Cell[9720, 354, 864, 24, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->19494],
  Cell[10609, 382, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12184],
  Cell[10795, 390, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->125188813],
  Cell[11074, 399, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->777157275],
  Cell[11353, 408, 273, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->604822],
  Cell[11641, 418, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->134915246],
  Cell[11923, 426, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->189076185],
  Cell[12276, 442, 164, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->1634]},
 "Return::nofunc"->{
  Cell[3501, 139, 189, 5, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->24574],
  Cell[3693, 146, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->546624902],
  Cell[3975, 154, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->828701555],
  Cell[4665, 180, 877, 25, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->21469],
  Cell[5567, 209, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->15252],
  Cell[5753, 217, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->166026171],
  Cell[6032, 226, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->569011432],
  Cell[6311, 235, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->303674092],
  Cell[6602, 245, 139, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->355296516],
  Cell[7187, 266, 832, 23, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12095],
  Cell[8044, 293, 160, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->4566],
  Cell[8229, 301, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->380173037],
  Cell[8508, 310, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->66843005],
  Cell[8786, 319, 275, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->37857726],
  Cell[9076, 329, 142, 3, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->895082020],
  Cell[9720, 354, 864, 24, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->19494],
  Cell[10609, 382, 161, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->12184],
  Cell[10795, 390, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->125188813],
  Cell[11074, 399, 276, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->777157275],
  Cell[11353, 408, 273, 7, 70, "Print",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->604822],
  Cell[11641, 418, 279, 6, 70, "Message",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->134915246],
  Cell[11923, 426, 226, 6, 70, "Output",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->189076185],
  Cell[12276, 442, 164, 4, 70, "Input",
   CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
   CellID->1634]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13436, 475},
 {"Break::nofunc", 13576, 479},
 {"Continue::nofunc", 16615, 549},
 {"Return::nofunc", 19652, 619}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 5, 70, "ObjectName",
 CellID->11368],
Cell[CellGroupData[{
Cell[819, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 53, 193, 5, 70, "Message",
 CellID->29466912],
Cell[1493, 60, 507, 18, 70, "Notes",
 CellID->25048],
Cell[2003, 80, 629, 21, 70, "Notes",
 CellID->18500]
}, Closed]],
Cell[CellGroupData[{
Cell[2669, 106, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->874610949],
Cell[CellGroupData[{
Cell[3054, 120, 147, 5, 70, "ExampleSection",
 CellID->27943541],
Cell[3204, 127, 272, 8, 70, "ExampleText",
 CellID->323332982],
Cell[CellGroupData[{
Cell[3501, 139, 189, 5, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->24574],
Cell[3693, 146, 279, 6, 70, "Message",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->546624902],
Cell[3975, 154, 226, 6, 70, "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->828701555]
}, Open  ]],
Cell[4216, 163, 446, 15, 70, "ExampleText",
 CellID->39189118],
Cell[4665, 180, 877, 25, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->21469],
Cell[CellGroupData[{
Cell[5567, 209, 161, 4, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->15252],
Cell[CellGroupData[{
Cell[5753, 217, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->166026171],
Cell[6032, 226, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->569011432],
Cell[6311, 235, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->303674092]
}, Open  ]],
Cell[6602, 245, 139, 3, 70, "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->355296516]
}, Open  ]],
Cell[6756, 251, 428, 13, 70, "ExampleText",
 CellID->205349443],
Cell[7187, 266, 832, 23, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->12095],
Cell[CellGroupData[{
Cell[8044, 293, 160, 4, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->4566],
Cell[CellGroupData[{
Cell[8229, 301, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->380173037],
Cell[8508, 310, 275, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->66843005],
Cell[8786, 319, 275, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->37857726]
}, Open  ]],
Cell[9076, 329, 142, 3, 70, "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->895082020]
}, Open  ]],
Cell[9233, 335, 484, 17, 70, "ExampleText",
 CellID->415094535],
Cell[9720, 354, 864, 24, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->19494],
Cell[CellGroupData[{
Cell[10609, 382, 161, 4, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->12184],
Cell[CellGroupData[{
Cell[10795, 390, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->125188813],
Cell[11074, 399, 276, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->777157275],
Cell[11353, 408, 273, 7, 70, "Print",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->604822]
}, Open  ]],
Cell[11641, 418, 279, 6, 70, "Message",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->134915246],
Cell[11923, 426, 226, 6, 70, "Output",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->189076185]
}, Open  ]],
Cell[12164, 435, 109, 5, 70, "ExampleText",
 CellID->28330086],
Cell[12276, 442, 164, 4, 70, "Input",
 CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"},
 CellID->1634]
}, Open  ]]
}, Open  ]],
Cell[12467, 450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

