(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8159,        286]
NotebookOptionsPosition[      5187,        191]
NotebookOutlinePosition[      6939,        243]
CellTagsIndexPosition[      6813,        237]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["CellularAutomaton::rspec", "ObjectName",
 CellID->4696],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"rspec\"\>"}], ":", 
  " ", "\<\"The neighbor specification at position 3 of rule specification \
`1` should be a radius, a nonempty list of radii, or a nonempty list of \
offsets. A radius must equal (d - 1)/2 for some positive machine integer d. \
The offsets are nonempty lists of machine integers.\"\>"}]], "Message", "MSG",
 
 CellID->114975011],

Cell[TextData[{
 "Generated when the first argument in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " is a list, and the third element in that list does not have the \
indicated",
 " ",
 "form."
}], "Notes",
 CellID->25451]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474556392],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->674540882],

Cell[TextData[{
 "The third element in the first argument of ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " cannot be an empty list."
}], "ExampleText",
 CellID->45711174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::rspec",
 CellLabel->"In[1]:=",
 CellID->5343],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"rspec\"\>"}], ":", 
  " ", "\<\"The neighbor specification at position 3 of rule specification \
\\!\\({3, 2, \\(\\({}\\)\\)}\\) should be a radius, a nonempty list of radii, \
or a nonempty list of offsets. A radius must equal (d - 1)/2 for some \
positive machine integer d. The offsets are nonempty lists of machine \
integers.\"\>"}]], "Message", "MSG",
 CellTags->"CellularAutomaton::rspec",
 CellID->776923524],

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", 
     RowBox[{"{", "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "5"}], "]"}]], "Output",
 CellTags->"CellularAutomaton::rspec",
 CellLabel->"Out[1]=",
 CellID->90719472]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->104832397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::rspec",
 CellLabel->"In[2]:=",
 CellID->1443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"CellularAutomaton::rspec",
 CellLabel->"Out[2]=",
 CellID->201935735]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellularAutomaton::rspec - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 6.6010830}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "CellularAutomaton::rspec", "synonyms" -> {}, "title" -> 
    "CellularAutomaton::rspec", "type" -> "Message", "uri" -> 
    "ref/message/rspec"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2041, 75, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->474556392]},
 "CellularAutomaton::rspec"->{
  Cell[2869, 108, 319, 10, 70, "Input",
   CellTags->"CellularAutomaton::rspec",
   CellID->5343],
  Cell[3191, 120, 482, 9, 70, "Message",
   CellTags->"CellularAutomaton::rspec",
   CellID->776923524],
  Cell[3676, 131, 324, 10, 70, "Output",
   CellTags->"CellularAutomaton::rspec",
   CellID->90719472],
  Cell[4271, 156, 298, 9, 70, "Input",
   CellTags->"CellularAutomaton::rspec",
   CellID->1443],
  Cell[4572, 167, 549, 17, 70, "Output",
   CellTags->"CellularAutomaton::rspec",
   CellID->201935735]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6128, 214},
 {"CellularAutomaton::rspec", 6278, 218}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 61, 1, 70, "ObjectName",
 CellID->4696],
Cell[CellGroupData[{
Cell[789, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1267, 49, 415, 8, 70, "Message",
 CellID->114975011],
Cell[1685, 59, 319, 11, 70, "Notes",
 CellID->25451]
}, Closed]],
Cell[CellGroupData[{
Cell[2041, 75, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474556392],
Cell[CellGroupData[{
Cell[2426, 89, 148, 5, 70, "ExampleSection",
 CellID->674540882],
Cell[2577, 96, 267, 8, 70, "ExampleText",
 CellID->45711174],
Cell[CellGroupData[{
Cell[2869, 108, 319, 10, 70, "Input",
 CellTags->"CellularAutomaton::rspec",
 CellID->5343],
Cell[3191, 120, 482, 9, 70, "Message",
 CellTags->"CellularAutomaton::rspec",
 CellID->776923524],
Cell[3676, 131, 324, 10, 70, "Output",
 CellTags->"CellularAutomaton::rspec",
 CellID->90719472]
}, Open  ]],
Cell[4015, 144, 231, 8, 70, "ExampleText",
 CellID->104832397],
Cell[CellGroupData[{
Cell[4271, 156, 298, 9, 70, "Input",
 CellTags->"CellularAutomaton::rspec",
 CellID->1443],
Cell[4572, 167, 549, 17, 70, "Output",
 CellTags->"CellularAutomaton::rspec",
 CellID->201935735]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5160, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

