(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9580,        339]
NotebookOptionsPosition[      6492,        240]
NotebookOutlinePosition[      8247,        292]
CellTagsIndexPosition[      8121,        286]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["CellularAutomaton::stoff", "ObjectName",
 CellID->32446],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"stoff\"\>"}], ":", 
  " ", "\<\"The offset `1` at position `2` in the initial condition \
specification should be a length `3` list of machine integers.\"\>"}]], \
"Message", "MSG",
 CellID->137561216],

Cell[TextData[{
 "Generated when the first part of the second argument",
 " ",
 "in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " does not have an expected form."
}], "Notes",
 CellID->12366],

Cell[TextData[{
 "The second argument in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " is the initial condition specification. The first element in the initial \
condition specification is the state specification, which can include both",
 " ",
 "the initial state and a spatial offset specification."
}], "Notes",
 CellID->13406],

Cell[TextData[{
 " See the documentation for ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " for information on valid forms for the initial condition and state",
 " ",
 "specifications."
}], "Notes",
 CellID->5525]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69471785],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->226210289],

Cell[TextData[{
 "An error occurs in this example because the structure of the offset",
 " ",
 "specification in the first part of the second argument of ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 " does not match the structure of the state specification."
}], "ExampleText",
 CellID->367082852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "1", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::stoff",
 CellLabel->"In[1]:=",
 CellID->14224],

Cell[BoxData[
 RowBox[{
  RowBox[{"CellularAutomaton", "::", "\<\"stoff\"\>"}], ":", 
  " ", "\<\"The offset \\!\\(0\\) at position \\!\\({1, 2, 2}\\) in the \
initial condition specification should be a length \\!\\(1\\) list of machine \
integers.\"\>"}]], "Message", "MSG",
 CellTags->"CellularAutomaton::stoff",
 CellID->178637391],

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "1", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "3"}], "]"}]], "Output",
 CellTags->"CellularAutomaton::stoff",
 CellLabel->"Out[1]=",
 CellID->58363375]
}, Open  ]],

Cell[TextData[{
 "This shows a valid state and offset specification in ",
 Cell[BoxData[
  ButtonBox["CellularAutomaton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CellularAutomaton"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->31111064],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CellularAutomaton", "[", 
  RowBox[{"30", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "1", "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "0", "}"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", "0", "}"}]}], "}"}], ",", "3"}], "]"}]], "Input",
 CellTags->"CellularAutomaton::stoff",
 CellLabel->"In[2]:=",
 CellID->11763],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "0", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1", ",", "1", ",", 
     "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
     "1"}], "}"}]}], "}"}]], "Output",
 CellTags->"CellularAutomaton::stoff",
 CellLabel->"Out[2]=",
 CellID->163333238]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CellularAutomaton::stoff - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 14.2419036}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "CellularAutomaton::stoff", "synonyms" -> {}, "title" -> 
    "CellularAutomaton::stoff", "type" -> "Message", "uri" -> 
    "ref/message/stoff"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2605, 97, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->69471785]},
 "CellularAutomaton::stoff"->{
  Cell[3558, 132, 514, 17, 70, "Input",
   CellTags->"CellularAutomaton::stoff",
   CellID->14224],
  Cell[4075, 151, 335, 7, 70, "Message",
   CellTags->"CellularAutomaton::stoff",
   CellID->178637391],
  Cell[4413, 160, 518, 17, 70, "Output",
   CellTags->"CellularAutomaton::stoff",
   CellID->58363375],
  Cell[5224, 192, 544, 18, 70, "Input",
   CellTags->"CellularAutomaton::stoff",
   CellID->11763],
  Cell[5771, 212, 655, 21, 70, "Output",
   CellTags->"CellularAutomaton::stoff",
   CellID->163333238]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7434, 263},
 {"CellularAutomaton::stoff", 7583, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 62, 1, 70, "ObjectName",
 CellID->32446],
Cell[CellGroupData[{
Cell[790, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1268, 49, 267, 6, 70, "Message",
 CellID->137561216],
Cell[1538, 57, 288, 10, 70, "Notes",
 CellID->12366],
Cell[1829, 69, 427, 11, 70, "Notes",
 CellID->13406],
Cell[2259, 82, 309, 10, 70, "Notes",
 CellID->5525]
}, Closed]],
Cell[CellGroupData[{
Cell[2605, 97, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->69471785],
Cell[CellGroupData[{
Cell[2989, 111, 148, 5, 70, "ExampleSection",
 CellID->226210289],
Cell[3140, 118, 393, 10, 70, "ExampleText",
 CellID->367082852],
Cell[CellGroupData[{
Cell[3558, 132, 514, 17, 70, "Input",
 CellTags->"CellularAutomaton::stoff",
 CellID->14224],
Cell[4075, 151, 335, 7, 70, "Message",
 CellTags->"CellularAutomaton::stoff",
 CellID->178637391],
Cell[4413, 160, 518, 17, 70, "Output",
 CellTags->"CellularAutomaton::stoff",
 CellID->58363375]
}, Open  ]],
Cell[4946, 180, 253, 8, 70, "ExampleText",
 CellID->31111064],
Cell[CellGroupData[{
Cell[5224, 192, 544, 18, 70, "Input",
 CellTags->"CellularAutomaton::stoff",
 CellID->11763],
Cell[5771, 212, 655, 21, 70, "Output",
 CellTags->"CellularAutomaton::stoff",
 CellID->163333238]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6465, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

