(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6838,        256]
NotebookOptionsPosition[      3971,        162]
NotebookOutlinePosition[      5653,        213]
CellTagsIndexPosition[      5533,        207]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["ClebschGordan::phy", "ObjectName",
 CellID->16602],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"phy\"\>"}], ":", 
  " ", "\<\"`1` is not physical.\"\>"}]], "Message", "MSG",
 CellID->1080835],

Cell[TextData[{
 "Generated when the arguments in ",
 Cell[BoxData[
  ButtonBox["ClebschGordan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClebschGordan"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 " do not represent a physically meaningful coefficient."
}], "Notes",
 CellID->12178]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74364257],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->201783772],

Cell["\<\
An error occurs in this example because the input does not correspond to a \
possible decomposition.\
\>", "ExampleText",
 CellID->30229857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"ClebschGordan::phy",
 CellLabel->"In[1]:=",
 CellID->80],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"phy\"\>"}], ":", 
  " ", "\<\"\\!\\(ThreeJSymbol[\\(\\(\\(\\({2, 1}\\)\\), \\(\\({1, 1}\\)\\), \
\\(\\({2, \\(\\(-1\\)\\)}\\)\\)\\)\\)]\\) is not physical.\"\>"}]], "Message",\
 "MSG",
 CellTags->"ClebschGordan::phy",
 CellID->616211938],

Cell[BoxData["0"], "Output",
 CellTags->"ClebschGordan::phy",
 CellLabel->"Out[1]=",
 CellID->137719221]
}, Open  ]],

Cell["\<\
This shows a physically meaningful Clebsch-Gordan coefficient.\
\>", "ExampleText",
 CellID->163357671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ClebschGordan", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->"ClebschGordan::phy",
 CellLabel->"In[2]:=",
 CellID->857],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["6"]]], "Output",
 CellTags->"ClebschGordan::phy",
 CellLabel->"Out[2]=",
 CellID->160677416]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ClebschGordan::phy - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 23.1015054}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "ClebschGordan::phy", "synonyms" -> {}, "title" -> 
    "ClebschGordan::phy", "type" -> "Message", "uri" -> "ref/message/phy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1863, 73, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->74364257]},
 "ClebschGordan::phy"->{
  Cell[2573, 102, 315, 11, 70, "Input",
   CellTags->"ClebschGordan::phy",
   CellID->80],
  Cell[2891, 115, 299, 7, 70, "Message",
   CellTags->"ClebschGordan::phy",
   CellID->616211938],
  Cell[3193, 124, 104, 3, 70, "Output",
   CellTags->"ClebschGordan::phy",
   CellID->137719221],
  Cell[3450, 137, 316, 11, 70, "Input",
   CellTags->"ClebschGordan::phy",
   CellID->857],
  Cell[3769, 150, 136, 5, 70, "Output",
   CellTags->"ClebschGordan::phy",
   CellID->160677416]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4888, 184},
 {"ClebschGordan::phy", 5031, 188}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 56, 1, 70, "ObjectName",
 CellID->16602],
Cell[CellGroupData[{
Cell[784, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1262, 49, 157, 4, 70, "Message",
 CellID->1080835],
Cell[1422, 55, 404, 13, 70, "Notes",
 CellID->12178]
}, Closed]],
Cell[CellGroupData[{
Cell[1863, 73, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->74364257],
Cell[CellGroupData[{
Cell[2247, 87, 148, 5, 70, "ExampleSection",
 CellID->201783772],
Cell[2398, 94, 150, 4, 70, "ExampleText",
 CellID->30229857],
Cell[CellGroupData[{
Cell[2573, 102, 315, 11, 70, "Input",
 CellTags->"ClebschGordan::phy",
 CellID->80],
Cell[2891, 115, 299, 7, 70, "Message",
 CellTags->"ClebschGordan::phy",
 CellID->616211938],
Cell[3193, 124, 104, 3, 70, "Output",
 CellTags->"ClebschGordan::phy",
 CellID->137719221]
}, Open  ]],
Cell[3312, 130, 113, 3, 70, "ExampleText",
 CellID->163357671],
Cell[CellGroupData[{
Cell[3450, 137, 316, 11, 70, "Input",
 CellTags->"ClebschGordan::phy",
 CellID->857],
Cell[3769, 150, 136, 5, 70, "Output",
 CellTags->"ClebschGordan::phy",
 CellID->160677416]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3944, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

