(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9946,        372]
NotebookOptionsPosition[      6344,        250]
NotebookOutlinePosition[      8343,        313]
CellTagsIndexPosition[      8228,        307]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::ccon", "ObjectName",
 CellID->23535],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ccon\"\>"}], ":", 
  " ", "\<\"Non-numerical object `1` with attribute Constant cannot be \
compiled.\"\>"}]], "Message", "MSG",
 CellID->832070577],

Cell[TextData[{
 "Generated when an expression to be compiled contains a symbol with the ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " attribute does not evaluate to a number and does not have any rules for \
computing numerical",
 " ",
 "approximations using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3317]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570359919],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->105937516],

Cell[TextData[{
 "An error occurs in this example because there is a symbol to be compiled \
that has the ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " attribute but no ",
 Cell[BoxData["NValues"], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->333389212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "c", "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"c", ",", " ", "Constant"}], "]"}], ";", "\n", "\t", 
    RowBox[{"Compile", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"c", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}]}], "\n", "]"}]], "Input",
 CellTags->"Compile::ccon",
 CellLabel->"In[1]:=",
 CellID->7745],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ccon\"\>"}], ":", 
  " ", "\<\"Non-numerical object \\!\\(c\\) with attribute Constant cannot be \
compiled.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::ccon",
 CellID->88159077],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ccon\"\>"}], ":", 
  " ", "\<\"Non-numerical object \\!\\(c\\) with attribute Constant cannot be \
compiled.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::ccon",
 CellID->12129952],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ccon",
 CellLabel->"Out[1]=",
 CellID->539988241]
}, Open  ]],

Cell[TextData[{
 "If a symbol to be compiled must have the ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " attribute, compilation can proceed without error if the symbol also has a \
rule for numerical approximation using ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ". The numerical value of the constant is incorporated into the resulting ",
 Cell[BoxData[
  ButtonBox["CompiledFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CompiledFunction"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->579741832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", "c", "}"}], ",", "\n", "\t", 
    RowBox[{
     RowBox[{"SetAttributes", "[", 
      RowBox[{"c", ",", " ", "Constant"}], "]"}], ";", "\n", "\t", 
     RowBox[{
      RowBox[{"N", "[", "c", "]"}], "=", "5.7"}], ";", "\n", "\t", 
     RowBox[{"Compile", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"c", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}]}]}], "\n", "]"}]}]], "Input",\

 CellTags->"Compile::ccon",
 CellLabel->"In[2]:=",
 CellID->13249],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"c", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ccon",
 CellLabel->"Out[2]=",
 CellID->30668447]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "[", 
  RowBox[{"Pi", "/", "2"}], "]"}]], "Input",
 CellTags->"Compile::ccon",
 CellLabel->"In[3]:=",
 CellID->28744],

Cell[BoxData["5.7`"], "Output",
 CellTags->"Compile::ccon",
 CellLabel->"Out[3]=",
 CellID->253649101]
}, Open  ]],

Cell[TextData[{
 "Clear the value of ",
 StyleBox["cf", "MR"],
 "."
}], "ExampleText",
 CellID->432136684],

Cell[BoxData[
 RowBox[{"Clear", "[", "cf", "]"}]], "Input",
 CellTags->"Compile::ccon",
 CellLabel->"In[4]:=",
 CellID->3044]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::ccon - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 54.2429276}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::ccon", "synonyms" -> {}, "title" -> 
    "Compile::ccon", "type" -> "Message", "uri" -> "ref/message/ccon"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1980, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->570359919]},
 "Compile::ccon"->{
  Cell[2879, 113, 456, 14, 70, "Input",
   CellTags->"Compile::ccon",
   CellID->7745],
  Cell[3338, 129, 238, 6, 70, "Message",
   CellTags->"Compile::ccon",
   CellID->88159077],
  Cell[3579, 137, 238, 6, 70, "Message",
   CellTags->"Compile::ccon",
   CellID->12129952],
  Cell[3820, 145, 321, 12, 70, "Output",
   CellTags->"Compile::ccon",
   CellID->539988241],
  Cell[4855, 183, 575, 18, 70, "Input",
   CellTags->"Compile::ccon",
   CellID->13249],
  Cell[5433, 203, 320, 12, 70, "Output",
   CellTags->"Compile::ccon",
   CellID->30668447],
  Cell[5790, 220, 146, 5, 70, "Input",
   CellTags->"Compile::ccon",
   CellID->28744],
  Cell[5939, 227, 102, 3, 70, "Output",
   CellTags->"Compile::ccon",
   CellID->253649101],
  Cell[6165, 240, 125, 4, 70, "Input",
   CellTags->"Compile::ccon",
   CellID->3044]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7247, 272},
 {"Compile::ccon", 7386, 276}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->23535],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 204, 5, 70, "Message",
 CellID->832070577],
Cell[1464, 56, 479, 16, 70, "Notes",
 CellID->3317]
}, Closed]],
Cell[CellGroupData[{
Cell[1980, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->570359919],
Cell[CellGroupData[{
Cell[2365, 91, 148, 5, 70, "ExampleSection",
 CellID->105937516],
Cell[2516, 98, 338, 11, 70, "ExampleText",
 CellID->333389212],
Cell[CellGroupData[{
Cell[2879, 113, 456, 14, 70, "Input",
 CellTags->"Compile::ccon",
 CellID->7745],
Cell[3338, 129, 238, 6, 70, "Message",
 CellTags->"Compile::ccon",
 CellID->88159077],
Cell[3579, 137, 238, 6, 70, "Message",
 CellTags->"Compile::ccon",
 CellID->12129952],
Cell[3820, 145, 321, 12, 70, "Output",
 CellTags->"Compile::ccon",
 CellID->539988241]
}, Open  ]],
Cell[4156, 160, 674, 19, 70, "ExampleText",
 CellID->579741832],
Cell[CellGroupData[{
Cell[4855, 183, 575, 18, 70, "Input",
 CellTags->"Compile::ccon",
 CellID->13249],
Cell[5433, 203, 320, 12, 70, "Output",
 CellTags->"Compile::ccon",
 CellID->30668447]
}, Open  ]],
Cell[CellGroupData[{
Cell[5790, 220, 146, 5, 70, "Input",
 CellTags->"Compile::ccon",
 CellID->28744],
Cell[5939, 227, 102, 3, 70, "Output",
 CellTags->"Compile::ccon",
 CellID->253649101]
}, Open  ]],
Cell[6056, 233, 106, 5, 70, "ExampleText",
 CellID->432136684],
Cell[6165, 240, 125, 4, 70, "Input",
 CellTags->"Compile::ccon",
 CellID->3044]
}, Open  ]]
}, Open  ]],
Cell[6317, 248, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

