(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7995,        291]
NotebookOptionsPosition[      5085,        194]
NotebookOutlinePosition[      6761,        246]
CellTagsIndexPosition[      6643,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cpintlt", "ObjectName",
 CellID->29465],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpintlt\"\>"}], ":", 
  " ", "\<\"`1` at position `2` of `3` should be either a nonzero integer or \
a vector of nonzero integers; evaluation will use the uncompiled \
function.\"\>"}]], "Message", "MSG",
 CellID->59860431],

Cell["\<\
Generated when the indicated expression is expected to be an integer or a \
list of integers.\
\>", "Notes",
 CellID->27073],

Cell[TextData[{
 "This message can occur when compiling functions such as ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " in which some of the arguments can be either integers or lists of \
integers."
}], "Notes",
 CellID->17639]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67510006],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->139405318],

Cell["\<\
An error occurs in this example because the symbolic part specification is \
not an integer.\
\>", "ExampleText",
 CellID->601881125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "11", ",", "12", ",", "13"}], "}"}], "[", 
    RowBox[{"[", "n", "]"}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cpintlt",
 CellLabel->"In[1]:=",
 CellID->18343],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpintlt\"\>"}], ":", 
  " ", "\<\"\\!\\(n\\) at position \\!\\(2\\) of \\!\\(\\(\\({10, 11, 12, 13}\
\\)\\) \[LeftDoubleBracket] n \[RightDoubleBracket]\\) should be either a \
nonzero integer or a vector of nonzero integers; evaluation will use the \
uncompiled function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cpintlt",
 CellID->67793201],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12", ",", "13"}], "}"}], 
     "\[LeftDoubleBracket]", "n", "\[RightDoubleBracket]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpintlt",
 CellLabel->"Out[1]=",
 CellID->407644636]
}, Open  ]],

Cell[TextData[{
 "If the symbolic part specification will evaluate to an integer or list of \
integers, that information can be included in the third argument of ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->171343329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"10", ",", "11", ",", "12", ",", "13"}], "}"}], "[", 
    RowBox[{"[", "n", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"n", ",", "_Integer"}], "}"}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::cpintlt",
 CellLabel->"In[2]:=",
 CellID->7856],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "11", ",", "12", ",", "13"}], "}"}], 
     "\[LeftDoubleBracket]", "n", "\[RightDoubleBracket]"}], 
    ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpintlt",
 CellLabel->"Out[2]=",
 CellID->218394395]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cpintlt - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 55.1492008}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cpintlt", "synonyms" -> {}, "title" -> 
    "Compile::cpintlt", "type" -> "Message", "uri" -> 
    "ref/message/cpintlt"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2014, 77, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->67510006]},
 "Compile::cpintlt"->{
  Cell[2717, 106, 301, 10, 70, "Input",
   CellTags->"Compile::cpintlt",
   CellID->18343],
  Cell[3021, 118, 405, 8, 70, "Message",
   CellTags->"Compile::cpintlt",
   CellID->67793201],
  Cell[3429, 128, 415, 14, 70, "Output",
   CellTags->"Compile::cpintlt",
   CellID->407644636],
  Cell[4209, 158, 392, 13, 70, "Input",
   CellTags->"Compile::cpintlt",
   CellID->7856],
  Cell[4604, 173, 415, 14, 70, "Output",
   CellTags->"Compile::cpintlt",
   CellID->218394395]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6005, 217},
 {"Compile::cpintlt", 6146, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->29465],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 279, 6, 70, "Message",
 CellID->59860431],
Cell[1542, 57, 134, 4, 70, "Notes",
 CellID->27073],
Cell[1679, 63, 298, 9, 70, "Notes",
 CellID->17639]
}, Closed]],
Cell[CellGroupData[{
Cell[2014, 77, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->67510006],
Cell[CellGroupData[{
Cell[2398, 91, 148, 5, 70, "ExampleSection",
 CellID->139405318],
Cell[2549, 98, 143, 4, 70, "ExampleText",
 CellID->601881125],
Cell[CellGroupData[{
Cell[2717, 106, 301, 10, 70, "Input",
 CellTags->"Compile::cpintlt",
 CellID->18343],
Cell[3021, 118, 405, 8, 70, "Message",
 CellTags->"Compile::cpintlt",
 CellID->67793201],
Cell[3429, 128, 415, 14, 70, "Output",
 CellTags->"Compile::cpintlt",
 CellID->407644636]
}, Open  ]],
Cell[3859, 145, 325, 9, 70, "ExampleText",
 CellID->171343329],
Cell[CellGroupData[{
Cell[4209, 158, 392, 13, 70, "Input",
 CellTags->"Compile::cpintlt",
 CellID->7856],
Cell[4604, 173, 415, 14, 70, "Output",
 CellTags->"Compile::cpintlt",
 CellID->218394395]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5058, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

