(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7998,        293]
NotebookOptionsPosition[      5080,        196]
NotebookOutlinePosition[      6764,        248]
CellTagsIndexPosition[      6645,        242]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cpintlt2", "ObjectName",
 CellID->16060],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpintlt2\"\>"}], ":", 
  " ", "\<\"`1` at position `2` of `3` should be a nonzero integer, or a \
vector or matrix of nonzero integers; evaluation will use the uncompiled \
function.\"\>"}]], "Message", "MSG",
 CellID->75532369],

Cell["\<\
Generated when the indicated expression is expected to be an integer or a \
list of integers.\
\>", "Notes",
 CellID->14776],

Cell[TextData[{
 "This message can occur when compiling functions such as ",
 Cell[BoxData[
  ButtonBox["Insert",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Insert"]], "InlineFormula"],
 " in which some of the arguments can be either integers or lists of \
integers."
}], "Notes",
 CellID->2397]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245846],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->28163158],

Cell["\<\
An error occurs in this example because the symbolic part specification is \
not an integer.\
\>", "ExampleText",
 CellID->196848123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Insert", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "12", ",", "13"}], "}"}], ",", "11", ",", "n"}], 
    "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cpintlt2",
 CellLabel->"In[1]:=",
 CellID->5603],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cpintlt2\"\>"}], ":", 
  " ", "\<\"\\!\\(n\\) at position \\!\\(3\\) of \
\\!\\(Insert[\\(\\(\\(\\({10, 12, 13}\\)\\), 11, n\\)\\)]\\) should be a \
nonzero integer, or a vector or matrix of nonzero integers; evaluation will \
use the uncompiled function.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cpintlt2",
 CellID->436651746],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Insert", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "12", ",", "13"}], "}"}], ",", "11", ",", "n"}], 
     "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpintlt2",
 CellLabel->"Out[1]=",
 CellID->23614864]
}, Open  ]],

Cell[TextData[{
 "If the symbolic part specification will evaluate to an integer or list of \
integers, that information can be included in the third argument of ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->577007857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Insert", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"10", ",", "12", ",", "13"}], "}"}], ",", "11", ",", "n"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"n", ",", "_Integer"}], "}"}], "}"}]}], "]"}]], "Input",
 CellTags->"Compile::cpintlt2",
 CellLabel->"In[2]:=",
 CellID->14567],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"Insert", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"10", ",", "12", ",", "13"}], "}"}], ",", "11", ",", "n"}], 
     "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cpintlt2",
 CellLabel->"Out[2]=",
 CellID->79382150]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cpintlt2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 57, 55.0085722}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cpintlt2", "synonyms" -> {}, "title" -> 
    "Compile::cpintlt2", "type" -> "Message", "uri" -> 
    "ref/message/cpintlt2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2023, 77, 357, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->245846]},
 "Compile::cpintlt2"->{
  Cell[2723, 106, 313, 11, 70, "Input",
   CellTags->"Compile::cpintlt2",
   CellID->5603],
  Cell[3039, 119, 390, 8, 70, "Message",
   CellTags->"Compile::cpintlt2",
   CellID->436651746],
  Cell[3432, 129, 404, 14, 70, "Output",
   CellTags->"Compile::cpintlt2",
   CellID->23614864],
  Cell[4201, 159, 406, 14, 70, "Input",
   CellTags->"Compile::cpintlt2",
   CellID->14567],
  Cell[4610, 175, 404, 14, 70, "Output",
   CellTags->"Compile::cpintlt2",
   CellID->79382150]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6004, 219},
 {"Compile::cpintlt2", 6144, 223}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->16060],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 284, 6, 70, "Message",
 CellID->75532369],
Cell[1548, 57, 134, 4, 70, "Notes",
 CellID->14776],
Cell[1685, 63, 301, 9, 70, "Notes",
 CellID->2397]
}, Closed]],
Cell[CellGroupData[{
Cell[2023, 77, 357, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->245846],
Cell[CellGroupData[{
Cell[2405, 91, 147, 5, 70, "ExampleSection",
 CellID->28163158],
Cell[2555, 98, 143, 4, 70, "ExampleText",
 CellID->196848123],
Cell[CellGroupData[{
Cell[2723, 106, 313, 11, 70, "Input",
 CellTags->"Compile::cpintlt2",
 CellID->5603],
Cell[3039, 119, 390, 8, 70, "Message",
 CellTags->"Compile::cpintlt2",
 CellID->436651746],
Cell[3432, 129, 404, 14, 70, "Output",
 CellTags->"Compile::cpintlt2",
 CellID->23614864]
}, Open  ]],
Cell[3851, 146, 325, 9, 70, "ExampleText",
 CellID->577007857],
Cell[CellGroupData[{
Cell[4201, 159, 406, 14, 70, "Input",
 CellTags->"Compile::cpintlt2",
 CellID->14567],
Cell[4610, 175, 404, 14, 70, "Output",
 CellTags->"Compile::cpintlt2",
 CellID->79382150]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5053, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

