(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7741,        289]
NotebookOptionsPosition[      4885,        193]
NotebookOutlinePosition[      6524,        244]
CellTagsIndexPosition[      6409,        238]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::cset", "ObjectName",
 CellID->11222],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cset\"\>"}], ":", 
  " ", "\<\"Variable `1` of type `2` encountered in assignment of type `3`.\"\
\>"}]], "Message", "MSG",
 CellID->21722984],

Cell["\<\
Generated when an expression to be compiled involves assignments of the same \
variable to different types of expressions.\
\>", "Notes",
 CellID->7347],

Cell["\<\
The type of a variable must the the same throughout a compiled evaluation.\
\>", "Notes",
 CellID->6547]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160810704],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->9000481],

Cell["\<\
A warning is generated in this example because expressions of different types \
are assigned at different times to the same variable.\
\>", "ExampleText",
 CellID->246373969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Complex"}], "}"}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{
      RowBox[{"x", "=", "1"}], ";", 
      RowBox[{"x", "=", "p"}]}]}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cset",
 CellLabel->"In[1]:=",
 CellID->26251],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"cset\"\>"}], ":", 
  " ", "\<\"Variable \\!\\(x\\) of type \\!\\(\\\"_Integer\\\"\\) encountered \
in assignment of type \\!\\(\\\"_Complex\\\"\\).\"\>"}]], "Message", "MSG",
 CellTags->"Compile::cset",
 CellID->153257344],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"x", "=", "1"}], ";", 
       RowBox[{"x", "=", "p"}]}]}], "]"}], ",", "\<\"-CompiledCode-\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cset",
 CellLabel->"Out[1]=",
 CellID->130836317]
}, Open  ]],

Cell["\<\
The type conflict can be avoided by using expressions of the same type in all \
assignments to the variable.\
\>", "ExampleText",
 CellID->543786482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Complex"}], "}"}], "}"}], ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{
      RowBox[{"x", "=", 
       RowBox[{"1.0", "+", 
        RowBox[{"0.0", "I"}]}]}], ";", 
      RowBox[{"x", "=", "p"}]}]}], "]"}]}], "]"}]], "Input",
 CellTags->"Compile::cset",
 CellLabel->"In[2]:=",
 CellID->20126],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"1.`", "\[InvisibleSpace]", "+", 
         RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], ";", 
       RowBox[{"x", "=", "p"}]}]}], "]"}], ",", "\<\"-CompiledCode-\"\>"}], 
   "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::cset",
 CellLabel->"Out[2]=",
 CellID->454118563]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::cset - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 3.4619136}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::cset", "synonyms" -> {}, "title" -> 
    "Compile::cset", "type" -> "Message", "uri" -> "ref/message/cset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1774, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160810704]},
 "Compile::cset"->{
  Cell[2517, 99, 397, 14, 70, "Input",
   CellTags->"Compile::cset",
   CellID->26251],
  Cell[2917, 115, 278, 6, 70, "Message",
   CellTags->"Compile::cset",
   CellID->153257344],
  Cell[3198, 123, 435, 16, 70, "Output",
   CellTags->"Compile::cset",
   CellID->130836317],
  Cell[3832, 150, 453, 16, 70, "Input",
   CellTags->"Compile::cset",
   CellID->20126],
  Cell[4288, 168, 531, 18, 70, "Output",
   CellTags->"Compile::cset",
   CellID->454118563]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5787, 215},
 {"Compile::cset", 5926, 219}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 51, 1, 70, "ObjectName",
 CellID->11222],
Cell[CellGroupData[{
Cell[779, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1257, 49, 198, 5, 70, "Message",
 CellID->21722984],
Cell[1458, 56, 162, 4, 70, "Notes",
 CellID->7347],
Cell[1623, 62, 114, 3, 70, "Notes",
 CellID->6547]
}, Closed]],
Cell[CellGroupData[{
Cell[1774, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160810704],
Cell[CellGroupData[{
Cell[2159, 84, 146, 5, 70, "ExampleSection",
 CellID->9000481],
Cell[2308, 91, 184, 4, 70, "ExampleText",
 CellID->246373969],
Cell[CellGroupData[{
Cell[2517, 99, 397, 14, 70, "Input",
 CellTags->"Compile::cset",
 CellID->26251],
Cell[2917, 115, 278, 6, 70, "Message",
 CellTags->"Compile::cset",
 CellID->153257344],
Cell[3198, 123, 435, 16, 70, "Output",
 CellTags->"Compile::cset",
 CellID->130836317]
}, Open  ]],
Cell[3648, 142, 159, 4, 70, "ExampleText",
 CellID->543786482],
Cell[CellGroupData[{
Cell[3832, 150, 453, 16, 70, "Input",
 CellTags->"Compile::cset",
 CellID->20126],
Cell[4288, 168, 531, 18, 70, "Output",
 CellTags->"Compile::cset",
 CellID->454118563]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4858, 191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

