(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9045,        345]
NotebookOptionsPosition[      5960,        241]
NotebookOutlinePosition[      7608,        292]
CellTagsIndexPosition[      7492,        286]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::ctyp1", "ObjectName",
 CellID->11106],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyp1\"\>"}], ":", 
  " ", "\<\"Number `1` in `2` is an invalid compiler variable. A symbol can \
be used as a valid variable.\"\>"}]], "Message", "MSG",
 CellID->68431430],

Cell[TextData[{
 "Generated by an invalid specification for a parameter used in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21198],

Cell[TextData[{
 "Parameter specifications are listed in the first argument of ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8340],

Cell[TextData[{
 "A valid parameter specification gives the symbolic name of the parameter or \
a list giving the name and the type of the parameter. If only the name of the \
parameter is given, the type is assumed to be ",
 StyleBox["_Real", "MR"],
 "."
}], "Notes",
 CellID->31808],

Cell[TextData[{
 "An explicit type specification should be a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " giving the name ",
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 " and the type ",
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 " of the parameter, or a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["t", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 " which includes the tensor rank ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " of the parameter if the parameter is a tensor."
}], "Notes",
 CellID->7347],

Cell[TextData[{
 "The type of a parameter can be ",
 StyleBox["_Integer", "MR"],
 ", ",
 StyleBox["_Real", "MR"],
 ", ",
 StyleBox["_Complex", "MR"],
 ", or ",
 StyleBox["True|False", "MR"],
 "."
}], "Notes",
 CellID->22950],

Cell["\<\
This particular message is generated if a number is encountered in a position \
where the name of a parameter is expected.\
\>", "Notes",
 CellID->24023]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313128572],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->70081019],

Cell[TextData[{
 "An error occurs in this example because a number cannot be used as the name \
of a parameter in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->52274980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyp1",
 CellLabel->"In[1]:=",
 CellID->14816],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"ctyp1\"\>"}], ":", 
  " ", "\<\"Number \\!\\(1\\) in \\!\\({p, _Real, 1}\\) is an invalid \
compiler variable. A symbol can be used as a valid variable.\"\>"}]], \
"Message", "MSG",
 CellTags->"Compile::ctyp1",
 CellID->145819332],

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Output",
 CellTags->"Compile::ctyp1",
 CellLabel->"Out[1]=",
 CellID->304599591]
}, Open  ]],

Cell["\<\
An explicit type specification for a parameter should be given by including \
the name and the type of the parameter in a list.\
\>", "ExampleText",
 CellID->155535306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"p", ",", "_Real", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"Length", "[", "p", "]"}]}], "]"}]], "Input",
 CellTags->"Compile::ctyp1",
 CellLabel->"In[2]:=",
 CellID->4453],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "p", "}"}], ",", 
    RowBox[{"Length", "[", "p", "]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  
  False,
  Editable->False]], "Output",
 CellTags->"Compile::ctyp1",
 CellLabel->"Out[2]=",
 CellID->20063022]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::ctyp1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 10.2589626}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::ctyp1", "synonyms" -> {}, "title" -> 
    "Compile::ctyp1", "type" -> "Message", "uri" -> "ref/message/ctyp1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3473, 140, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->313128572]},
 "Compile::ctyp1"->{
  Cell[4309, 174, 248, 8, 70, "Input",
   CellTags->"Compile::ctyp1",
   CellID->14816],
  Cell[4560, 184, 286, 7, 70, "Message",
   CellTags->"Compile::ctyp1",
   CellID->145819332],
  Cell[4849, 193, 253, 8, 70, "Output",
   CellTags->"Compile::ctyp1",
   CellID->304599591],
  Cell[5320, 212, 273, 9, 70, "Input",
   CellTags->"Compile::ctyp1",
   CellID->4453],
  Cell[5596, 223, 298, 11, 70, "Output",
   CellTags->"Compile::ctyp1",
   CellID->20063022]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6867, 263},
 {"Compile::ctyp1", 7008, 267}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->11106],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 228, 5, 70, "Message",
 CellID->68431430],
Cell[1489, 56, 233, 8, 70, "Notes",
 CellID->21198],
Cell[1725, 66, 231, 8, 70, "Notes",
 CellID->8340],
Cell[1959, 76, 284, 7, 70, "Notes",
 CellID->31808],
Cell[2246, 85, 797, 31, 70, "Notes",
 CellID->7347],
Cell[3046, 118, 224, 11, 70, "Notes",
 CellID->22950],
Cell[3273, 131, 163, 4, 70, "Notes",
 CellID->24023]
}, Closed]],
Cell[CellGroupData[{
Cell[3473, 140, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313128572],
Cell[CellGroupData[{
Cell[3858, 154, 147, 5, 70, "ExampleSection",
 CellID->70081019],
Cell[4008, 161, 276, 9, 70, "ExampleText",
 CellID->52274980],
Cell[CellGroupData[{
Cell[4309, 174, 248, 8, 70, "Input",
 CellTags->"Compile::ctyp1",
 CellID->14816],
Cell[4560, 184, 286, 7, 70, "Message",
 CellTags->"Compile::ctyp1",
 CellID->145819332],
Cell[4849, 193, 253, 8, 70, "Output",
 CellTags->"Compile::ctyp1",
 CellID->304599591]
}, Open  ]],
Cell[5117, 204, 178, 4, 70, "ExampleText",
 CellID->155535306],
Cell[CellGroupData[{
Cell[5320, 212, 273, 9, 70, "Input",
 CellTags->"Compile::ctyp1",
 CellID->4453],
Cell[5596, 223, 298, 11, 70, "Output",
 CellTags->"Compile::ctyp1",
 CellID->20063022]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5933, 239, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

