(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7036,        257]
NotebookOptionsPosition[      4130,        162]
NotebookOutlinePosition[      5830,        214]
CellTagsIndexPosition[      5709,        208]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Compile::realcoerce", "ObjectName",
 CellID->28484],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"realcoerce\"\>"}], ":", 
  " ", "\<\"Warning: compilation of `1` has coerced an exact number to an \
approximate real number.\"\>"}]], "Message", "MSG",
 CellID->316090923],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " converts an exact number into an inexact real number. "
}], "Notes",
 CellID->19252],

Cell["\<\
This message is used only if a special option for that purpose has been set.\
\>", "Notes",
 CellID->32733]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140081019],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->254456092],

Cell["\<\
A message about coercion is generated in this example if the corresponding \
option has been set.\
\>", "ExampleText",
 CellID->27749931],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOptions", "[", 
   RowBox[{"\"\<CompileOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CompileReportCoercion\>\"", "\[Rule]", "True"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"Compile::realcoerce",
 CellLabel->"In[1]:=",
 CellID->14037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compile", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"1", "+", "Pi"}]}], "]"}]], "Input",
 CellTags->"Compile::realcoerce",
 CellLabel->"In[2]:=",
 CellID->831],

Cell[BoxData[
 RowBox[{
  RowBox[{"Compile", "::", "\<\"realcoerce\"\>"}], ":", 
  " ", "\<\"Warning: compilation of \\!\\(1 + \[Pi]\\) has coerced an exact \
number to an approximate real number.\"\>"}]], "Message", "MSG",
 CellTags->"Compile::realcoerce",
 CellID->260141176],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    RowBox[{"1", "+", "\[Pi]"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 CellTags->"Compile::realcoerce",
 CellLabel->"Out[2]=",
 CellID->1121809]
}, Open  ]],

Cell["Reset the option.", "ExampleText",
 CellID->767626660],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOptions", "[", 
   RowBox[{"\"\<CompileOptions\>\"", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<CompileReportCoercion\>\"", "\[Rule]", "False"}], "}"}]}], 
   "]"}], ";"}]], "Input",
 CellTags->"Compile::realcoerce",
 CellLabel->"In[3]:=",
 CellID->11325]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Compile::realcoerce - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 34.2595770}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Compile::realcoerce", "synonyms" -> {}, "title" -> 
    "Compile::realcoerce", "type" -> "Message", "uri" -> 
    "ref/message/realcoerce"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1891, 74, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->140081019]},
 "Compile::realcoerce"->{
  Cell[2577, 101, 313, 9, 70, "Input",
   CellTags->"Compile::realcoerce",
   CellID->14037],
  Cell[2915, 114, 198, 7, 70, "Input",
   CellTags->"Compile::realcoerce",
   CellID->831],
  Cell[3116, 123, 277, 6, 70, "Message",
   CellTags->"Compile::realcoerce",
   CellID->260141176],
  Cell[3396, 131, 288, 10, 70, "Output",
   CellTags->"Compile::realcoerce",
   CellID->1121809],
  Cell[3762, 147, 314, 9, 70, "Input",
   CellTags->"Compile::realcoerce",
   CellID->11325]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5062, 185},
 {"Compile::realcoerce", 5207, 189}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 57, 1, 70, "ObjectName",
 CellID->28484],
Cell[CellGroupData[{
Cell[785, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1263, 49, 228, 5, 70, "Message",
 CellID->316090923],
Cell[1494, 56, 240, 8, 70, "Notes",
 CellID->19252],
Cell[1737, 66, 117, 3, 70, "Notes",
 CellID->32733]
}, Closed]],
Cell[CellGroupData[{
Cell[1891, 74, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->140081019],
Cell[CellGroupData[{
Cell[2276, 88, 148, 5, 70, "ExampleSection",
 CellID->254456092],
Cell[2427, 95, 147, 4, 70, "ExampleText",
 CellID->27749931],
Cell[2577, 101, 313, 9, 70, "Input",
 CellTags->"Compile::realcoerce",
 CellID->14037],
Cell[CellGroupData[{
Cell[2915, 114, 198, 7, 70, "Input",
 CellTags->"Compile::realcoerce",
 CellID->831],
Cell[3116, 123, 277, 6, 70, "Message",
 CellTags->"Compile::realcoerce",
 CellID->260141176],
Cell[3396, 131, 288, 10, 70, "Output",
 CellTags->"Compile::realcoerce",
 CellID->1121809]
}, Open  ]],
Cell[3699, 144, 60, 1, 70, "ExampleText",
 CellID->767626660],
Cell[3762, 147, 314, 9, 70, "Input",
 CellTags->"Compile::realcoerce",
 CellID->11325]
}, Open  ]]
}, Open  ]],
Cell[4103, 160, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

