(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7663,        282]
NotebookOptionsPosition[      4713,        184]
NotebookOutlinePosition[      6379,        235]
CellTagsIndexPosition[      6261,        229]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Condition::condp", "ObjectName",
 CellID->1311],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Condition", "::", "\<\"condp\"\>"}], ":", 
  " ", "\<\"Pattern `1` appears on the right-hand side of condition \
`2`.\"\>"}]], "Message", "MSG",
 CellID->292570629],

Cell[TextData[{
 "Generated when a pattern expression appears on the right-hand side of a ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " pattern."
}], "Notes",
 CellID->5136],

Cell["\<\
This message is a warning about a use of pattern expressions that is often an \
error. In most useful patterns, pattern expressions will only appear on the \
left-hand side of a condition. \
\>", "Notes",
 CellID->8094],

Cell[TextData[{
 "Pattern expressions associated with this warning are",
 " ",
 "typically entered using the underscore character, such as ",
 StyleBox["p_", "MR"],
 ", and ",
 StyleBox["Condition[", "MR"],
 StyleBox["patt", "TI"],
 StyleBox[", ", "MR"],
 StyleBox["cond", "TI"],
 StyleBox["]", "MR"],
 " is typically entered as ",
 StyleBox["patt", "TI"],
 StyleBox["/;", "MR"],
 StyleBox["cond", "TI"],
 ". This message can be generated if underscore patterns occur within ",
 StyleBox["cond", "TI"],
 "."
}], "Notes",
 CellID->25672]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260433955],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->43319538],

Cell["\<\
A warning message is generated in this example because the pattern expression \
appears in an unusual position in the condition.\
\>", "ExampleText",
 CellID->396351594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"p_", "/;", 
     RowBox[{"EvenQ", "[", "p_", "]"}]}], ")"}], ":>", "0"}]}]], "Input",
 CellTags->"Condition::condp",
 CellLabel->"In[1]:=",
 CellID->3828],

Cell[BoxData[
 RowBox[{
  RowBox[{"Condition", "::", "\<\"condp\"\>"}], ":", 
  " ", "\<\"Pattern \\!\\(p_\\) appears on the right-hand side of condition \
\\!\\(p_/;\\(\\(EvenQ[p_]\\)\\)\\).\"\>"}]], "Message", "MSG",
 CellTags->"Condition::condp",
 CellID->254978989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 CellTags->"Condition::condp",
 CellLabel->"Out[1]=",
 CellID->80095595]
}, Open  ]],

Cell["This shows a more typical use of patterns in a condition.", \
"ExampleText",
 CellID->596385964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"p_", "/;", 
     RowBox[{"EvenQ", "[", "p", "]"}]}], ")"}], ":>", "0"}]}]], "Input",
 CellTags->"Condition::condp",
 CellLabel->"In[2]:=",
 CellID->5930],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "3", ",", "0", ",", "5"}], "}"}]], "Output",
 CellTags->"Condition::condp",
 CellLabel->"Out[2]=",
 CellID->67646310]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Condition::condp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 58, 34.7127136}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Condition::condp", "synonyms" -> {}, "title" -> 
    "Condition::condp", "type" -> "Message", "uri" -> "ref/message/condp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2523, 97, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->260433955]},
 "Condition::condp"->{
  Cell[3262, 126, 307, 10, 70, "Input",
   CellTags->"Condition::condp",
   CellID->3828],
  Cell[3572, 138, 269, 6, 70, "Message",
   CellTags->"Condition::condp",
   CellID->254978989],
  Cell[3844, 146, 176, 5, 70, "Output",
   CellTags->"Condition::condp",
   CellID->80095595],
  Cell[4162, 160, 306, 10, 70, "Input",
   CellTags->"Condition::condp",
   CellID->5930],
  Cell[4471, 172, 176, 5, 70, "Output",
   CellTags->"Condition::condp",
   CellID->67646310]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5626, 206},
 {"Condition::condp", 5768, 210}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 53, 1, 70, "ObjectName",
 CellID->1311],
Cell[CellGroupData[{
Cell[781, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1259, 49, 199, 5, 70, "Message",
 CellID->292570629],
Cell[1461, 56, 254, 8, 70, "Notes",
 CellID->5136],
Cell[1718, 66, 229, 5, 70, "Notes",
 CellID->8094],
Cell[1950, 73, 536, 19, 70, "Notes",
 CellID->25672]
}, Closed]],
Cell[CellGroupData[{
Cell[2523, 97, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->260433955],
Cell[CellGroupData[{
Cell[2908, 111, 147, 5, 70, "ExampleSection",
 CellID->43319538],
Cell[3058, 118, 179, 4, 70, "ExampleText",
 CellID->396351594],
Cell[CellGroupData[{
Cell[3262, 126, 307, 10, 70, "Input",
 CellTags->"Condition::condp",
 CellID->3828],
Cell[3572, 138, 269, 6, 70, "Message",
 CellTags->"Condition::condp",
 CellID->254978989],
Cell[3844, 146, 176, 5, 70, "Output",
 CellTags->"Condition::condp",
 CellID->80095595]
}, Open  ]],
Cell[4035, 154, 102, 2, 70, "ExampleText",
 CellID->596385964],
Cell[CellGroupData[{
Cell[4162, 160, 306, 10, 70, "Input",
 CellTags->"Condition::condp",
 CellID->5930],
Cell[4471, 172, 176, 5, 70, "Output",
 CellTags->"Condition::condp",
 CellID->67646310]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4686, 182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

