(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7976,        309]
NotebookOptionsPosition[      5158,        211]
NotebookOutlinePosition[      6734,        262]
CellTagsIndexPosition[      6625,        256]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["D::dvar", "ObjectName",
 CellID->12944],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "::", "\<\"dvar\"\>"}], ":", 
  " ", "\<\"Multiple derivative specifier `1` does not have the form \
{variable, n}, where n is a non-negative machine integer.\"\>"}]], "Message", \
"MSG",
 CellID->247909782],

Cell[TextData[{
 "Generated when a list argument in ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " has length other than 2."
}], "Notes",
 CellID->26229],

Cell[TextData[{
 "List arguments after the first argument in ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " are assumed to indicate multiple derivatives."
}], "Notes",
 CellID->17097],

Cell[TextData[{
 "A",
 " ",
 "multiple derivative is specified in ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " using a list of the form ",
 StyleBox["{", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 StyleBox[",", "MR"],
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 StyleBox["}", "MR"],
 ", where ",
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 " is the differentiation variable and ",
 StyleBox["n", "MR",
  FontSlant->"Italic"],
 " is the number of derivatives."
}], "Notes",
 CellID->19122]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6355613],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->66189993],

Cell["\<\
An error occurs in this example because the second argument is a list but \
does not have the proper form to specify a multiple derivative.\
\>", "ExampleText",
 CellID->49948861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y", " ", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"D::dvar",
 CellLabel->"In[1]:=",
 CellID->23005],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "::", "\<\"dvar\"\>"}], ":", 
  " ", "\<\"Multiple derivative specifier \\!\\({x, x, z}\\) does not have \
the form {variable, n}, where n is a non-negative machine integer.\"\>"}]], \
"Message", "MSG",
 CellTags->"D::dvar",
 CellID->453611527],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "z"}], "}"}]], 
  RowBox[{"Sin", "[", 
   RowBox[{"x", " ", "y", " ", "z"}], "]"}]}]], "Output",
 CellTags->"D::dvar",
 CellLabel->"Out[1]=",
 CellID->45517319]
}, Open  ]],

Cell[TextData[{
 "This shows a valid differentiation specification in ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->237605923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y", " ", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "2"}], "}"}], ",", "y"}], "]"}]], "Input",
 CellTags->"D::dvar",
 CellLabel->"In[2]:=",
 CellID->20137],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "x"}], " ", 
   SuperscriptBox["y", "2"], " ", 
   SuperscriptBox["z", "3"], " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", " ", "y", " ", "z"}], "]"}]}], "-", 
  RowBox[{"2", " ", "y", " ", 
   SuperscriptBox["z", "2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y", " ", "z"}], "]"}]}]}]], "Output",
 CellTags->"D::dvar",
 CellLabel->"Out[2]=",
 CellID->364309055]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"D::dvar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 22.3701836}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "D::dvar", "synonyms" -> {}, "title" -> "D::dvar", "type" -> 
    "Message", "uri" -> "ref/message/dvar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2575, 106, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6355613]},
 "D::dvar"->{
  Cell[3322, 135, 263, 9, 70, "Input",
   CellTags->"D::dvar",
   CellID->23005],
  Cell[3588, 146, 283, 7, 70, "Message",
   CellTags->"D::dvar",
   CellID->453611527],
  Cell[3874, 155, 264, 9, 70, "Output",
   CellTags->"D::dvar",
   CellID->45517319],
  Cell[4399, 179, 263, 9, 70, "Input",
   CellTags->"D::dvar",
   CellID->20137],
  Cell[4665, 190, 427, 14, 70, "Output",
   CellTags->"D::dvar",
   CellID->364309055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6043, 233},
 {"D::dvar", 6175, 237}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 45, 1, 70, "ObjectName",
 CellID->12944],
Cell[CellGroupData[{
Cell[773, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1251, 49, 246, 6, 70, "Message",
 CellID->247909782],
Cell[1500, 57, 217, 8, 70, "Notes",
 CellID->26229],
Cell[1720, 67, 247, 8, 70, "Notes",
 CellID->17097],
Cell[1970, 77, 568, 24, 70, "Notes",
 CellID->19122]
}, Closed]],
Cell[CellGroupData[{
Cell[2575, 106, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6355613],
Cell[CellGroupData[{
Cell[2958, 120, 147, 5, 70, "ExampleSection",
 CellID->66189993],
Cell[3108, 127, 189, 4, 70, "ExampleText",
 CellID->49948861],
Cell[CellGroupData[{
Cell[3322, 135, 263, 9, 70, "Input",
 CellTags->"D::dvar",
 CellID->23005],
Cell[3588, 146, 283, 7, 70, "Message",
 CellTags->"D::dvar",
 CellID->453611527],
Cell[3874, 155, 264, 9, 70, "Output",
 CellTags->"D::dvar",
 CellID->45517319]
}, Open  ]],
Cell[4153, 167, 221, 8, 70, "ExampleText",
 CellID->237605923],
Cell[CellGroupData[{
Cell[4399, 179, 263, 9, 70, "Input",
 CellTags->"D::dvar",
 CellID->20137],
Cell[4665, 190, 427, 14, 70, "Output",
 CellTags->"D::dvar",
 CellID->364309055]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5131, 209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

