(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7847,        302]
NotebookOptionsPosition[      5539,        224]
NotebookOutlinePosition[      6687,        258]
CellTagsIndexPosition[      6603,        253]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::bvfail
RSolve::bvfail\
\>", "ObjectName",
 CellID->14052],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bvfail\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, unable to solve the \
conditions.\"\>"}]], "Message", "MSG",
 CellID->219120736],

Cell["\<\
Generated when the boundary conditions do not lead to equations which can be \
used to find the values of the arbitrary constants in the general solution.\
\>", "Notes",
 CellID->28277]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53896130],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->89483475],

Cell[TextData[{
 "An error occurs in this example because the boundary condition ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["y", "TI"], "[", "1", "]"}], ",", " ", 
     RowBox[{
      StyleBox["y", "TI"], "[", "1", "]"}]}], "]"}], " ", "==", "5"}]], 
  "InlineFormula"],
 " ",
 "does not lead to an equation which can be used to find the values of the \
arbitrary constants in the general solution."
}], "ExampleText",
 CellID->31122],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", "x"}], "&&", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"y", "[", "1", "]"}], ",", " ", 
       RowBox[{"y", "[", "1", "]"}]}], "]"}], "\[Equal]", "5"}]}], ",", " ", 
   "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30807],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvfail\"\>"}], ":", 
  " ", "\<\"For some branches of the general solution, unable to solve the \
conditions.\"\>"}]], "Message", "MSG",
 CellID->56427297],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->9828336]
}, Open  ]],

Cell[TextData[{
 "If we replace this boundary condition with one which is a polynomial \
function of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", "1", "]"}]], "InlineFormula"],
 ", then the example works fine."
}], "ExampleText",
 CellID->26942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", "x"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "1", "]"}], "+", 
       RowBox[{
        RowBox[{"y", "[", "1", "]"}], "^", "2"}]}], "\[Equal]", "5"}]}], ",", 
    " ", "y", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31614],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "-", 
          SqrtBox["21"], "+", 
          SuperscriptBox["x", "2"]}], ")"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "2"}], "+", 
          SqrtBox["21"], "+", 
          SuperscriptBox["x", "2"]}], ")"}]}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->30226531]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "1", "]"}], "+", 
    RowBox[{
     RowBox[{"y", "[", "1", "]"}], "^", "2"}]}], "/.", "sol"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13750],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "5"}], "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->22537117]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::bvfail - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 55.0116442}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::bvfail RSolve::bvfail", "synonyms" -> {}, "title" -> 
    "DSolve::bvfail", "type" -> "Message", "uri" -> "ref/message/bvfail"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1749, 69, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->53896130]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6462, 246}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 75, 4, 70, "ObjectName",
 CellID->14052],
Cell[CellGroupData[{
Cell[803, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1281, 52, 233, 6, 70, "Message",
 CellID->219120736],
Cell[1517, 60, 195, 4, 70, "Notes",
 CellID->28277]
}, Closed]],
Cell[CellGroupData[{
Cell[1749, 69, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->53896130],
Cell[CellGroupData[{
Cell[2133, 83, 147, 5, 70, "ExampleSection",
 CellID->89483475],
Cell[2283, 90, 505, 16, 70, "ExampleText",
 CellID->31122],
Cell[CellGroupData[{
Cell[2813, 110, 411, 14, 70, "Input",
 CellID->30807],
Cell[3227, 126, 210, 5, 70, "Message",
 CellID->56427297],
Cell[3440, 133, 86, 3, 70, "Output",
 CellID->9828336]
}, Open  ]],
Cell[3541, 139, 258, 8, 70, "ExampleText",
 CellID->26942],
Cell[CellGroupData[{
Cell[3824, 151, 436, 15, 70, "Input",
 CellID->31614],
Cell[4263, 168, 820, 29, 70, "Output",
 CellID->30226531]
}, Open  ]],
Cell[CellGroupData[{
Cell[5120, 202, 235, 9, 70, "Input",
 CellID->13750],
Cell[5358, 213, 115, 4, 70, "Output",
 CellID->22537117]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5512, 222, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

