(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9549,        362]
NotebookOptionsPosition[      7075,        278]
NotebookOutlinePosition[      8218,        312]
CellTagsIndexPosition[      8134,        307]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::bvimp
RSolve::bvimp\
\>", "ObjectName",
 CellID->23745],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bvimp\"\>"}], ":", 
  " ", "\<\"General solution contains implicit solutions. In the boundary \
value problem these solutions will be ignored, so some of the solutions will \
be lost.\"\>"}]], "Message", "MSG",
 CellID->51186375],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is unable to solve for the boundary conditions using a general solution \
which is in implicit form."
}], "Notes",
 CellID->30799]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42888192],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->166415142],

Cell["\<\
The general solution of the following nonlinear second order ODE is in \
implicit form.\
\>", "ExampleText",
 CellID->17999],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{
   RowBox[{"InverseFunction", "::", "ifun"}], ",", " ", 
   RowBox[{"Solve", "::", "ifun"}], ",", " ", 
   RowBox[{"Solve", "::", "tdep"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"y", "[", "x", "]"}], "-", "x"}], ")"}], "*", 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "\[Equal]", "0"}], 
    "}"}], ",", " ", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9986],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "-", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], 
      RowBox[{"ProductLog", "[", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"C", "[", "1", "]"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "x"}], "+", 
          RowBox[{"y", "[", "x", "]"}]}], ")"}]}], "]"}]]}], "\[Equal]", 
    RowBox[{"C", "[", "2", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->325692320]
}, Open  ]],

Cell[TextData[{
 "Hence, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " is unable to solve the following boundary value problem for the ODE."
}], "ExampleText",
 CellID->17958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "[", "x", "]"}], "-", "x"}], ")"}], "*", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "\[Equal]", "0"}],
      ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "2"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "5"}]}], "}"}], ",", 
   " ", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8578],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvimp\"\>"}], ":", 
  " ", "\<\"General solution contains implicit solutions. In the boundary \
value problem these solutions will be ignored, so some of the solutions will \
be lost.\"\>"}]], "Message", "MSG",
 CellID->237870578],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->223143796]
}, Open  ]],

Cell[TextData[{
 "In this example a numerical solution can be obtained using ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->11840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "[", "x", "]"}], "-", "x"}], ")"}], "*", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}], "\[Equal]", "0"}],
      ",", " ", 
     RowBox[{
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "2"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "1", "]"}], "\[Equal]", "5"}]}], "}"}], ",", 
   " ", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15629],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "3.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[4]=",
 CellID->900997337]
}, Open  ]],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{
   RowBox[{"InverseFunction", "::", "ifun"}], ",", " ", 
   RowBox[{"Solve", "::", "ifun"}], ",", " ", 
   RowBox[{"Solve", "::", "tdep"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->3905]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::bvimp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 55.1522728}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::bvimp RSolve::bvimp", "synonyms" -> {}, "title" -> 
    "DSolve::bvimp", "type" -> "Message", "uri" -> "ref/message/bvimp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1909, 75, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->42888192]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7993, 300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 73, 4, 70, "ObjectName",
 CellID->23745],
Cell[CellGroupData[{
Cell[801, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1279, 52, 306, 7, 70, "Message",
 CellID->51186375],
Cell[1588, 61, 284, 9, 70, "Notes",
 CellID->30799]
}, Closed]],
Cell[CellGroupData[{
Cell[1909, 75, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->42888192],
Cell[CellGroupData[{
Cell[2293, 89, 148, 5, 70, "ExampleSection",
 CellID->166415142],
Cell[2444, 96, 134, 4, 70, "ExampleText",
 CellID->17999],
Cell[2581, 102, 244, 7, 70, "Input",
 CellID->11001],
Cell[CellGroupData[{
Cell[2850, 113, 483, 17, 70, "Input",
 CellID->9986],
Cell[3336, 132, 647, 21, 70, "Output",
 CellID->325692320]
}, Open  ]],
Cell[3998, 156, 250, 8, 70, "ExampleText",
 CellID->17958],
Cell[CellGroupData[{
Cell[4273, 168, 697, 24, 70, "Input",
 CellID->8578],
Cell[4973, 194, 285, 6, 70, "Message",
 CellID->237870578],
Cell[5261, 202, 88, 3, 70, "Output",
 CellID->223143796]
}, Open  ]],
Cell[5364, 208, 236, 8, 70, "ExampleText",
 CellID->11840],
Cell[CellGroupData[{
Cell[5625, 220, 758, 26, 70, "Input",
 CellID->15629],
Cell[6386, 248, 378, 14, 70, "Output",
 CellID->900997337]
}, Open  ]],
Cell[6779, 265, 242, 7, 70, "Input",
 CellID->3905]
}, Open  ]]
}, Open  ]],
Cell[7048, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

