(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9689,        362]
NotebookOptionsPosition[      7128,        274]
NotebookOutlinePosition[      8275,        308]
CellTagsIndexPosition[      8191,        303]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::bvsing
RSolve::bvsing\
\>", "ObjectName",
 CellID->25022],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"bvsing\"\>"}], ":", 
  " ", "\<\"Unable to resolve some of the arbitrary constants in the general \
solution using the given boundary conditions. It is possible that some of the \
conditions have been specified at a singular point for the equation.\"\>"}]], \
"Message", "MSG",
 CellID->7468371],

Cell["\<\
Generated when the given boundary conditions are not sufficient to fix all \
the arbitrary constants in the general solution.\
\>", "Notes",
 CellID->13034]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->141559622],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->191365280],

Cell[TextData[{
 "An error occurs because the initial conditions are specified at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], " ", "==", " ", "0"}]], "InlineFormula"],
 ", which is a singular point for the ODE. As a result, the solution depends \
on the arbitrary constant ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->25623],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "x"], "+", 
      FractionBox[
       RowBox[{"y", "[", "x", "]"}], "x"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14020],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"DSolve", "[", 
    RowBox[{"eq", ",", " ", "y", ",", " ", "x"}], "]"}], " "}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->24308],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"bvsing\"\>"}], ":", 
  " ", "\<\"Unable to resolve some of the arbitrary constants in the general \
solution using the given boundary conditions. It is possible that some of the \
conditions have been specified at a singular point for the equation.\"\>"}]], \
"Message", "MSG",
 CellID->569910078],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", "x"], "-", 
       RowBox[{"C", "[", "2", "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "2", "]"}]}], "-", 
       RowBox[{"x", " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->134247563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"eq", " ", "/.", " ", "sol"}], " ", "//", " ", "Simplify", " "}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[3]:=",
 CellID->1932],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->86227794]
}, Open  ]],

Cell["\<\
This problem can be avoided by specifying the boundary conditions at a nearby \
non-singular point.\
\>", "ExampleText",
 CellID->7746],

Cell[BoxData[
 RowBox[{
  RowBox[{"eq1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["y", "\[Prime]\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", "x"}], ")"}], " ", 
        RowBox[{
         SuperscriptBox["y", "\[Prime]",
          MultilineFunction->None], "[", "x", "]"}]}], "x"], "+", 
      FractionBox[
       RowBox[{"y", "[", "x", "]"}], "x"]}], "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"y", "[", 
      FractionBox["1", "1000"], "]"}], "\[Equal]", "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", 
      FractionBox["1", "1000"], "]"}], "\[Equal]", "1"}]}]}], ";"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->22818],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"DSolve", "[", 
    RowBox[{"eq1", ",", " ", "y", ",", " ", "x"}], "]"}], " "}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[5]:=",
 CellID->8712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "1000"]}], "+", "x"}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->84986266]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"eq1", "/.", " ", "sol"}], " ", "//", " ", "Simplify", " "}],
  FormatType->StandardForm]], "Input",
 CellLabel->"In[6]:=",
 CellID->10422],

Cell[BoxData[
 RowBox[{"{", "True", "}"}]], "Output",
 CellLabel->"Out[6]=",
 CellID->794592530]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::bvsing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 2.4180838}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::bvsing RSolve::bvsing", "synonyms" -> {}, "title" -> 
    "DSolve::bvsing", "type" -> "Message", "uri" -> "ref/message/bvsing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1859, 71, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->141559622]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8049, 296}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 75, 4, 70, "ObjectName",
 CellID->25022],
Cell[CellGroupData[{
Cell[803, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1281, 52, 372, 8, 70, "Message",
 CellID->7468371],
Cell[1656, 62, 166, 4, 70, "Notes",
 CellID->13034]
}, Closed]],
Cell[CellGroupData[{
Cell[1859, 71, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->141559622],
Cell[CellGroupData[{
Cell[2244, 85, 148, 5, 70, "ExampleSection",
 CellID->191365280],
Cell[2395, 92, 460, 14, 70, "ExampleText",
 CellID->25623],
Cell[2858, 108, 793, 26, 70, "Input",
 CellID->14020],
Cell[CellGroupData[{
Cell[3676, 138, 226, 7, 70, "Input",
 CellID->24308],
Cell[3905, 147, 352, 7, 70, "Message",
 CellID->569910078],
Cell[4260, 156, 527, 16, 70, "Output",
 CellID->134247563]
}, Open  ]],
Cell[CellGroupData[{
Cell[4824, 177, 189, 6, 70, "Input",
 CellID->1932],
Cell[5016, 185, 95, 3, 70, "Output",
 CellID->86227794]
}, Open  ]],
Cell[5126, 191, 145, 4, 70, "ExampleText",
 CellID->7746],
Cell[5274, 197, 849, 28, 70, "Input",
 CellID->22818],
Cell[CellGroupData[{
Cell[6148, 229, 226, 7, 70, "Input",
 CellID->8712],
Cell[6377, 238, 363, 13, 70, "Output",
 CellID->84986266]
}, Open  ]],
Cell[CellGroupData[{
Cell[6777, 256, 186, 6, 70, "Input",
 CellID->10422],
Cell[6966, 264, 96, 3, 70, "Output",
 CellID->794592530]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7101, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

