(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11778,        391]
NotebookOptionsPosition[      7046,        260]
NotebookOutlinePosition[     10358,        346]
CellTagsIndexPosition[     10177,        338]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::conarg
NDSolve::conarg
RSolve::conarg\
\>", "ObjectName",
 CellID->27978],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"conarg\"\>"}], ":", 
  " ", "\<\"The arguments should be ordered consistently.\"\>"}]], "Message", \
"MSG",
 CellID->234897611],

Cell["\<\
Generated when the function arguments in the specification of an equation \
occur in different orders in different parts of the equation.\
\>", "Notes",
 CellID->23523],

Cell["\<\
The cause of this error can in most cases be readily identified by inspecting \
the input to be sure that the solution function is always specified in the \
same way.\
\>", "Notes",
 CellID->31821]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->681011629],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->792699710],

Cell["\<\
This example generates an error because the arguments of the solution \
function are given in the opposite order on the right-hand side of the \
differential equation.\
\>", "ExampleText",
 CellID->626303211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}], "==", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"t", ",", "x"}], "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellLabel->"In[1]:=",
 CellID->30231],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"conarg\"\>"}], ":", 
  " ", "\<\"The arguments should be ordered consistently.\"\>"}]], "Message", \
"MSG",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->84784701],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"2", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"x", ",", "t"}], "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", 
          RowBox[{"1", ",", "0"}], ")"}],
         Derivative],
        MultilineFunction->None], "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", "x"}]}]}], "}"}], ",", 
   "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellLabel->"Out[1]=",
 CellID->6890502]
}, Open  ]],

Cell["\<\
This shows a correct specification of the partial differential equation.\
\>", "ExampleText",
 CellID->592646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}], "==", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"0", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"1", ",", "t"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "0"}], "]"}], "==", 
      RowBox[{"x", 
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}]}]}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellLabel->"In[2]:=",
 CellID->24623],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}]}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellLabel->"Out[2]=",
 CellID->601508793]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::conarg - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 2.5743378}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::conarg NDSolve::conarg RSolve::conarg", 
    "synonyms" -> {}, "title" -> "DSolve::conarg", "type" -> "Message", "uri" -> 
    "ref/message/conarg"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1929, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->681011629]},
 "DSolve::conarg"->{
  Cell[2708, 107, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->30231],
  Cell[3733, 141, 250, 6, 70, "Message",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->84784701],
  Cell[3986, 149, 1267, 42, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->6890502],
  Cell[5413, 201, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->24623],
  Cell[6438, 235, 542, 18, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->601508793]},
 "NDSolve::conarg"->{
  Cell[2708, 107, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->30231],
  Cell[3733, 141, 250, 6, 70, "Message",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->84784701],
  Cell[3986, 149, 1267, 42, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->6890502],
  Cell[5413, 201, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->24623],
  Cell[6438, 235, 542, 18, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->601508793]},
 "RSolve::conarg"->{
  Cell[2708, 107, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->30231],
  Cell[3733, 141, 250, 6, 70, "Message",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->84784701],
  Cell[3986, 149, 1267, 42, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->6890502],
  Cell[5413, 201, 1022, 32, 70, "Input",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->24623],
  Cell[6438, 235, 542, 18, 70, "Output",
   CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
   CellID->601508793]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7988, 283},
 {"DSolve::conarg", 8128, 287},
 {"NDSolve::conarg", 8811, 303},
 {"RSolve::conarg", 9493, 319}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 5, 70, "ObjectName",
 CellID->27978],
Cell[CellGroupData[{
Cell[819, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 53, 204, 6, 70, "Message",
 CellID->234897611],
Cell[1504, 61, 178, 4, 70, "Notes",
 CellID->23523],
Cell[1685, 67, 207, 5, 70, "Notes",
 CellID->31821]
}, Closed]],
Cell[CellGroupData[{
Cell[1929, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->681011629],
Cell[CellGroupData[{
Cell[2314, 91, 148, 5, 70, "ExampleSection",
 CellID->792699710],
Cell[2465, 98, 218, 5, 70, "ExampleText",
 CellID->626303211],
Cell[CellGroupData[{
Cell[2708, 107, 1022, 32, 70, "Input",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->30231],
Cell[3733, 141, 250, 6, 70, "Message",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->84784701],
Cell[3986, 149, 1267, 42, 70, "Output",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->6890502]
}, Open  ]],
Cell[5268, 194, 120, 3, 70, "ExampleText",
 CellID->592646],
Cell[CellGroupData[{
Cell[5413, 201, 1022, 32, 70, "Input",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->24623],
Cell[6438, 235, 542, 18, 70, "Output",
 CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"},
 CellID->601508793]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[7019, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

