(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10177,        362]
NotebookOptionsPosition[      6587,        251]
NotebookOutlinePosition[      8920,        319]
CellTagsIndexPosition[      8775,        312]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::der1
NDSolve::der1\
\>", "ObjectName",
 CellID->20904],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"der1\"\>"}], ":", 
  " ", "\<\"The derivative operator `1` in `2` should operate on only one \
function.\"\>"}]], "Message", "MSG",
 CellID->64941835],

Cell[TextData[{
 "Generated by an invalid ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " expression in the first argument of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21289]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37073297],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115740491],

Cell[TextData[{
 "An error occurs in this example because ",
 StyleBox["Derivative[1][f,g][x]", "MR"],
 " shows differentiation of both ",
 StyleBox["f", "MR"],
 " and ",
 StyleBox["g", "MR"],
 "."
}], "ExampleText",
 CellID->491830448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", 
        RowBox[{"f", ",", "g"}], "]"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellLabel->"In[1]:=",
 CellID->26941],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"der1\"\>"}], ":", 
  " ", "\<\"The derivative operator \\!\\(Derivative[1]\\) in \\!\\(\\(\\(\\(\
\\(Derivative[1]\\)\\)[\\(\\(f, g\\)\\)]\\)\\)[x]\\) should operate on only \
one function.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->134542371],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", 
        RowBox[{"f", ",", "g"}], "]"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["g", "\[Prime]",
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellLabel->"Out[1]=",
 CellID->1846696]
}, Open  ]],

Cell[TextData[{
 "This shows a valid input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->152575395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x", 
       "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", ",", "g"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellLabel->"In[2]:=",
 CellID->2171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"g", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellLabel->"Out[2]=",
 CellID->285455220]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::der1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 2.9805982}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::der1 NDSolve::der1", "synonyms" -> {}, "title" -> 
    "DSolve::der1", "type" -> "Message", "uri" -> "ref/message/der1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2029, 83, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37073297]},
 "DSolve::der1"->{
  Cell[2825, 117, 781, 24, 70, "Input",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->26941],
  Cell[3609, 143, 338, 7, 70, "Message",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->134542371],
  Cell[3950, 152, 830, 25, 70, "Output",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->1846696],
  Cell[5029, 192, 759, 24, 70, "Input",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->2171],
  Cell[5791, 218, 730, 26, 70, "Output",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->285455220]},
 "NDSolve::der1"->{
  Cell[2825, 117, 781, 24, 70, "Input",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->26941],
  Cell[3609, 143, 338, 7, 70, "Message",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->134542371],
  Cell[3950, 152, 830, 25, 70, "Output",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->1846696],
  Cell[5029, 192, 759, 24, 70, "Input",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->2171],
  Cell[5791, 218, 730, 26, 70, "Output",
   CellTags->{"DSolve::der1", "NDSolve::der1"},
   CellID->285455220]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7499, 273},
 {"DSolve::der1", 7636, 277},
 {"NDSolve::der1", 8204, 293}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 72, 4, 70, "ObjectName",
 CellID->20904],
Cell[CellGroupData[{
Cell[800, 35, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1278, 52, 227, 6, 70, "Message",
 CellID->64941835],
Cell[1508, 60, 484, 18, 70, "Notes",
 CellID->21289]
}, Closed]],
Cell[CellGroupData[{
Cell[2029, 83, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37073297],
Cell[CellGroupData[{
Cell[2413, 97, 148, 5, 70, "ExampleSection",
 CellID->115740491],
Cell[2564, 104, 236, 9, 70, "ExampleText",
 CellID->491830448],
Cell[CellGroupData[{
Cell[2825, 117, 781, 24, 70, "Input",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->26941],
Cell[3609, 143, 338, 7, 70, "Message",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->134542371],
Cell[3950, 152, 830, 25, 70, "Output",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->1846696]
}, Open  ]],
Cell[4795, 180, 209, 8, 70, "ExampleText",
 CellID->152575395],
Cell[CellGroupData[{
Cell[5029, 192, 759, 24, 70, "Input",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->2171],
Cell[5791, 218, 730, 26, 70, "Output",
 CellTags->{"DSolve::der1", "NDSolve::der1"},
 CellID->285455220]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6560, 249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

