(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10147,        374]
NotebookOptionsPosition[      5946,        247]
NotebookOutlinePosition[      8427,        315]
CellTagsIndexPosition[      8249,        307]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::dsvar
NDSolve::dsvar
RSolve::dsvar\
\>", "ObjectName",
 CellID->8654],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"dsvar\"\>"}], ":", 
  " ", "\<\"`1` cannot be used as a variable.\"\>"}]], "Message", "MSG",
 CellID->1079885],

Cell[TextData[{
 "Generated when the indicated expression cannot be used as a variable in ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->20993],

Cell["\<\
Most expressions other than numbers, strings, products, sums, and powers can \
be used as variables.\
\>", "Notes",
 CellID->15117],

Cell[TextData[{
 "The variable is specified in the third argument of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " for ordinary differential equations."
}], "Notes",
 CellID->13398]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20596872],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->17221102],

Cell["\<\
An error occurs in this example because a product cannot be used as a \
variable.\
\>", "ExampleText",
 CellID->364573408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "'"}], "[", 
     RowBox[{"2", "x"}], "]"}], "==", "1"}], ",", "f", ",", 
   RowBox[{"2", "x"}]}], "]"}]], "Input",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellLabel->"In[1]:=",
 CellID->9936],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"dsvar\"\>"}], ":", 
  " ", "\<\"\\!\\(2\\\\ x\\) cannot be used as a variable.\"\>"}]], "Message",\
 "MSG",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellID->126190349],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["f", "\[Prime]",
      MultilineFunction->None], "[", 
     RowBox[{"2", " ", "x"}], "]"}], "\[Equal]", "1"}], ",", "f", ",", 
   RowBox[{"2", " ", "x"}]}], "]"}]], "Output",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellLabel->"Out[1]=",
 CellID->456169783]
}, Open  ]],

Cell["\<\
An error occurs in this example because the independent variable has been \
assigned a value previously.\
\>", "ExampleText",
 CellID->925351994],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->320660748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", "1"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->83145732],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"dsvar\"\>"}], ":", 
  " ", "\<\"\\!\\(5\\) cannot be used as a variable.\"\>"}]], "Message", \
"MSG",
 CellID->465159257],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["y", "\[Prime]",
      MultilineFunction->None], "[", "5", "]"}], "\[Equal]", "1"}], ",", "y", 
   ",", "5"}], "]"}]], "Output",
 CellLabel->"Out[3]=",
 CellID->398212478]
}, Open  ]],

Cell["The solution is to clear x.", "ExampleText",
 CellID->623329790],

Cell[BoxData[
 RowBox[{"Clear", "[", "x", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->43598448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", "1"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->381036528],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"x", "+", 
       RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[5]=",
 CellID->675860838]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::dsvar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 3.5274872}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::dsvar NDSolve::dsvar RSolve::dsvar", 
    "synonyms" -> {}, "title" -> "DSolve::dsvar", "type" -> "Message", "uri" -> 
    "ref/message/dsvar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2539, 104, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20596872]},
 "DSolve::dsvar"->{
  Cell[3230, 133, 311, 10, 70, "Input",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->9936],
  Cell[3544, 145, 247, 6, 70, "Message",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->126190349],
  Cell[3794, 153, 377, 11, 70, "Output",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->456169783]},
 "NDSolve::dsvar"->{
  Cell[3230, 133, 311, 10, 70, "Input",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->9936],
  Cell[3544, 145, 247, 6, 70, "Message",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->126190349],
  Cell[3794, 153, 377, 11, 70, "Output",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->456169783]},
 "RSolve::dsvar"->{
  Cell[3230, 133, 311, 10, 70, "Input",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->9936],
  Cell[3544, 145, 247, 6, 70, "Message",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->126190349],
  Cell[3794, 153, 377, 11, 70, "Output",
   CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
   CellID->456169783]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6882, 270},
 {"DSolve::dsvar", 7021, 274},
 {"NDSolve::dsvar", 7430, 284},
 {"RSolve::dsvar", 7838, 294}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 87, 5, 70, "ObjectName",
 CellID->8654],
Cell[CellGroupData[{
Cell[815, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1293, 53, 187, 5, 70, "Message",
 CellID->1079885],
Cell[1483, 60, 490, 18, 70, "Notes",
 CellID->20993],
Cell[1976, 80, 141, 4, 70, "Notes",
 CellID->15117],
Cell[2120, 86, 382, 13, 70, "Notes",
 CellID->13398]
}, Closed]],
Cell[CellGroupData[{
Cell[2539, 104, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20596872],
Cell[CellGroupData[{
Cell[2923, 118, 147, 5, 70, "ExampleSection",
 CellID->17221102],
Cell[3073, 125, 132, 4, 70, "ExampleText",
 CellID->364573408],
Cell[CellGroupData[{
Cell[3230, 133, 311, 10, 70, "Input",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellID->9936],
Cell[3544, 145, 247, 6, 70, "Message",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellID->126190349],
Cell[3794, 153, 377, 11, 70, "Output",
 CellTags->{"DSolve::dsvar", "NDSolve::dsvar", "RSolve::dsvar"},
 CellID->456169783]
}, Open  ]],
Cell[4186, 167, 155, 4, 70, "ExampleText",
 CellID->925351994],
Cell[4344, 173, 110, 4, 70, "Input",
 CellID->320660748],
Cell[CellGroupData[{
Cell[4479, 181, 220, 8, 70, "Input",
 CellID->83145732],
Cell[4702, 191, 176, 5, 70, "Message",
 CellID->465159257],
Cell[4881, 198, 266, 9, 70, "Output",
 CellID->398212478]
}, Open  ]],
Cell[5162, 210, 70, 1, 70, "ExampleText",
 CellID->623329790],
Cell[5235, 213, 100, 3, 70, "Input",
 CellID->43598448],
Cell[CellGroupData[{
Cell[5360, 220, 221, 8, 70, "Input",
 CellID->381036528],
Cell[5584, 230, 296, 10, 70, "Output",
 CellID->675860838]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5919, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

