(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9687,        325]
NotebookOptionsPosition[      5017,        196]
NotebookOutlinePosition[      8321,        282]
CellTagsIndexPosition[      8140,        274]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::dvleaf
NDSolve::dvleaf
RSolve::dvleaf\
\>", "ObjectName",
 CellID->10931],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"dvleaf\"\>"}], ":", 
  " ", "\<\"The function `1` appears as the head of the expression \
`2`.\"\>"}]], "Message", "MSG",
 CellID->347299620],

Cell["\<\
Generated when a function is used incorrectly in an equation.\
\>", "Notes",
 CellID->23490]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->900279030],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->152079453],

Cell["\<\
An error occurs in this example because the initial condition is not given in \
a valid form.\
\>", "ExampleText",
 CellID->306848053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "0", "]"}], "[", "0", "]"}], "==", "1"}]}], "}"}], 
   ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellLabel->"In[1]:=",
 CellID->11156],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"dvleaf\"\>"}], ":", 
  " ", "\<\"The function \\!\\(f[0]\\) appears as the head of the expression \
\\!\\(\\(\\(f[0]\\)\\)[0]\\).\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->282323022],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "+", 
       RowBox[{
        SuperscriptBox["f", "\[Prime]",
         MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "0", "]"}], "[", "0", "]"}], "\[Equal]", "1"}]}], 
    "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellLabel->"Out[1]=",
 CellID->54706621]
}, Open  ]],

Cell["\<\
This shows a valid initial condition for this differential equation.\
\>", "ExampleText",
 CellID->58869192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"f", "'"}], "[", "x", "]"}], "+", 
       RowBox[{"f", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"f", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellLabel->"In[2]:=",
 CellID->3660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellLabel->"Out[2]=",
 CellID->697448173]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::dvleaf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 10.2776600}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::dvleaf NDSolve::dvleaf RSolve::dvleaf", 
    "synonyms" -> {}, "title" -> "DSolve::dvleaf", "type" -> "Message", "uri" -> 
    "ref/message/dvleaf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1657, 69, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->900279030]},
 "DSolve::dvleaf"->{
  Cell[2362, 98, 548, 18, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->11156],
  Cell[2913, 118, 300, 6, 70, "Message",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->282323022],
  Cell[3216, 126, 618, 20, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->54706621],
  Cell[3992, 156, 510, 16, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->3660],
  Cell[4505, 174, 446, 15, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->697448173]},
 "NDSolve::dvleaf"->{
  Cell[2362, 98, 548, 18, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->11156],
  Cell[2913, 118, 300, 6, 70, "Message",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->282323022],
  Cell[3216, 126, 618, 20, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->54706621],
  Cell[3992, 156, 510, 16, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->3660],
  Cell[4505, 174, 446, 15, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->697448173]},
 "RSolve::dvleaf"->{
  Cell[2362, 98, 548, 18, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->11156],
  Cell[2913, 118, 300, 6, 70, "Message",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->282323022],
  Cell[3216, 126, 618, 20, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->54706621],
  Cell[3992, 156, 510, 16, 70, "Input",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->3660],
  Cell[4505, 174, 446, 15, 70, "Output",
   CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
   CellID->697448173]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5960, 219},
 {"DSolve::dvleaf", 6100, 223},
 {"NDSolve::dvleaf", 6780, 239},
 {"RSolve::dvleaf", 7459, 255}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 91, 5, 70, "ObjectName",
 CellID->10931],
Cell[CellGroupData[{
Cell[819, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1297, 53, 218, 6, 70, "Message",
 CellID->347299620],
Cell[1518, 61, 102, 3, 70, "Notes",
 CellID->23490]
}, Closed]],
Cell[CellGroupData[{
Cell[1657, 69, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->900279030],
Cell[CellGroupData[{
Cell[2042, 83, 148, 5, 70, "ExampleSection",
 CellID->152079453],
Cell[2193, 90, 144, 4, 70, "ExampleText",
 CellID->306848053],
Cell[CellGroupData[{
Cell[2362, 98, 548, 18, 70, "Input",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->11156],
Cell[2913, 118, 300, 6, 70, "Message",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->282323022],
Cell[3216, 126, 618, 20, 70, "Output",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->54706621]
}, Open  ]],
Cell[3849, 149, 118, 3, 70, "ExampleText",
 CellID->58869192],
Cell[CellGroupData[{
Cell[3992, 156, 510, 16, 70, "Input",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->3660],
Cell[4505, 174, 446, 15, 70, "Output",
 CellTags->{"DSolve::dvleaf", "NDSolve::dvleaf", "RSolve::dvleaf"},
 CellID->697448173]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4990, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

