(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6861,        264]
NotebookOptionsPosition[      4678,        191]
NotebookOutlinePosition[      5841,        226]
CellTagsIndexPosition[      5757,        221]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::ivar2
NDSolve::ivar2
RSolve::ivar2\
\>", "ObjectName",
 CellID->32519],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ivar2\"\>"}], ":", 
  " ", "\<\"The independent variable `1` should not appear in two different \
arguments of the dependent variable `2`.\"\>"}]], "Message", "MSG",
 CellID->919128677],

Cell["\<\
Generated when an independent variable occurs in more than one argument of a \
dependent variable.\
\>", "Notes",
 CellID->11642]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->113146969],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->390026705],

Cell[TextData[{
 "An error occurs because the independent variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " appears in both arguments of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", " ", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->23442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", 
      RowBox[{"x", ",", "x"}], "]"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "[", 
     RowBox[{"x", ",", "x"}], "]"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"ivar2\"\>"}], ":", 
  " ", "\<\"The independent variable \\!\\(x\\) should not appear in two \
different arguments of the dependent variable \\!\\(y[\\(\\(x, x\\)\\)]\\).\"\
\>"}]], "Message", "MSG",
 CellID->19299162],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["y", "\[Prime]",
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "x"}], "]"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "[", 
     RowBox[{"x", ",", "x"}], "]"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Output",
 CellLabel->"Out[1]=",
 CellID->164455652]
}, Open  ]],

Cell[TextData[{
 "The problem can be avoided by specifying ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " in the second argument."
}], "ExampleText",
 CellID->28276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "[", "x", "]"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22033],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{"x", "+", 
     RowBox[{"C", "[", "1", "]"}]}]}], "}"}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->110634281]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::ivar2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 10.6057934}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::ivar2 NDSolve::ivar2 RSolve::ivar2", 
    "synonyms" -> {}, "title" -> "DSolve::ivar2", "type" -> "Message", "uri" -> 
    "ref/message/ivar2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1735, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->113146969]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5615, 214}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 88, 5, 70, "ObjectName",
 CellID->32519],
Cell[CellGroupData[{
Cell[816, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1294, 53, 262, 6, 70, "Message",
 CellID->919128677],
Cell[1559, 61, 139, 4, 70, "Notes",
 CellID->11642]
}, Closed]],
Cell[CellGroupData[{
Cell[1735, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->113146969],
Cell[CellGroupData[{
Cell[2120, 84, 148, 5, 70, "ExampleSection",
 CellID->390026705],
Cell[2271, 91, 358, 13, 70, "ExampleText",
 CellID->23442],
Cell[CellGroupData[{
Cell[2654, 108, 369, 13, 70, "Input",
 CellID->721],
Cell[3026, 123, 273, 6, 70, "Message",
 CellID->19299162],
Cell[3302, 131, 421, 14, 70, "Output",
 CellID->164455652]
}, Open  ]],
Cell[3738, 148, 296, 11, 70, "ExampleText",
 CellID->28276],
Cell[CellGroupData[{
Cell[4059, 163, 318, 11, 70, "Input",
 CellID->22033],
Cell[4380, 176, 232, 8, 70, "Output",
 CellID->110634281]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4651, 189, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

