(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10525,        362]
NotebookOptionsPosition[      5511,        213]
NotebookOutlinePosition[      9091,        314]
CellTagsIndexPosition[      8899,        306]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::ndord
NDSolve::ndord
NDSolve`Reinitialize::ndord\
\>", "ObjectName",
 CellID->6463],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ndord\"\>"}], ":", 
  " ", "\<\"Derivative order `1` in term `2` should be a non-negative \
machine-sized integer.\"\>"}]], "Message", "MSG",
 CellID->200245077],

Cell["\<\
Generated when the order of the derivative in a differential equation is not \
an integer.\
\>", "Notes",
 CellID->20390]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105124901],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->168629585],

Cell[TextData[{
 "An error occurs in this example because of an incorrect use of ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " in the input."
}], "ExampleText",
 CellID->182819326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "f", "]"}], "[", "f", "]"}], "[", "x", 
       "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellLabel->"In[1]:=",
 CellID->14751],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"ndord\"\>"}], ":", 
  " ", "\<\"Derivative order \\!\\(f\\) in term \
\\!\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", TagBox[\\((f)\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[x]\\) should be a non-negative \
machine-sized integer.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->603745652],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["f", 
        TagBox[
         RowBox[{"(", "f", ")"}],
         Derivative],
        MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "f", ",",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Output",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellLabel->"Out[1]=",
 CellID->419964697]
}, Open  ]],

Cell[TextData[{
 "This shows a valid specification of a derivative in the input to ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->763041470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", "1", "]"}], "[", "f", "]"}], "[", "x", 
       "]"}], "==", 
      RowBox[{"f", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "1", "]"}], "==", "1"}]}], "}"}], ",", "f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellLabel->"In[2]:=",
 CellID->21522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"1.`", ",", "2.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellLabel->"Out[2]=",
 CellID->18534986]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::ndord - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 11.0276792}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::ndord NDSolve::ndord NDSolve`Reinitialize::ndord", 
    "synonyms" -> {}, "title" -> "DSolve::ndord", "type" -> "Message", "uri" -> 
    "ref/message/ndord"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1716, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->105124901]},
 "DSolve::ndord"->{
  Cell[2540, 103, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->14751],
  Cell[3098, 123, 420, 9, 70, "Message",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->603745652],
  Cell[3521, 134, 622, 21, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->419964697],
  Cell[4429, 170, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->21522],
  Cell[4987, 190, 458, 16, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->18534986]},
 "NDSolve::ndord"->{
  Cell[2540, 103, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->14751],
  Cell[3098, 123, 420, 9, 70, "Message",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->603745652],
  Cell[3521, 134, 622, 21, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->419964697],
  Cell[4429, 170, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->21522],
  Cell[4987, 190, 458, 16, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->18534986]},
 "NDSolve`Reinitialize::ndord"->{
  Cell[2540, 103, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->14751],
  Cell[3098, 123, 420, 9, 70, "Message",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->603745652],
  Cell[3521, 134, 622, 21, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->419964697],
  Cell[4429, 170, 555, 18, 70, "Input",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->21522],
  Cell[4987, 190, 458, 16, 70, "Output",
   CellTags->{
    "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
   CellID->18534986]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6462, 236},
 {"DSolve::ndord", 6601, 240},
 {"NDSolve::ndord", 7362, 261},
 {"NDSolve`Reinitialize::ndord", 8136, 282}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 101, 5, 70, "ObjectName",
 CellID->6463],
Cell[CellGroupData[{
Cell[829, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1307, 53, 238, 6, 70, "Message",
 CellID->200245077],
Cell[1548, 61, 131, 4, 70, "Notes",
 CellID->20390]
}, Closed]],
Cell[CellGroupData[{
Cell[1716, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->105124901],
Cell[CellGroupData[{
Cell[2101, 84, 148, 5, 70, "ExampleSection",
 CellID->168629585],
Cell[2252, 91, 263, 8, 70, "ExampleText",
 CellID->182819326],
Cell[CellGroupData[{
Cell[2540, 103, 555, 18, 70, "Input",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->14751],
Cell[3098, 123, 420, 9, 70, "Message",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->603745652],
Cell[3521, 134, 622, 21, 70, "Output",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->419964697]
}, Open  ]],
Cell[4158, 158, 246, 8, 70, "ExampleText",
 CellID->763041470],
Cell[CellGroupData[{
Cell[4429, 170, 555, 18, 70, "Input",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->21522],
Cell[4987, 190, 458, 16, 70, "Output",
 CellTags->{"DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"},
 
 CellID->18534986]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5484, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

