(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10185,        332]
NotebookOptionsPosition[      5382,        203]
NotebookOutlinePosition[      8794,        289]
CellTagsIndexPosition[      8607,        281]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
DSolve::underdet
NDSolve::underdet
RSolve::underdet\
\>", "ObjectName",
 CellID->7023],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"underdet\"\>"}], ":", 
  " ", "\<\"There are more dependent variables than equations, so the system \
is underdetermined.\"\>"}]], "Message", "MSG",
 CellID->7090042],

Cell["\<\
Generated when the first argument of the indicated function does not include \
enough equations to specify a solution.\
\>", "Notes",
 CellID->28539]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->695198275],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->101096426],

Cell[TextData[{
 "An error message is generated in this example because a single equation is \
not sufficient to determine both ",
 StyleBox["f[x]", "MR"],
 " and ",
 StyleBox["g[x]", "MR"],
 "."
}], "ExampleText",
 CellID->519484932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellLabel->"In[1]:=",
 CellID->10297],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"underdet\"\>"}], ":", 
  " ", "\<\"There are more dependent variables than equations, so the system \
is underdetermined.\"\>"}]], "Message", "MSG",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->608829],

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["f", "\[Prime]",
       MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Output",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellLabel->"Out[1]=",
 CellID->773090485]
}, Open  ]],

Cell["This computes a general solution.", "ExampleText",
 CellID->618632366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"f", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"g", "[", "x", "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"g", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"-", 
       RowBox[{"f", "[", "x", "]"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"g", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellLabel->"In[2]:=",
 CellID->3203],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"g", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Cos", "[", "x", "]"}]}], "-", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}]}]}], "}"}], "}"}]], "Output",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellLabel->"Out[2]=",
 CellID->94570556]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve::underdet - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 0, 18.6997506}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "DSolve::underdet NDSolve::underdet RSolve::underdet", 
    "synonyms" -> {}, "title" -> "DSolve::underdet", "type" -> "Message", 
    "uri" -> "ref/message/underdet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1744, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->695198275]},
 "DSolve::underdet"->{
  Cell[2539, 103, 456, 14, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->10297],
  Cell[2998, 119, 294, 6, 70, "Message",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->608829],
  Cell[3295, 127, 506, 15, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->773090485],
  Cell[3917, 150, 627, 20, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->3203],
  Cell[4547, 172, 769, 24, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->94570556]},
 "NDSolve::underdet"->{
  Cell[2539, 103, 456, 14, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->10297],
  Cell[2998, 119, 294, 6, 70, "Message",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->608829],
  Cell[3295, 127, 506, 15, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->773090485],
  Cell[3917, 150, 627, 20, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->3203],
  Cell[4547, 172, 769, 24, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->94570556]},
 "RSolve::underdet"->{
  Cell[2539, 103, 456, 14, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->10297],
  Cell[2998, 119, 294, 6, 70, "Message",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->608829],
  Cell[3295, 127, 506, 15, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->773090485],
  Cell[3917, 150, 627, 20, 70, "Input",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->3203],
  Cell[4547, 172, 769, 24, 70, "Output",
   CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
   CellID->94570556]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6337, 226},
 {"DSolve::underdet", 6479, 230},
 {"NDSolve::underdet", 7189, 246},
 {"RSolve::underdet", 7898, 262}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 96, 5, 70, "ObjectName",
 CellID->7023],
Cell[CellGroupData[{
Cell[824, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1302, 53, 243, 6, 70, "Message",
 CellID->7090042],
Cell[1548, 61, 159, 4, 70, "Notes",
 CellID->28539]
}, Closed]],
Cell[CellGroupData[{
Cell[1744, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->695198275],
Cell[CellGroupData[{
Cell[2129, 84, 148, 5, 70, "ExampleSection",
 CellID->101096426],
Cell[2280, 91, 234, 8, 70, "ExampleText",
 CellID->519484932],
Cell[CellGroupData[{
Cell[2539, 103, 456, 14, 70, "Input",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->10297],
Cell[2998, 119, 294, 6, 70, "Message",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->608829],
Cell[3295, 127, 506, 15, 70, "Output",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->773090485]
}, Open  ]],
Cell[3816, 145, 76, 1, 70, "ExampleText",
 CellID->618632366],
Cell[CellGroupData[{
Cell[3917, 150, 627, 20, 70, "Input",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->3203],
Cell[4547, 172, 769, 24, 70, "Output",
 CellTags->{"DSolve::underdet", "NDSolve::underdet", "RSolve::underdet"},
 CellID->94570556]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5355, 201, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

