(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6501,        240]
NotebookOptionsPosition[      3776,        150]
NotebookOutlinePosition[      5355,        198]
CellTagsIndexPosition[      5236,        192]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Derivative::novar", "ObjectName",
 CellID->25559],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "::", "\<\"novar\"\>"}], ":", 
  " ", "\<\"`1` cannot be interpreted. A partial derivative requires a \
subscript differentiation variable.\"\>"}]], "Message", "MSG",
 CellID->298757219],

Cell["\<\
Generated when a typeset partial differentiation operator is used without \
specifying a variable.\
\>", "Notes",
 CellID->19384],

Cell[TextData[{
 "The partial differentiation operator \[PartialD] can be entered using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]pd\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ", ",
 Cell["\\[PartialD]", "InlineCharacterName"],
 ", or a palette. The variable or variables are specified using subscripts."
}], "Notes",
 CellID->19321]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313187005],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->154529170],

Cell["\<\
An error occurs in this example because the \[PartialD] operator is used \
without specifying a variable.\
\>", "ExampleText",
 CellID->683168682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[PartialD]", 
  RowBox[{"(", 
   RowBox[{"3", "x"}], ")"}]}]], "Input",
 EmphasizeSyntaxErrors->True,
 CellTags->"Derivative::novar",
 CellLabel->"In[1]:=",
 CellID->24511],

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "::", "\<\"novar\"\>"}], ":", 
  " ", "\<\"\\!\\(\[PartialD] \\(\\((3 x)\\)\\)\\) cannot be interpreted. A \
partial derivative requires a subscript differentiation variable.\"\>"}]], \
"Message", "MSG",
 CellTags->"Derivative::novar",
 CellID->188693227]
}, Open  ]],

Cell["\<\
This shows a correct use of the partial differentiation operator.\
\>", "ExampleText",
 CellID->180663668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[PartialD]", "x"], 
  RowBox[{"(", 
   RowBox[{"3", "x"}], ")"}]}]], "Input",
 CellTags->"Derivative::novar",
 CellLabel->"In[2]:=",
 CellID->18079],

Cell[BoxData["3"], "Output",
 CellTags->"Derivative::novar",
 CellLabel->"Out[2]=",
 CellID->9621726]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Derivative::novar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 18, 59, 31.1360330}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Derivative::novar", "synonyms" -> {}, "title" -> 
    "Derivative::novar", "type" -> "Message", "uri" -> "ref/message/novar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2041, 76, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->313187005]},
 "Derivative::novar"->{
  Cell[2758, 105, 197, 7, 70, "Input",
   CellTags->"Derivative::novar",
   CellID->24511],
  Cell[2958, 114, 303, 7, 70, "Message",
   CellTags->"Derivative::novar",
   CellID->188693227],
  Cell[3417, 131, 189, 7, 70, "Input",
   CellTags->"Derivative::novar",
   CellID->18079],
  Cell[3609, 140, 101, 3, 70, "Output",
   CellTags->"Derivative::novar",
   CellID->9621726]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4692, 172},
 {"Derivative::novar", 4835, 176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 55, 1, 70, "ObjectName",
 CellID->25559],
Cell[CellGroupData[{
Cell[783, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1261, 49, 234, 5, 70, "Message",
 CellID->298757219],
Cell[1498, 56, 139, 4, 70, "Notes",
 CellID->19384],
Cell[1640, 62, 364, 9, 70, "Notes",
 CellID->19321]
}, Closed]],
Cell[CellGroupData[{
Cell[2041, 76, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->313187005],
Cell[CellGroupData[{
Cell[2426, 90, 148, 5, 70, "ExampleSection",
 CellID->154529170],
Cell[2577, 97, 156, 4, 70, "ExampleText",
 CellID->683168682],
Cell[CellGroupData[{
Cell[2758, 105, 197, 7, 70, "Input",
 CellTags->"Derivative::novar",
 CellID->24511],
Cell[2958, 114, 303, 7, 70, "Message",
 CellTags->"Derivative::novar",
 CellID->188693227]
}, Open  ]],
Cell[3276, 124, 116, 3, 70, "ExampleText",
 CellID->180663668],
Cell[CellGroupData[{
Cell[3417, 131, 189, 7, 70, "Input",
 CellTags->"Derivative::novar",
 CellID->18079],
Cell[3609, 140, 101, 3, 70, "Output",
 CellTags->"Derivative::novar",
 CellID->9621726]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3749, 148, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

